/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.octavia.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import org.openstack4j.model.octavia.LbMethod;
import org.openstack4j.model.octavia.LbPoolV2Update;
import org.openstack4j.model.octavia.SessionPersistence;
import org.openstack4j.model.octavia.builder.LbPoolV2UpdateBuilder;

@JsonRootName(value="pool")
@JsonIgnoreProperties(ignoreUnknown=true)
public class OctaviaLbPoolV2Update
implements LbPoolV2Update {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp = true;
    @JsonProperty(value="lb_algorithm")
    private LbMethod lbMethod;
    @JsonProperty(value="session_persistence")
    private SessionPersistence sessionPersistence;

    public static LbPoolV2UpdateBuilder builder() {
        return new LbPoolV2UpdateContreteBuilder();
    }

    @Override
    public LbPoolV2UpdateBuilder toBuilder() {
        return new LbPoolV2UpdateContreteBuilder(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public LbMethod getLbMethod() {
        return this.lbMethod;
    }

    @Override
    public SessionPersistence getSessionPersistence() {
        return this.sessionPersistence;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("adminStateUp", this.adminStateUp).add("description", this.description).add("lbMethod", (Object)this.lbMethod).add("name", this.name).toString();
    }

    public static class LbPoolV2UpdateContreteBuilder
    implements LbPoolV2UpdateBuilder {
        private OctaviaLbPoolV2Update m;

        public LbPoolV2UpdateContreteBuilder() {
            this(new OctaviaLbPoolV2Update());
        }

        public LbPoolV2UpdateContreteBuilder(OctaviaLbPoolV2Update m) {
            this.m = m;
        }

        @Override
        public LbPoolV2Update build() {
            return this.m;
        }

        @Override
        public LbPoolV2UpdateContreteBuilder from(LbPoolV2Update in) {
            this.m = (OctaviaLbPoolV2Update)in;
            return this;
        }

        @Override
        public LbPoolV2UpdateContreteBuilder lbMethod(LbMethod lbMethod) {
            this.m.lbMethod = lbMethod;
            return this;
        }

        @Override
        public LbPoolV2UpdateContreteBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public LbPoolV2UpdateContreteBuilder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public LbPoolV2UpdateBuilder sessionPersistence(SessionPersistence sessionPersistence) {
            this.m.sessionPersistence = sessionPersistence;
            return this;
        }

        @Override
        public LbPoolV2UpdateContreteBuilder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }
    }
}

