/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.octavia.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.octavia.HealthMonitorV2Service;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.octavia.HealthMonitorV2;
import org.openstack4j.model.octavia.HealthMonitorV2Update;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.octavia.domain.OctaviaHealthMonitorV2;
import org.openstack4j.openstack.octavia.internal.BaseOctaviaServices;

public class HealthMonitorV2ServiceImpl
extends BaseOctaviaServices
implements HealthMonitorV2Service {
    @Override
    public List<? extends HealthMonitorV2> list() {
        return this.get(OctaviaHealthMonitorV2.HealthMonitorsV2.class, this.uri("/lbaas/healthmonitors", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends HealthMonitorV2> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<OctaviaHealthMonitorV2.HealthMonitorsV2> req = this.get(OctaviaHealthMonitorV2.HealthMonitorsV2.class, this.uri("/lbaas/healthmonitors", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public HealthMonitorV2 get(String healthMonitorId) {
        Preconditions.checkNotNull(healthMonitorId);
        return this.get(OctaviaHealthMonitorV2.class, this.uri("/lbaas/healthmonitors/%s", healthMonitorId)).execute();
    }

    @Override
    public ActionResponse delete(String healthMonitorId) {
        Preconditions.checkNotNull(healthMonitorId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/lbaas/healthmonitors/%s", healthMonitorId)).executeWithResponse());
    }

    @Override
    public HealthMonitorV2 create(HealthMonitorV2 healthMonitor) {
        Preconditions.checkNotNull(healthMonitor);
        return this.post(OctaviaHealthMonitorV2.class, this.uri("/lbaas/healthmonitors", new Object[0])).entity(healthMonitor).execute();
    }

    @Override
    public HealthMonitorV2 update(String healthMonitorId, HealthMonitorV2Update healthMonitor) {
        Preconditions.checkNotNull(healthMonitorId);
        Preconditions.checkNotNull(healthMonitor);
        return this.put(OctaviaHealthMonitorV2.class, this.uri("/lbaas/healthmonitors/%s", healthMonitorId)).entity(healthMonitor).execute();
    }
}

