/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.compute.Image;
import org.openstack4j.model.sahara.Cluster;
import org.openstack4j.model.sahara.NodeGroup;
import org.openstack4j.model.sahara.ServiceConfig;
import org.openstack4j.model.sahara.ServiceInfo;
import org.openstack4j.model.sahara.builder.ClusterBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.sahara.domain.SaharaNodeGroup;
import org.openstack4j.openstack.sahara.domain.SaharaServiceConfig;
import org.openstack4j.openstack.sahara.domain.SaharaServiceInfo;

@JsonRootName(value="cluster")
@JsonIgnoreProperties(ignoreUnknown=true)
public class SaharaCluster
implements Cluster {
    private static final long serialVersionUID = 1L;
    private Cluster.Status status;
    @JsonProperty(value="info")
    private Map<String, SaharaServiceInfo> infos;
    @JsonProperty(value="cluster_template_id")
    private String clusterTemplateId;
    @JsonProperty(value="is_transient")
    private Boolean isTransient;
    private String description;
    @JsonProperty(value="cluster_configs")
    private Map<String, SaharaServiceConfig> clusterConfigs;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date createdAt;
    @JsonProperty(value="default_image_id")
    private String defaultImageId;
    @JsonProperty(value="user_keypair_id")
    private String userKeypairId;
    @JsonProperty(value="updated_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date updatedAt;
    @JsonProperty(value="plugin_name")
    private String pluginName;
    @JsonProperty(value="neutron_management_network")
    private String managementNetworkId;
    @JsonProperty(value="anti_affinity")
    private List<String> antiAffinity;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="node_groups")
    private List<SaharaNodeGroup> nodeGroups;
    @JsonProperty(value="management_public_key")
    private String managementPublicKey;
    @JsonProperty(value="status_description")
    private String statusDescription;
    @JsonProperty(value="hadoop_version")
    private String hadoopVersion;
    private String id;
    @JsonProperty(value="trust_id")
    private String trustId;
    private String name;

    public static ClusterBuilder builder() {
        return new ConcreteClusterBuilder();
    }

    @Override
    public Cluster.Status getStatus() {
        return this.status;
    }

    @Override
    public Map<String, ? extends ServiceInfo> getInfos() {
        return this.infos;
    }

    @Override
    public String getClusterTemplateId() {
        return this.clusterTemplateId;
    }

    @Override
    public Boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Map<String, ? extends ServiceConfig> getClusterConfigs() {
        return this.clusterConfigs;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getDefaultImageId() {
        return this.defaultImageId;
    }

    @Override
    public String getUserKeypairId() {
        return this.userKeypairId;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public String getManagementNetworkId() {
        return this.managementNetworkId;
    }

    @Override
    public List<String> getAntiAffinity() {
        return this.antiAffinity;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public List<? extends NodeGroup> getNodeGroups() {
        return this.nodeGroups;
    }

    @Override
    public String getManagementPublicKey() {
        return this.managementPublicKey;
    }

    @Override
    public String getStatusDescription() {
        return this.statusDescription;
    }

    @Override
    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTrustId() {
        return this.trustId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("name", this.name).add("description", this.description).add("status", (Object)this.status).add("created_at", this.createdAt).add("updated_at", this.updatedAt).add("tenant_id", this.tenantId).add("cluster_template_id", this.clusterTemplateId).add("is_transient", this.isTransient).add("default_image_id", this.defaultImageId).add("user_keypair_id", this.userKeypairId).add("plugin_name", this.pluginName).add("neutron_management_network", this.managementNetworkId).add("cluster_configs", this.clusterConfigs).add("anti_affinity", this.antiAffinity).add("node_groups", this.nodeGroups).add("management_public_key", this.managementPublicKey).add("status_description", this.statusDescription).add("hadoop_version", this.hadoopVersion).add("trust_id", this.trustId).add("info", this.infos).toString();
    }

    @Override
    public ClusterBuilder toBuilder() {
        return new ConcreteClusterBuilder(this);
    }

    public static class ConcreteClusterBuilder
    implements ClusterBuilder {
        SaharaCluster m;

        ConcreteClusterBuilder() {
            this(new SaharaCluster());
        }

        ConcreteClusterBuilder(SaharaCluster m) {
            this.m = m;
        }

        @Override
        public ClusterBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public ClusterBuilder hadoopVersion(String hadoopVersion) {
            this.m.hadoopVersion = hadoopVersion;
            return this;
        }

        @Override
        public ClusterBuilder pluginName(String pluginName) {
            this.m.pluginName = pluginName;
            return this;
        }

        @Override
        public ClusterBuilder template(String clusterTemplateId) {
            this.m.clusterTemplateId = clusterTemplateId;
            return this;
        }

        @Override
        public ClusterBuilder image(String imageId) {
            this.m.defaultImageId = imageId;
            return this;
        }

        public ClusterBuilder image(Image image) {
            this.m.defaultImageId = image.getId();
            return this;
        }

        @Override
        public ClusterBuilder keypairName(String keypairName) {
            this.m.userKeypairId = keypairName;
            return this;
        }

        @Override
        public ClusterBuilder managementNetworkId(String networkId) {
            this.m.managementNetworkId = networkId;
            return this;
        }

        @Override
        public ClusterBuilder addNodeGroup(NodeGroup nodeGroup) {
            if (this.m.nodeGroups == null) {
                this.m.nodeGroups = Lists.newArrayList();
            }
            this.m.nodeGroups.add((SaharaNodeGroup)nodeGroup);
            return this;
        }

        @Override
        public ClusterBuilder addServiceConfig(String name, ServiceConfig config) {
            if (name != null && !name.isEmpty()) {
                if (this.m.clusterConfigs == null) {
                    this.m.clusterConfigs = new HashMap();
                }
                this.m.clusterConfigs.put(name, (SaharaServiceConfig)config);
            }
            return this;
        }

        @Override
        public Cluster build() {
            return this.m;
        }

        @Override
        public ClusterBuilder from(Cluster in) {
            this.m = (SaharaCluster)in;
            return this;
        }
    }

    public static class Clusters
    extends ListResult<SaharaCluster> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="clusters")
        private List<SaharaCluster> clusters;

        @Override
        public List<SaharaCluster> value() {
            return this.clusters;
        }
    }
}

