/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.sahara.NodeGroupTemplateService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.sahara.NodeGroupTemplate;
import org.openstack4j.openstack.sahara.domain.SaharaNodeGroupTemplate;
import org.openstack4j.openstack.sahara.domain.SaharaNodeGroupTemplateUnwrapped;
import org.openstack4j.openstack.sahara.internal.BaseSaharaServices;

public class NodeGroupTemplateServiceImpl
extends BaseSaharaServices
implements NodeGroupTemplateService {
    @Override
    public List<? extends NodeGroupTemplate> list() {
        return this.get(SaharaNodeGroupTemplate.NodeGroupTemplates.class, this.uri("/node-group-templates", new Object[0])).execute().getList();
    }

    @Override
    public NodeGroupTemplate get(String templateId) {
        Preconditions.checkNotNull(templateId);
        return this.get(SaharaNodeGroupTemplate.class, this.uri("/node-group-templates/%s", templateId)).execute();
    }

    @Override
    public NodeGroupTemplate create(NodeGroupTemplate template) {
        Preconditions.checkNotNull(template);
        SaharaNodeGroupTemplateUnwrapped unwrapped = new SaharaNodeGroupTemplateUnwrapped(template);
        return this.post(SaharaNodeGroupTemplate.class, this.uri("/node-group-templates", new Object[0])).entity(unwrapped).execute();
    }

    @Override
    public ActionResponse delete(String templateId) {
        Preconditions.checkNotNull(templateId);
        return this.deleteWithResponse(this.uri("/node-group-templates/%s", templateId)).execute();
    }
}

