/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.storage.block.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import org.openstack4j.model.storage.block.VolumeTypeEncryption;
import org.openstack4j.model.storage.block.builder.VolumeTypeEncryptionBuilder;
import org.openstack4j.openstack.storage.block.domain.CinderVolumeTypeEncryption;

public class AbstractCinderVolumeTypeEncryption
implements VolumeTypeEncryption {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="encryption_id")
    protected String id;
    @JsonProperty(value="provider")
    protected String provider;
    @JsonProperty(value="control_location")
    protected String controlLocation;
    @JsonProperty(value="cipher")
    protected String cipher;
    @JsonProperty(value="key_size")
    protected Integer keySize;
    @JsonProperty(value="volume_type_id")
    protected String volumeTypeId;

    public static VolumeTypeEncryptionBuilder builder() {
        return new VolumeTypeEncryptionConcreteBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public String getVolumeTypeId() {
        return this.volumeTypeId;
    }

    @Override
    public String getCipher() {
        return this.cipher;
    }

    @Override
    public Integer getKeySize() {
        return this.keySize;
    }

    @Override
    public String getControlLocation() {
        return this.controlLocation;
    }

    @Override
    public VolumeTypeEncryptionBuilder toBuilder() {
        return new VolumeTypeEncryptionConcreteBuilder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("volumeTypeId", this.volumeTypeId).add("provider", this.provider).add("cipher", this.cipher).add("keySize", this.keySize).add("controlLocation", this.controlLocation).toString();
    }

    public static class VolumeTypeEncryptionConcreteBuilder
    implements VolumeTypeEncryptionBuilder {
        private CinderVolumeTypeEncryption cinderVolumeTypeEncryption;

        VolumeTypeEncryptionConcreteBuilder() {
            this(new CinderVolumeTypeEncryption());
        }

        VolumeTypeEncryptionConcreteBuilder(VolumeTypeEncryption volumeTypeEncryption) {
            this.cinderVolumeTypeEncryption = (CinderVolumeTypeEncryption)volumeTypeEncryption;
        }

        @Override
        public VolumeTypeEncryption build() {
            return this.cinderVolumeTypeEncryption;
        }

        @Override
        public VolumeTypeEncryptionBuilder from(VolumeTypeEncryption in) {
            this.cinderVolumeTypeEncryption = (CinderVolumeTypeEncryption)in;
            return this;
        }

        @Override
        public VolumeTypeEncryptionBuilder provider(String provider) {
            this.cinderVolumeTypeEncryption.provider = provider;
            return this;
        }

        @Override
        public VolumeTypeEncryptionBuilder id(String id) {
            this.cinderVolumeTypeEncryption.id = id;
            return this;
        }

        @Override
        public VolumeTypeEncryptionBuilder volumeTypeId(String volTypeId) {
            this.cinderVolumeTypeEncryption.volumeTypeId = volTypeId;
            return this;
        }

        @Override
        public VolumeTypeEncryptionBuilder cipher(String cipher) {
            this.cinderVolumeTypeEncryption.cipher = cipher;
            return this;
        }

        @Override
        public VolumeTypeEncryptionBuilder keySize(Integer keySize) {
            this.cinderVolumeTypeEncryption.keySize = keySize;
            return this;
        }

        @Override
        public VolumeTypeEncryptionBuilder controlLocation(String controlLocation) {
            this.cinderVolumeTypeEncryption.controlLocation = controlLocation;
            return this;
        }
    }
}

