/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.storage.block.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.storage.block.VolumeType;
import org.openstack4j.model.storage.block.builder.VolumeTypeBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="volume_type")
public class CinderVolumeType
implements VolumeType {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    @JsonProperty(value="extra_specs")
    private Map<String, String> extraSpecs;

    public static VolumeTypeBuilder builder() {
        return new ConcreteVolumeTypeBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getExtraSpecs() {
        return this.extraSpecs;
    }

    @Override
    public VolumeTypeBuilder toBuilder() {
        return new ConcreteVolumeTypeBuilder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("name", this.name).add("extras", this.extraSpecs).toString();
    }

    public static class ConcreteVolumeTypeBuilder
    implements VolumeTypeBuilder {
        private CinderVolumeType m;

        ConcreteVolumeTypeBuilder() {
            this(new CinderVolumeType());
        }

        ConcreteVolumeTypeBuilder(CinderVolumeType volumeType) {
            this.m = volumeType;
        }

        @Override
        public VolumeType build() {
            return this.m;
        }

        @Override
        public VolumeTypeBuilder from(VolumeType in) {
            this.m = (CinderVolumeType)in;
            return this;
        }

        @Override
        public VolumeTypeBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public VolumeTypeBuilder extraSpecs(Map<String, String> extraSpecs) {
            this.m.extraSpecs = extraSpecs;
            return this;
        }
    }

    public static class VolumeTypes
    extends ListResult<CinderVolumeType> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="volume_types")
        private List<CinderVolumeType> types;

        @Override
        protected List<CinderVolumeType> value() {
            return this.types;
        }
    }
}

