/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.storage.object.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.openstack4j.api.storage.ObjectStorageAccountService;
import org.openstack4j.model.storage.object.SwiftAccount;
import org.openstack4j.openstack.storage.object.functions.MetadataToHeadersFunction;
import org.openstack4j.openstack.storage.object.functions.ParseAccountFunction;
import org.openstack4j.openstack.storage.object.internal.BaseObjectStorageService;

public class ObjectStorageAccountServiceImpl
extends BaseObjectStorageService
implements ObjectStorageAccountService {
    @Override
    public SwiftAccount get() {
        return ParseAccountFunction.INSTANCE.apply(this.head(Void.class, new String[0]).executeWithResponse());
    }

    @Override
    public boolean updateMetadata(Map<String, String> metadata) {
        Preconditions.checkNotNull(metadata);
        return this.invokeMetadata("X-Account-Meta-", metadata);
    }

    @Override
    public boolean deleteMetadata(Map<String, String> metadata) {
        Preconditions.checkNotNull(metadata);
        return this.invokeMetadata("X-Remove-Account-Meta-", metadata);
    }

    @Override
    public boolean updateTemporaryUrlKey(String temporaryUrlKey) {
        Preconditions.checkNotNull(temporaryUrlKey);
        return this.isResponseSuccess(this.post(Void.class, new String[0]).header("X-Account-Meta-Temp-Url-Key", temporaryUrlKey).executeWithResponse(), 204);
    }

    private boolean invokeMetadata(String prefix, Map<String, String> metadata) {
        return this.isResponseSuccess(this.post(Void.class, new String[0]).headers(MetadataToHeadersFunction.create(prefix).apply(metadata)).executeWithResponse(), 204);
    }
}

