/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.tacker.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.model.tacker.Vim;
import org.openstack4j.model.tacker.builder.VimBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.tacker.domain.AuthCredentials;
import org.openstack4j.openstack.tacker.domain.TackerVimStatus;
import org.openstack4j.openstack.tacker.domain.VimPlacementAttribute;
import org.openstack4j.openstack.tacker.domain.VimProject;

@JsonRootName(value="vim")
@JsonIgnoreProperties(ignoreUnknown=true)
public class TackerVim
implements Vim {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String description;
    private String type;
    private TackerVimStatus status;
    @JsonProperty(value="is_default")
    private Boolean isDefault;
    @JsonProperty(value="auth_cred")
    private AuthCredentials authCredentials;
    @JsonProperty(value="auth_url")
    private String authUrl;
    @JsonProperty(value="placement_attr")
    private VimPlacementAttribute placementAttribute;
    @JsonProperty(value="vim_project")
    private VimProject vimProject;

    public static VimBuilder builder() {
        return new VimConcreteBuilder();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("name", this.name).add("tenantId", this.tenantId).add("description", this.description).add("type", this.type).add("status", (Object)this.status).add("isDefault", this.isDefault).add("authCredentials", this.authCredentials).add("authUrl", this.authUrl).add("placementAttribute", this.placementAttribute).add("vimProject", this.vimProject).toString();
    }

    @Override
    public VimBuilder toBuilder() {
        return new VimConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public TackerVimStatus getStatus() {
        return this.status;
    }

    @Override
    public Boolean isDefault() {
        return null;
    }

    @Override
    public AuthCredentials getAuthCredentials() {
        return this.authCredentials;
    }

    @Override
    public String getAuthUrl() {
        return this.authUrl;
    }

    @Override
    public VimPlacementAttribute getPlacementAttribute() {
        return this.placementAttribute;
    }

    @Override
    public VimProject getVimProject() {
        return this.vimProject;
    }

    public static class VimConcreteBuilder
    implements VimBuilder {
        TackerVim vim;

        public VimConcreteBuilder() {
            this(new TackerVim());
        }

        public VimConcreteBuilder(TackerVim f) {
            this.vim = f;
        }

        @Override
        public Vim build() {
            return this.vim;
        }

        @Override
        public VimBuilder from(Vim in) {
            this.vim = (TackerVim)in;
            return this;
        }

        @Override
        public VimBuilder name(String name) {
            this.vim.name = name;
            return this;
        }

        @Override
        public VimBuilder description(String description) {
            this.vim.description = description;
            return this;
        }

        @Override
        public VimBuilder authUrl(String authUrl) {
            this.vim.authUrl = authUrl;
            return this;
        }

        @Override
        public VimBuilder vimProject(VimProject vimProject) {
            this.vim.vimProject = vimProject;
            return this;
        }

        @Override
        public VimBuilder isDefault(Boolean isDefault) {
            this.vim.isDefault = isDefault;
            return this;
        }

        @Override
        public VimBuilder authCredentials(AuthCredentials authCredentials) {
            this.vim.authCredentials = authCredentials;
            return this;
        }

        @Override
        public VimBuilder type(String type) {
            this.vim.type = type;
            return this;
        }
    }

    public static class TackerVims
    extends ListResult<TackerVim> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="vims")
        List<TackerVim> vims;

        @Override
        public List<TackerVim> value() {
            return this.vims;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("vims", this.vims).toString();
        }
    }
}

