/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.telemetry.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.telemetry.MeterService;
import org.openstack4j.model.telemetry.Meter;
import org.openstack4j.model.telemetry.MeterSample;
import org.openstack4j.model.telemetry.SampleCriteria;
import org.openstack4j.model.telemetry.Statistics;
import org.openstack4j.openstack.common.ListEntity;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.telemetry.domain.CeilometerMeter;
import org.openstack4j.openstack.telemetry.domain.CeilometerMeterSample;
import org.openstack4j.openstack.telemetry.domain.CeilometerStatistics;
import org.openstack4j.openstack.telemetry.internal.BaseTelemetryServices;

public class MeterServiceImpl
extends BaseTelemetryServices
implements MeterService {
    private static final String FIELD = "q.field";
    private static final String OPER = "q.op";
    private static final String VALUE = "q.value";
    private static final String LIMIT = "limit";

    @Override
    public List<? extends Meter> list() {
        CeilometerMeter[] meters = this.get(CeilometerMeter[].class, this.uri("/meters", new Object[0])).execute();
        return this.wrapList(meters);
    }

    @Override
    public List<? extends MeterSample> samples(String meterName) {
        Preconditions.checkNotNull(meterName);
        CeilometerMeterSample[] samples = this.get(CeilometerMeterSample[].class, this.uri("/meters/%s", meterName)).execute();
        return this.wrapList(samples);
    }

    @Override
    public List<? extends MeterSample> samples(String meterName, SampleCriteria criteria) {
        Preconditions.checkNotNull(meterName);
        Preconditions.checkNotNull(criteria);
        BaseOpenStackService.Invocation<CeilometerMeterSample[]> invocation = this.get(CeilometerMeterSample[].class, this.uri("/meters/%s", meterName));
        if (criteria.getLimit() > 0) {
            invocation.param(LIMIT, criteria.getLimit());
        }
        if (!criteria.getCriteriaParams().isEmpty()) {
            for (SampleCriteria.NameOpValue c : criteria.getCriteriaParams()) {
                invocation.param(FIELD, c.getField());
                invocation.param(OPER, c.getOperator().getQueryValue());
                invocation.param(VALUE, c.getValue());
            }
        }
        CeilometerMeterSample[] samples = invocation.execute();
        return this.wrapList(samples);
    }

    @Override
    public List<? extends Statistics> statistics(String meterName) {
        return this.statistics(meterName, null, 0);
    }

    @Override
    public List<? extends Statistics> statistics(String meterName, int period) {
        return this.statistics(meterName, null, period);
    }

    @Override
    public List<? extends Statistics> statistics(String meterName, SampleCriteria criteria) {
        return this.statistics(meterName, criteria, 0);
    }

    @Override
    public List<? extends Statistics> statistics(String meterName, SampleCriteria criteria, int period) {
        Preconditions.checkNotNull(meterName);
        Preconditions.checkNotNull(criteria);
        BaseOpenStackService.Invocation<CeilometerStatistics[]> invocation = this.get(CeilometerStatistics[].class, this.uri("/meters/%s/statistics", meterName)).param(period > 0, "period", period);
        if (criteria.getLimit() > 0) {
            invocation.param(LIMIT, criteria.getLimit());
        }
        if (!criteria.getCriteriaParams().isEmpty()) {
            for (SampleCriteria.NameOpValue c : criteria.getCriteriaParams()) {
                invocation.param(FIELD, c.getField());
                invocation.param(OPER, c.getOperator().getQueryValue());
                invocation.param(VALUE, c.getValue());
            }
        }
        CeilometerStatistics[] stats = invocation.execute();
        return this.wrapList(stats);
    }

    @Override
    public void putSamples(List<MeterSample> sampleList, String meterName) {
        ListEntity<MeterSample> listEntity = new ListEntity<MeterSample>(sampleList);
        this.post(Void.class, this.uri("/meters/%s", meterName)).entity(listEntity).execute();
    }
}

