/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.trove.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.trove.UserService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.trove.Database;
import org.openstack4j.model.trove.DatabaseUser;
import org.openstack4j.openstack.trove.domain.TroveDatabase;
import org.openstack4j.openstack.trove.domain.TroveDatabaseUser;
import org.openstack4j.openstack.trove.internal.BaseTroveServices;

public class DBUserServiceImpl
extends BaseTroveServices
implements UserService {
    @Override
    public List<? extends DatabaseUser> list(String instanceId) {
        return this.get(TroveDatabaseUser.DatabaseUsers.class, this.uri("/instances/%s/users", instanceId)).execute().getList();
    }

    @Override
    public List<? extends Database> listUserDatabases(String instanceId, String userName) {
        return this.get(TroveDatabase.Databases.class, this.uri("/instances/%s/users/%s/databases", instanceId, userName)).execute().getList();
    }

    @Override
    public ActionResponse create(String instanceId, TroveDatabaseUser.DatabaseUsers databaseUsers) {
        return this.post(ActionResponse.class, this.uri("/instances/%s/users", instanceId)).entity(databaseUsers).execute();
    }

    @Override
    public ActionResponse delete(String instanceId, String userName) {
        Preconditions.checkNotNull(instanceId);
        Preconditions.checkNotNull(userName);
        return this.deleteWithResponse(this.uri("/instances/%s/users/%s", instanceId, userName)).execute();
    }

    @Override
    public ActionResponse grantUserDBAccess(String instanceId, String userName, TroveDatabase.Databases databases) {
        Preconditions.checkNotNull(instanceId);
        Preconditions.checkNotNull(userName);
        Preconditions.checkNotNull(databases);
        return this.put(ActionResponse.class, this.uri("/instances/%s/users/%s/databases", instanceId, userName)).entity(databases).execute();
    }

    @Override
    public ActionResponse revokeUserDBAccess(String instanceId, String userName, String dbName) {
        Preconditions.checkNotNull(instanceId);
        Preconditions.checkNotNull(userName);
        Preconditions.checkNotNull(dbName);
        return this.deleteWithResponse(this.uri("/instances/%s/users/%s/databases/%s", instanceId, userName, dbName)).execute();
    }
}

