/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.util.Collections;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.drools.compiler.compiler.DRLFactory;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.lang.DRLExpressions;
import org.drools.compiler.lang.DRLLexer;
import org.drools.compiler.lang.ParserHelper;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ConstraintConnectiveDescr;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class DrlExprParser {
    private ParserHelper helper = null;
    private final LanguageLevelOption languageLevel;

    public DrlExprParser(LanguageLevelOption languageLevel) {
        this.languageLevel = languageLevel;
    }

    public ConstraintConnectiveDescr parse(String text) {
        ConstraintConnectiveDescr constraint = null;
        try {
            DRLLexer lexer = DRLFactory.getDRLLexer(new ANTLRStringStream(text), this.languageLevel);
            CommonTokenStream input = new CommonTokenStream(lexer);
            RecognizerSharedState state = new RecognizerSharedState();
            this.helper = new ParserHelper(input, state, this.languageLevel);
            DRLExpressions parser = DRLFactory.getDRLExpressions(input, state, this.helper, this.languageLevel);
            parser.setBuildDescr(true);
            parser.setLeftMostExpr(null);
            BaseDescr expr = parser.conditionalOrExpression();
            if (expr != null && !parser.hasErrors()) {
                constraint = ConstraintConnectiveDescr.newAnd();
                constraint.addOrMerge(expr);
            }
        }
        catch (RecognitionException e) {
            this.helper.reportError(e);
        }
        return constraint;
    }

    public String getLeftMostExpr() {
        return this.helper != null ? this.helper.getLeftMostExpr() : null;
    }

    public boolean hasErrors() {
        return this.helper != null && this.helper.hasErrors();
    }

    public List<DroolsParserException> getErrors() {
        return this.helper != null ? this.helper.getErrors() : Collections.EMPTY_LIST;
    }
}

