/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.util.HashSet;
import java.util.Map;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.core.base.ClassTypeResolver;
import org.drools.core.base.TypeResolver;
import org.drools.core.factmodel.traits.TraitRegistry;
import org.drools.core.rule.DialectRuntimeRegistry;
import org.drools.core.rule.ImportDeclaration;
import org.drools.core.rule.Package;
import org.drools.core.rule.Rule;
import org.drools.core.spi.Consequence;
import org.drools.core.util.ClassUtils;
import org.kie.api.io.Resource;

public class PackageRegistry {
    private final Package pkg;
    private String dialect;
    private final DialectRuntimeRegistry dialectRuntimeRegistry;
    private final DialectCompiletimeRegistry dialectCompiletimeRegistry;
    private final TypeResolver typeResolver;

    public PackageRegistry(PackageBuilder packageBuilder, Package pkg) {
        this.pkg = pkg;
        this.dialectCompiletimeRegistry = packageBuilder.getPackageBuilderConfiguration().buildDialectRegistry(packageBuilder, this, pkg);
        this.dialectRuntimeRegistry = pkg.getDialectRuntimeRegistry();
        this.typeResolver = new ClassTypeResolver(new HashSet<String>(this.pkg.getImports().keySet()), packageBuilder.getRootClassLoader(), this.pkg.getName());
        this.typeResolver.addImport(pkg.getName() + ".*");
        pkg.setTypeResolver(this.typeResolver);
    }

    private PackageRegistry(Package pkg, DialectRuntimeRegistry runtimeRegistry, DialectCompiletimeRegistry compiletimeRegistry, TypeResolver typeResolver) {
        this.pkg = pkg;
        this.dialectRuntimeRegistry = runtimeRegistry;
        this.dialectCompiletimeRegistry = compiletimeRegistry;
        this.typeResolver = typeResolver;
    }

    PackageRegistry clonePackage(ClassLoader classLoader) {
        Package clonedPkg = ClassUtils.deepClone(this.pkg, classLoader);
        clonedPkg.setDialectRuntimeRegistry(this.pkg.getDialectRuntimeRegistry());
        for (Rule rule : this.pkg.getRules()) {
            Rule clonedRule = clonedPkg.getRule(rule.getName());
            clonedRule.setConsequence(rule.getConsequence());
            if (!rule.hasNamedConsequences()) continue;
            for (Map.Entry<String, Consequence> namedConsequence : rule.getNamedConsequences().entrySet()) {
                clonedRule.addNamedConsequence(namedConsequence.getKey(), namedConsequence.getValue());
            }
        }
        PackageRegistry clone = new PackageRegistry(clonedPkg, this.dialectRuntimeRegistry, this.dialectCompiletimeRegistry, this.typeResolver);
        clone.setDialect(this.dialect);
        return clone;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public ClassLoader getPackageClassLoader() {
        return this.getPackage().getPackageClassLoader();
    }

    public DialectRuntimeRegistry getDialectRuntimeRegistry() {
        return this.dialectRuntimeRegistry;
    }

    public DialectCompiletimeRegistry getDialectCompiletimeRegistry() {
        return this.dialectCompiletimeRegistry;
    }

    public void addImport(ImportDescr importDescr) {
        this.registerImport(importDescr.getTarget());
        this.dialectCompiletimeRegistry.addImport(importDescr);
    }

    public void registerImport(String importEntry) {
        this.pkg.addImport(new ImportDeclaration(importEntry));
        this.typeResolver.addImport(importEntry);
    }

    public void addStaticImport(ImportDescr importDescr) {
        this.dialectCompiletimeRegistry.addStaticImport(importDescr);
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public void compileAll() {
        this.dialectCompiletimeRegistry.compileAll();
    }

    public boolean removeObjectsGeneratedFromResource(Resource resource) {
        return this.pkg.removeObjectsGeneratedFromResource(resource);
    }

    public TraitRegistry getTraitRegistry() {
        return this.pkg.getTraitRegistry();
    }
}

