/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler.io.memory;

import java.util.Collection;
import org.drools.compiler.compiler.io.File;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.Path;
import org.drools.compiler.compiler.io.Resource;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.compiler.io.memory.MemoryPath;
import org.drools.core.util.StringUtils;

public class MemoryFolder
implements Folder {
    private MemoryFileSystem mfs;
    private String path;
    private MemoryPath mPath;
    private MemoryFolder pFolder;

    public MemoryFolder(MemoryFileSystem mfs, String path) {
        this.mfs = mfs;
        this.path = path;
    }

    @Override
    public String getName() {
        int lastSlash = this.path.lastIndexOf(47);
        if (lastSlash >= 0) {
            return this.path.substring(lastSlash + 1);
        }
        return this.path;
    }

    @Override
    public Path getPath() {
        if (this.mPath == null) {
            this.mPath = new MemoryPath(this.path);
        }
        return this.mPath;
    }

    @Override
    public File getFile(String name) {
        if (!StringUtils.isEmpty(this.path)) {
            return this.mfs.getFile(this.path + "/" + name);
        }
        return this.mfs.getFile(name);
    }

    @Override
    public Folder getFolder(String name) {
        if (!StringUtils.isEmpty(this.path)) {
            return this.mfs.getFolder(this.path + "/" + name);
        }
        return this.mfs.getFolder(name);
    }

    @Override
    public Folder getParent() {
        if (this.pFolder == null) {
            String p = MemoryFolder.trimLeadingAndTrailing(this.path);
            if (p.indexOf(47) == -1) {
                this.pFolder = new MemoryFolder(this.mfs, "");
            } else {
                String[] elements = p.split("/");
                String newPath = "";
                boolean first = true;
                for (int i = 0; i < elements.length - 1; ++i) {
                    if (StringUtils.isEmpty(elements[i])) continue;
                    if (!first) {
                        newPath = newPath + "/";
                    }
                    newPath = newPath + elements[i];
                    first = false;
                }
                this.pFolder = new MemoryFolder(this.mfs, newPath);
            }
        }
        return this.pFolder;
    }

    public static String trimLeadingAndTrailing(String p) {
        while (p.charAt(0) == '/') {
            p = p.substring(1);
        }
        while (p.charAt(p.length() - 1) == '/') {
            p = p.substring(0, p.length() - 1);
        }
        return p;
    }

    @Override
    public Collection<? extends Resource> getMembers() {
        return this.mfs.getMembers(this);
    }

    @Override
    public boolean exists() {
        return this.mfs.existsFolder(this.path);
    }

    @Override
    public boolean create() {
        this.createFolder(this);
        return true;
    }

    private void createFolder(MemoryFolder folder) {
        String p = MemoryFolder.trimLeadingAndTrailing(folder.path);
        this.mfs.createFolder(folder);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryFolder other = (MemoryFolder)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public String toString() {
        return "MemoryFolder [path=" + this.path + "]";
    }
}

