/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import com.google.protobuf.ExtensionRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.drools.compiler.compiler.PackageBuilderConfiguration;
import org.drools.compiler.kie.builder.impl.FileKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieModuleCache;
import org.drools.compiler.kie.builder.impl.KieModuleCacheHelper;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.compiler.kproject.xml.PomModel;
import org.drools.core.builder.conf.impl.DecisionTableConfigurationImpl;
import org.drools.core.builder.conf.impl.ResourceConfigurationImpl;
import org.drools.core.rule.KieModuleMetaInfo;
import org.drools.core.rule.TypeMetaInfo;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.StringUtils;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.ResourceChangeSet;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.io.ResourceTypeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKieModule
implements InternalKieModule {
    private static final Logger log = LoggerFactory.getLogger(AbstractKieModule.class);
    private final Map<String, KnowledgeBuilder> kBuilders = new HashMap<String, KnowledgeBuilder>();
    private final Map<String, Results> resultsCache = new HashMap<String, Results>();
    protected final ReleaseId releaseId;
    private final KieModuleModel kModuleModel;
    private Map<ReleaseId, InternalKieModule> kieDependencies;
    protected Map<String, Map<String, Map<String, byte[]>>> compilationCache = new HashMap<String, Map<String, Map<String, byte[]>>>();
    private Map<String, TypeMetaInfo> typesMetaInfo;
    private Map<String, ResourceConfiguration> resourceConfigurationCache = new HashMap<String, ResourceConfiguration>();
    protected PomModel pomModel;

    public AbstractKieModule(ReleaseId releaseId, KieModuleModel kModuleModel) {
        this.releaseId = releaseId;
        this.kModuleModel = kModuleModel;
    }

    @Override
    public KieModuleModel getKieModuleModel() {
        return this.kModuleModel;
    }

    @Override
    public Map<ReleaseId, InternalKieModule> getKieDependencies() {
        return this.kieDependencies == null ? Collections.emptyMap() : this.kieDependencies;
    }

    @Override
    public void addKieDependency(InternalKieModule dependency) {
        if (this.kieDependencies == null) {
            this.kieDependencies = new HashMap<ReleaseId, InternalKieModule>();
        }
        this.kieDependencies.put(dependency.getReleaseId(), dependency);
    }

    @Override
    public Collection<ReleaseId> getJarDependencies() {
        if (this.pomModel == null) {
            this.getPomModel();
        }
        Collection<ReleaseId> deps = null;
        if (this.pomModel != null) {
            deps = this.pomModel.getDependencies();
        }
        return deps == null ? Collections.emptyList() : deps;
    }

    @Override
    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    @Override
    public KnowledgeBuilder getKnowledgeBuilderForKieBase(String kieBaseName) {
        return this.kBuilders.get(kieBaseName);
    }

    @Override
    public Collection<KnowledgePackage> getKnowledgePackagesForKieBase(String kieBaseName) {
        KnowledgeBuilder kbuilder = this.kBuilders.get(kieBaseName);
        return kbuilder != null ? kbuilder.getKnowledgePackages() : null;
    }

    @Override
    public void cacheKnowledgeBuilderForKieBase(String kieBaseName, KnowledgeBuilder kbuilder) {
        this.kBuilders.put(kieBaseName, kbuilder);
    }

    @Override
    public Map<String, Results> getKnowledgeResultsCache() {
        return this.resultsCache;
    }

    @Override
    public void cacheResultsForKieBase(String kieBaseName, Results results) {
        this.resultsCache.put(kieBaseName, results);
    }

    @Override
    public Map<String, byte[]> getClassesMap(boolean includeTypeDeclarations) {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (String fileName : this.getFileNames()) {
            if (!fileName.endsWith(".class") || !includeTypeDeclarations && this.isTypeDeclaration(fileName)) continue;
            classes.put(fileName, this.getBytes(fileName));
        }
        return classes;
    }

    private boolean isTypeDeclaration(String fileName) {
        Map<String, TypeMetaInfo> info = this.getTypesMetaInfo();
        TypeMetaInfo typeInfo = info == null ? null : info.get(ClassUtils.convertResourceToClassName(fileName));
        return typeInfo != null && typeInfo.isDeclaredType();
    }

    private Map<String, TypeMetaInfo> getTypesMetaInfo() {
        byte[] bytes;
        if (this.typesMetaInfo == null && (bytes = this.getBytes(KieModuleModelImpl.KMODULE_INFO_JAR_PATH)) != null) {
            this.typesMetaInfo = KieModuleMetaInfo.unmarshallMetaInfos(new String(bytes)).getTypeMetaInfos();
        }
        return this.typesMetaInfo;
    }

    static KnowledgeBuilder buildKnowledgePackages(KieBaseModelImpl kBaseModel, KieProject kieProject, ResultsImpl messages) {
        AbstractKieModule kModule = (AbstractKieModule)kieProject.getKieModuleForKBase(kBaseModel.getName());
        PackageBuilderConfiguration pconf = new PackageBuilderConfiguration(kieProject.getClonedClassLoader());
        pconf.setCompilationCache(kModule.getCompilationCache(kBaseModel.getName()));
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder(pconf);
        CompositeKnowledgeBuilder ckbuilder = kbuilder.batch();
        HashMap<String, InternalKieModule> assets = new HashMap<String, InternalKieModule>();
        for (String string : AbstractKieModule.getTransitiveIncludes(kieProject, kBaseModel)) {
            if (StringUtils.isEmpty(string)) continue;
            InternalKieModule includeModule = kieProject.getKieModuleForKBase(string);
            if (includeModule == null) {
                log.error("Unable to build KieBase, could not find include: " + string);
                return null;
            }
            AbstractKieModule.addFiles(assets, kieProject.getKieBaseModel(string), includeModule);
        }
        AbstractKieModule.addFiles(assets, kBaseModel, kModule);
        if (assets.isEmpty()) {
            if (kModule instanceof FileKieModule) {
                log.warn("No files found for KieBase " + kBaseModel.getName() + ", searching folder " + kModule.getFile());
            } else {
                log.warn("No files found for KieBase " + kBaseModel.getName());
            }
        } else {
            for (Map.Entry entry : assets.entrySet()) {
                ((InternalKieModule)entry.getValue()).addResourceToCompiler(ckbuilder, (String)entry.getKey());
            }
        }
        ckbuilder.build();
        if (kbuilder.hasErrors()) {
            for (KnowledgeBuilderError knowledgeBuilderError : kbuilder.getErrors()) {
                messages.addMessage(knowledgeBuilderError);
            }
            log.error("Unable to build KieBaseModel:" + kBaseModel.getName() + "\n" + kbuilder.getErrors().toString());
        }
        kModule.cacheKnowledgeBuilderForKieBase(kBaseModel.getName(), kbuilder);
        kModule.cacheResultsForKieBase(kBaseModel.getName(), messages);
        return kbuilder;
    }

    private static Set<String> getTransitiveIncludes(KieProject kieProject, KieBaseModelImpl kBaseModel) {
        HashSet<String> includes = new HashSet<String>();
        AbstractKieModule.getTransitiveIncludes(kieProject, kBaseModel, includes);
        return includes;
    }

    private static void getTransitiveIncludes(KieProject kieProject, KieBaseModelImpl kBaseModel, Set<String> includes) {
        if (kBaseModel == null) {
            return;
        }
        Set<String> incs = kBaseModel.getIncludes();
        if (incs != null && !incs.isEmpty()) {
            for (String inc : incs) {
                if (includes.contains(inc)) continue;
                includes.add(inc);
                AbstractKieModule.getTransitiveIncludes(kieProject, (KieBaseModelImpl)kieProject.getKieBaseModel(inc), includes);
            }
        }
    }

    private static void addFiles(Map<String, InternalKieModule> assets, KieBaseModel kieBaseModel, InternalKieModule kieModule) {
        for (String fileName : kieModule.getFileNames()) {
            if (fileName.endsWith(".properties") || !KieBuilderImpl.filterFileInKBase(kieModule, kieBaseModel, fileName)) continue;
            assets.put(fileName, kieModule);
        }
    }

    @Override
    public boolean addResourceToCompiler(CompositeKnowledgeBuilder ckbuilder, String fileName) {
        ResourceConfiguration conf = this.getResourceConfiguration(fileName);
        Resource resource = this.getResource(fileName);
        if (resource != null) {
            if (conf == null) {
                ckbuilder.add(resource, ResourceType.determineResourceType(fileName));
            } else {
                ResourceType confType = conf instanceof ResourceConfigurationImpl ? ((ResourceConfigurationImpl)conf).getResourceType() : null;
                ckbuilder.add(resource, confType != null ? confType : ResourceType.determineResourceType(fileName), conf);
            }
            return true;
        }
        return false;
    }

    @Override
    public Resource getResource(String fileName) {
        byte[] bytes = this.getBytes(fileName);
        if (bytes != null && bytes.length > 0) {
            return ResourceFactory.newByteArrayResource(bytes).setSourcePath(fileName);
        }
        return null;
    }

    @Override
    public ResourceConfiguration getResourceConfiguration(String fileName) {
        ResourceConfiguration conf = this.resourceConfigurationCache.get(fileName);
        if (conf != null) {
            return conf;
        }
        if (this.isAvailable(fileName + ".properties")) {
            Properties prop = new Properties();
            try {
                prop.load(new ByteArrayInputStream(this.getBytes(fileName + ".properties")));
            }
            catch (IOException e) {
                log.error("Error loading resource configuration from file: " + fileName + ".properties");
            }
            conf = ResourceTypeImpl.fromProperties(prop);
        } else if (ResourceType.DTABLE.matchesExtension(fileName) && fileName.endsWith(".csv")) {
            Properties prop = new Properties();
            prop.setProperty("kie.resource.conf.class", DecisionTableConfigurationImpl.class.getName());
            prop.setProperty("drools.dt.type", DecisionTableInputType.CSV.toString());
            conf = ResourceTypeImpl.fromProperties(prop);
        }
        this.resourceConfigurationCache.put(fileName, conf);
        return conf;
    }

    protected Map<String, Map<String, byte[]>> getCompilationCache(String kbaseName) {
        byte[] fileContents;
        Map<String, Map<String, byte[]>> cache = this.compilationCache.get(kbaseName);
        if (cache == null && (fileContents = this.getBytes(KieBuilderImpl.getCompilationCachePath(this.releaseId, kbaseName))) != null) {
            ExtensionRegistry registry = KieModuleCacheHelper.buildRegistry();
            try {
                KieModuleCache.Header _header = KieModuleCacheHelper.readFromStreamWithHeaderPreloaded(new ByteArrayInputStream(fileContents), registry);
                KieModuleCache.KModuleCache _cache = KieModuleCache.KModuleCache.parseFrom(_header.getPayload());
                cache = new HashMap<String, Map<String, byte[]>>();
                for (KieModuleCache.CompilationData _data : _cache.getCompilationDataList()) {
                    HashMap<String, byte[]> bytecode = new HashMap<String, byte[]>();
                    cache.put(_data.getDialect(), bytecode);
                    for (KieModuleCache.CompDataEntry _entry : _data.getEntryList()) {
                        bytecode.put(_entry.getId(), _entry.getData().toByteArray());
                    }
                }
                this.compilationCache.put(kbaseName, cache);
            }
            catch (Exception e) {
                log.error("Unable to load compilation cache... ", (Throwable)e);
            }
        }
        return cache;
    }

    public PomModel getPomModel() {
        if (this.pomModel == null) {
            try {
                byte[] pomXml = this.getPomXml();
                if (pomXml != null) {
                    PomModel tempPomModel = PomModel.Parser.parse("pom.xml", new ByteArrayInputStream(pomXml));
                    this.validatePomModel(tempPomModel);
                    this.pomModel = tempPomModel;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.pomModel;
    }

    public void setPomModel(PomModel pomModel) {
        this.pomModel = pomModel;
    }

    private void validatePomModel(PomModel pomModel) {
        ReleaseId pomReleaseId = pomModel.getReleaseId();
        if (StringUtils.isEmpty(pomReleaseId.getGroupId()) || StringUtils.isEmpty(pomReleaseId.getArtifactId()) || StringUtils.isEmpty(pomReleaseId.getVersion())) {
            throw new RuntimeException("Maven pom.properties exists but ReleaseId content is malformed");
        }
    }

    private byte[] getPomXml() {
        return this.getBytes(((ReleaseIdImpl)this.releaseId).getPomXmlPath());
    }

    public static boolean updateResource(CompositeKnowledgeBuilder ckbuilder, InternalKieModule kieModule, String resourceName, ResourceChangeSet changes) {
        ResourceConfiguration conf = kieModule.getResourceConfiguration(resourceName);
        Resource resource = kieModule.getResource(resourceName);
        if (resource != null) {
            if (conf == null) {
                ckbuilder.add(resource, ResourceType.determineResourceType(resourceName), changes);
            } else {
                ckbuilder.add(resource, ResourceType.determineResourceType(resourceName), conf, changes);
            }
            return true;
        }
        return false;
    }
}

