/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.kie.builder.impl.IncrementalResultsImpl;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.core.io.impl.BaseResource;
import org.kie.api.KieServices;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.io.Resource;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.KieBuilderSet;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;

public class KieBuilderSetImpl
implements KieBuilderSet {
    private final KieBuilderImpl kieBuilder;
    private String[] files;
    private List<KnowledgeBuilderError> previousErrors;
    private final Map<String, Set<String>> resourcesWithErrors = new HashMap<String, Set<String>>();

    public KieBuilderSetImpl(KieBuilderImpl kieBuilder) {
        this.kieBuilder = kieBuilder;
        this.registerInitialErrors(kieBuilder);
    }

    private void registerInitialErrors(KieBuilderImpl kieBuilder) {
        this.previousErrors = new ArrayList<KnowledgeBuilderError>();
        InternalKieModule kieModule = (InternalKieModule)kieBuilder.getKieModuleIgnoringErrors();
        for (KieBaseModel kBaseModel : kieModule.getKieModuleModel().getKieBaseModels().values()) {
            KnowledgeBuilder kBuilder = kieModule.getKnowledgeBuilderForKieBase(kBaseModel.getName());
            for (KnowledgeBuilderError error : kBuilder.getErrors()) {
                this.previousErrors.add(error);
            }
            this.resourcesWithErrors.put(kBaseModel.getName(), this.findResourcesWithErrors(kBuilder));
        }
    }

    KieBuilderSetImpl setFiles(String[] files) {
        this.files = files;
        return this;
    }

    @Override
    public IncrementalResults build() {
        Collection<String> srcFiles = this.files != null ? Arrays.asList(this.files) : this.kieBuilder.getModifiedResourcesSinceLastMark();
        ArrayList<String> filesToBuild = new ArrayList<String>();
        if (srcFiles.isEmpty()) {
            return new IncrementalResultsImpl();
        }
        this.kieBuilder.cloneKieModuleForIncrementalCompilation();
        for (String file : srcFiles) {
            String trgFile = this.kieBuilder.copySourceToTarget(file);
            if (trgFile == null) continue;
            filesToBuild.add(trgFile);
        }
        IncrementalResults result = this.buildChanges(filesToBuild);
        this.files = null;
        this.kieBuilder.markSource();
        return result;
    }

    private Set<String> findResourcesWithErrors(KnowledgeBuilder kBuilder) {
        if (kBuilder.hasErrors()) {
            HashSet<String> resourcesWithErrors = new HashSet<String>();
            for (KnowledgeBuilderError error : kBuilder.getErrors()) {
                resourcesWithErrors.add(error.getResource().getSourcePath());
            }
            return resourcesWithErrors;
        }
        return Collections.emptySet();
    }

    private IncrementalResults buildChanges(Collection<String> filesToBuild) {
        ArrayList<KnowledgeBuilderError> currentErrors = new ArrayList<KnowledgeBuilderError>();
        InternalKieModule kieModule = (InternalKieModule)this.kieBuilder.getKieModuleIgnoringErrors();
        for (KieBaseModel kBaseModel : kieModule.getKieModuleModel().getKieBaseModels().values()) {
            KnowledgeBuilder kBuilder = kieModule.getKnowledgeBuilderForKieBase(kBaseModel.getName());
            CompositeKnowledgeBuilder ckbuilder = kBuilder.batch();
            boolean modified = false;
            PackageBuilder pkgBuilder = ((KnowledgeBuilderImpl)kBuilder).getPackageBuilder();
            Set<String> wrongResources = this.resourcesWithErrors.get(kBaseModel.getName());
            for (String resourceName : wrongResources) {
                modified = pkgBuilder.removeObjectsGeneratedFromResource(new DummyResource(resourceName)) || modified;
                modified = this.addResource(ckbuilder, kBaseModel, kieModule, resourceName) || modified;
            }
            for (String file : filesToBuild) {
                if (wrongResources.contains(file)) {
                    modified = true;
                    continue;
                }
                modified = pkgBuilder.removeObjectsGeneratedFromResource(new DummyResource(file)) || modified;
                modified = this.addResource(ckbuilder, kBaseModel, kieModule, file) || modified;
            }
            if (!modified) continue;
            ckbuilder.build();
            this.resourcesWithErrors.put(kBaseModel.getName(), this.findResourcesWithErrors(kBuilder));
            if (kBuilder.hasErrors()) {
                currentErrors.addAll(kBuilder.getErrors());
                kBuilder.undo();
                continue;
            }
            KieServices.Factory.get().getRepository().addKieModule(kieModule);
            this.kieBuilder.updateKieModuleMetaInfo();
        }
        IncrementalResultsImpl results = this.getIncrementalResults(currentErrors);
        this.previousErrors = currentErrors;
        return results;
    }

    private IncrementalResultsImpl getIncrementalResults(List<KnowledgeBuilderError> currentErrors) {
        IncrementalResultsImpl results = new IncrementalResultsImpl();
        for (KnowledgeBuilderError error : currentErrors) {
            if (this.previousErrors.remove(error)) continue;
            results.addMessage(error);
        }
        for (KnowledgeBuilderError error : this.previousErrors) {
            results.removeMessage(error);
        }
        return results;
    }

    private boolean addResource(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, InternalKieModule kieModule, String resourceName) {
        if (!resourceName.endsWith(".properties") && KieBuilderImpl.filterFileInKBase(kieModule, kieBaseModel, resourceName)) {
            return kieModule.addResourceToCompiler(ckbuilder, resourceName);
        }
        return false;
    }

    public static class DummyResource
    extends BaseResource {
        public DummyResource(String resourceName) {
            this.setSourcePath(resourceName);
        }

        @Override
        public URL getURL() throws IOException {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.getURL -> TODO");
        }

        @Override
        public boolean hasURL() {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.hasURL -> TODO");
        }

        @Override
        public boolean isDirectory() {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.isDirectory -> TODO");
        }

        @Override
        public Collection<Resource> listResources() {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.listResources -> TODO");
        }

        @Override
        public long getLastModified() {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.getLastModified -> TODO");
        }

        @Override
        public long getLastRead() {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.getLastRead -> TODO");
        }

        @Override
        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.getInputStream -> TODO");
        }

        @Override
        public Reader getReader() throws IOException {
            throw new UnsupportedOperationException("KieBuilderSetImpl.DummyResource.getReader -> TODO");
        }
    }
}

