/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kproject.models;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.drools.core.util.AbstractXStreamConverter;
import org.drools.core.util.IoUtils;
import org.drools.core.util.Predicate;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.io.ResourceType;

public class KieBaseModelImpl
implements KieBaseModel {
    private String name;
    private Set<String> includes = new HashSet<String>();
    private List<String> packages;
    private EqualityBehaviorOption equalsBehavior = EqualityBehaviorOption.IDENTITY;
    private EventProcessingOption eventProcessingMode = EventProcessingOption.CLOUD;
    private DeclarativeAgendaOption declarativeAgenda = DeclarativeAgendaOption.DISABLED;
    private Map<String, KieSessionModel> kSessions = new HashMap<String, KieSessionModel>();
    private KieModuleModel kModule;
    private String scope = "javax.enterprise.context.ApplicationScoped";
    private boolean isDefault = false;

    public KieBaseModelImpl() {
    }

    public KieBaseModelImpl(KieModuleModel kModule, String name) {
        this.kModule = kModule;
        this.includes = new HashSet<String>();
        this.name = name;
        this.kSessions = Collections.emptyMap();
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public KieBaseModel setDefault(boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @Override
    public List<String> getPackages() {
        return this.packages != null ? this.packages : Collections.emptyList();
    }

    @Override
    public KieBaseModel addPackage(String pkg) {
        if (this.packages == null) {
            this.packages = new ArrayList<String>();
        }
        this.packages.add(pkg);
        return this;
    }

    @Override
    public KieBaseModel removePackage(String pkg) {
        if (this.packages != null) {
            this.packages.remove(pkg);
        }
        return this;
    }

    public KieModuleModel getKModule() {
        return this.kModule;
    }

    public void setKModule(KieModuleModel kieProject) {
        this.kModule = kieProject;
    }

    @Override
    public Map<String, KieSessionModel> getKieSessionModels() {
        return Collections.unmodifiableMap(this.kSessions);
    }

    public Map<String, KieSessionModel> getRawKieSessionModels() {
        return this.kSessions;
    }

    private void setKSessions(Map<String, KieSessionModel> kSessions) {
        this.kSessions = kSessions;
    }

    @Override
    public KieSessionModel newKieSessionModel(String name) {
        KieSessionModelImpl kieSessionModel = new KieSessionModelImpl(this, name);
        HashMap<String, KieSessionModel> newMap = new HashMap<String, KieSessionModel>();
        newMap.putAll(this.kSessions);
        newMap.put(kieSessionModel.getName(), kieSessionModel);
        this.setKSessions(newMap);
        return kieSessionModel;
    }

    @Override
    public KieBaseModel removeKieSessionModel(String qName) {
        HashMap<String, KieSessionModel> newMap = new HashMap<String, KieSessionModel>();
        newMap.putAll(this.kSessions);
        newMap.remove(qName);
        this.setKSessions(newMap);
        return this;
    }

    public void moveKSession(String oldQName, String newQName) {
        HashMap<String, KieSessionModel> newMap = new HashMap<String, KieSessionModel>();
        newMap.putAll(this.kSessions);
        KieSessionModel kieSessionModel = (KieSessionModel)newMap.remove(oldQName);
        newMap.put(newQName, kieSessionModel);
        this.setKSessions(newMap);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public KieBaseModel setName(String name) {
        ((KieModuleModelImpl)this.kModule).changeKBaseName(this, this.name, name);
        this.name = name;
        return this;
    }

    void changeKSessionName(KieSessionModel kieSession, String oldName, String newName) {
        this.kSessions.remove(oldName);
        this.kSessions.put(newName, kieSession);
    }

    public Set<String> getIncludes() {
        return Collections.unmodifiableSet(this.includes);
    }

    @Override
    public KieBaseModel addInclude(String kBaseQName) {
        this.includes.add(kBaseQName);
        return this;
    }

    @Override
    public KieBaseModel removeInclude(String kBaseQName) {
        this.includes.remove(kBaseQName);
        return this;
    }

    @Override
    public EqualityBehaviorOption getEqualsBehavior() {
        return this.equalsBehavior;
    }

    @Override
    public KieBaseModel setEqualsBehavior(EqualityBehaviorOption equalsBehaviour) {
        this.equalsBehavior = equalsBehaviour;
        return this;
    }

    @Override
    public EventProcessingOption getEventProcessingMode() {
        return this.eventProcessingMode;
    }

    @Override
    public KieBaseModel setEventProcessingMode(EventProcessingOption eventProcessingMode) {
        this.eventProcessingMode = eventProcessingMode;
        return this;
    }

    @Override
    public DeclarativeAgendaOption getDeclarativeAgenda() {
        return this.declarativeAgenda;
    }

    @Override
    public KieBaseModel setDeclarativeAgenda(DeclarativeAgendaOption declarativeAgenda) {
        this.declarativeAgenda = declarativeAgenda;
        return this;
    }

    @Override
    public KieBaseModel setScope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    public static List<String> getFiles(String kBaseName, ZipFile zipFile) {
        ArrayList<String> files = new ArrayList<String>();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String fileName = zipEntry.getName();
            if (!KieBaseModelImpl.filterFileInKBase(kBaseName.replace('.', '/'), fileName)) continue;
            files.add(fileName);
        }
        return files;
    }

    public static List<String> getFiles(File rootFolder) {
        return IoUtils.recursiveListFile(rootFolder, "", (Predicate<? super File>)new Predicate<File>(){

            @Override
            public boolean apply(File file) {
                String fileName = file.getName();
                return fileName.endsWith(ResourceType.DRL.getDefaultExtension()) || fileName.endsWith(ResourceType.GDRL.getDefaultExtension()) || fileName.endsWith(ResourceType.RDRL.getDefaultExtension()) || fileName.endsWith(ResourceType.BPMN2.getDefaultExtension());
            }
        });
    }

    private static boolean filterFileInKBase(String rootPath, String fileName) {
        return fileName.startsWith(rootPath) && (fileName.endsWith(ResourceType.DRL.getDefaultExtension()) || fileName.endsWith(ResourceType.GDRL.getDefaultExtension()) || fileName.endsWith(ResourceType.RDRL.getDefaultExtension()) || fileName.endsWith(ResourceType.BPMN2.getDefaultExtension()));
    }

    public String toString() {
        return "KieBaseModelImpl [name=" + this.name + ", includes=" + this.includes + ", packages=" + this.getPackages() + ", equalsBehavior=" + this.equalsBehavior + ", eventProcessingMode=" + this.eventProcessingMode + ", kSessions=" + this.kSessions + "]";
    }

    public static class KBaseConverter
    extends AbstractXStreamConverter {
        public KBaseConverter() {
            super(KieBaseModelImpl.class);
        }

        @Override
        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            KieBaseModelImpl kBase = (KieBaseModelImpl)value;
            writer.addAttribute("name", kBase.getName());
            writer.addAttribute("default", Boolean.toString(kBase.isDefault()));
            if (kBase.getEventProcessingMode() != null) {
                writer.addAttribute("eventProcessingMode", kBase.getEventProcessingMode().getMode());
            }
            if (kBase.getEqualsBehavior() != null) {
                writer.addAttribute("equalsBehavior", kBase.getEqualsBehavior().toString().toLowerCase());
            }
            if (kBase.getDeclarativeAgenda() != null) {
                writer.addAttribute("declarativeAgenda", kBase.getDeclarativeAgenda().toString().toLowerCase());
            }
            if (kBase.getScope() != null) {
                writer.addAttribute("scope", kBase.getScope());
            }
            if (!kBase.getPackages().isEmpty()) {
                StringBuilder buf = new StringBuilder();
                boolean first = true;
                for (String pkg : kBase.getPackages()) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(pkg);
                }
                writer.addAttribute("packages", buf.toString());
            }
            if (!kBase.getIncludes().isEmpty()) {
                StringBuilder sb = new StringBuilder();
                boolean insertComma = false;
                for (String include : kBase.getIncludes()) {
                    if (insertComma) {
                        sb.append(", ");
                    }
                    sb.append(include);
                    if (insertComma) continue;
                    insertComma = true;
                }
                writer.addAttribute("includes", sb.toString());
            }
            for (KieSessionModel kSessionModel : kBase.getKieSessionModels().values()) {
                this.writeObject(writer, context, "ksession", kSessionModel);
            }
        }

        @Override
        public Object unmarshal(HierarchicalStreamReader reader, final UnmarshallingContext context) {
            String includes;
            String pkgs;
            String scope;
            String declarativeAgenda;
            String equalsBehavior;
            final KieBaseModelImpl kBase = new KieBaseModelImpl();
            kBase.name = reader.getAttribute("name");
            kBase.setDefault("true".equals(reader.getAttribute("default")));
            String eventMode = reader.getAttribute("eventProcessingMode");
            if (eventMode != null) {
                kBase.setEventProcessingMode(EventProcessingOption.determineEventProcessingMode(eventMode));
            }
            if ((equalsBehavior = reader.getAttribute("equalsBehavior")) != null) {
                kBase.setEqualsBehavior(EqualityBehaviorOption.determineEqualityBehavior(equalsBehavior));
            }
            if ((declarativeAgenda = reader.getAttribute("declarativeAgenda")) != null) {
                kBase.setDeclarativeAgenda(DeclarativeAgendaOption.determineDeclarativeAgenda(declarativeAgenda));
            }
            if ((scope = reader.getAttribute("scope")) != null) {
                kBase.setScope(scope.trim());
            }
            if ((pkgs = reader.getAttribute("packages")) != null) {
                for (String pkg : pkgs.split(",")) {
                    kBase.addPackage(pkg.trim());
                }
            }
            if ((includes = reader.getAttribute("includes")) != null) {
                for (String include : includes.split(",")) {
                    kBase.addInclude(include.trim());
                }
            }
            this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

                @Override
                public void onNode(HierarchicalStreamReader reader, String name, String value) {
                    if ("ksession".equals(name)) {
                        KieSessionModelImpl kSession = (KieSessionModelImpl)KBaseConverter.this.readObject(reader, context, KieSessionModelImpl.class);
                        kBase.getRawKieSessionModels().put(kSession.getName(), kSession);
                        kSession.setKBase(kBase);
                    }
                }
            });
            return kBase;
        }
    }
}

