/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.rule.builder.EngineElementBuilder;
import org.drools.compiler.rule.builder.PatternBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.Query;
import org.drools.core.rule.constraint.QueryNameConstraint;
import org.drools.core.spi.InternalReadAccessor;

public class QueryBuilder
implements EngineElementBuilder {
    public Pattern build(RuleBuildContext context, QueryDescr queryDescr) {
        ClassObjectType queryObjectType = ClassObjectType.DroolsQuery_ObjectType;
        Pattern pattern = new Pattern(context.getNextPatternId(), 0, queryObjectType, null);
        InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, queryDescr, queryObjectType, "name", null, true);
        QueryNameConstraint constraint = new QueryNameConstraint(extractor, queryDescr.getName());
        PatternBuilder.registerReadAccessor(context, queryObjectType, "name", constraint);
        pattern.addConstraint(constraint);
        ClassObjectType argsObjectType = ClassObjectType.DroolsQuery_ObjectType;
        InternalReadAccessor arrayExtractor = PatternBuilder.getFieldReadAccessor(context, queryDescr, argsObjectType, "elements", null, true);
        String[] params = queryDescr.getParameters();
        String[] types = queryDescr.getParameterTypes();
        int i = 0;
        Declaration[] declarations = new Declaration[params.length];
        try {
            for (i = 0; i < params.length; ++i) {
                Declaration declr = pattern.addDeclaration(params[i]);
                ArrayElementReader reader = new ArrayElementReader(arrayExtractor, i, context.getDialect().getTypeResolver().resolveType(types[i]));
                PatternBuilder.registerReadAccessor(context, argsObjectType, "elements", reader);
                declr.setReadAccessor(reader);
                declarations[i] = declr;
            }
            ((Query)context.getRule()).setParameters(declarations);
        }
        catch (ClassNotFoundException e) {
            context.addError(new DescrBuildError(context.getParentDescr(), queryDescr, e, "Unable to resolve type '" + types[i] + " for parameter" + params[i]));
        }
        context.setPrefixPattern(pattern);
        return pattern;
    }
}

