/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.asm;

import java.util.Map;
import org.drools.compiler.rule.builder.ConsequenceBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.compiler.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.compiler.rule.builder.dialect.java.JavaRuleBuilderHelper;
import org.drools.compiler.rule.builder.dialect.java.KnowledgeHelperFixer;
import org.drools.core.rule.Declaration;

public abstract class AbstractASMConsequenceBuilder
implements ConsequenceBuilder {
    @Override
    public void build(RuleBuildContext context, String consequenceName) {
        context.getBuildStack().push(context.getRule().getLhs());
        Map<String, Object> vars = this.consequenceContext(context, consequenceName);
        if (vars == null) {
            return;
        }
        JavaRuleBuilderHelper.generateMethodTemplate("consequenceMethod", context, vars);
        byte[] bytecode = this.createConsequenceBytecode(context, vars);
        JavaRuleBuilderHelper.registerInvokerBytecode(context, vars, bytecode, context.getRule());
        context.getBuildStack().pop();
    }

    private Map<String, Object> consequenceContext(RuleBuildContext context, String consequenceName) {
        String className = consequenceName + "Consequence";
        Map<String, Declaration> decls = context.getDeclarationResolver().getDeclarations(context.getRule(), consequenceName);
        JavaAnalysisResult analysis = JavaRuleBuilderHelper.createJavaAnalysisResult(context, consequenceName, decls);
        if (analysis == null) {
            return null;
        }
        String fixedConsequence = DialectUtil.fixBlockDescr(context, analysis, decls);
        if (fixedConsequence == null) {
            return null;
        }
        fixedConsequence = KnowledgeHelperFixer.fix(fixedConsequence);
        return JavaRuleBuilderHelper.createConsequenceContext(context, consequenceName, className, fixedConsequence, decls, analysis.getBoundIdentifiers());
    }

    protected abstract byte[] createConsequenceBytecode(RuleBuildContext var1, Map<String, Object> var2);
}

