/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.kie.api.runtime.rule.AccumulateFunction;

public class CountAccumulateFunction
implements AccumulateFunction {
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public Serializable createContext() {
        return new CountData();
    }

    @Override
    public void init(Serializable context) throws Exception {
        CountData data = (CountData)context;
        data.count = 0L;
    }

    @Override
    public void accumulate(Serializable context, Object value) {
        CountData data = (CountData)context;
        ++data.count;
    }

    @Override
    public void reverse(Serializable context, Object value) throws Exception {
        CountData data = (CountData)context;
        --data.count;
    }

    @Override
    public Object getResult(Serializable context) throws Exception {
        CountData data = (CountData)context;
        return new Long(data.count);
    }

    @Override
    public boolean supportsReverse() {
        return true;
    }

    @Override
    public Class<?> getResultType() {
        return Number.class;
    }

    protected static class CountData
    implements Externalizable {
        public long count = 0L;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.count = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.count);
        }
    }
}

