/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.kie.api.runtime.rule.AccumulateFunction;

public class SumAccumulateFunction
implements AccumulateFunction {
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public Serializable createContext() {
        return new SumData();
    }

    @Override
    public void init(Serializable context) throws Exception {
        SumData data = (SumData)context;
        data.total = 0.0;
    }

    @Override
    public void accumulate(Serializable context, Object value) {
        SumData data = (SumData)context;
        data.total += ((Number)value).doubleValue();
    }

    @Override
    public void reverse(Serializable context, Object value) throws Exception {
        SumData data = (SumData)context;
        data.total -= ((Number)value).doubleValue();
    }

    @Override
    public Object getResult(Serializable context) throws Exception {
        SumData data = (SumData)context;
        return new Double(data.total);
    }

    @Override
    public boolean supportsReverse() {
        return true;
    }

    @Override
    public Class<?> getResultType() {
        return Number.class;
    }

    protected static class SumData
    implements Externalizable {
        public double total = 0.0;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.total = in.readDouble();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeDouble(this.total);
        }
    }
}

