/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.process;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.command.IdentifiableResult;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.command.runtime.process.CorrelationKeyXmlAdapter;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.xml.jaxb.util.JaxbMapAdapter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.Context;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;

@XmlAccessorType(value=XmlAccessType.NONE)
public class StartCorrelatedProcessCommand
implements GenericCommand<ProcessInstance>,
IdentifiableResult {
    @XmlAttribute(required=true)
    private String processId;
    @XmlElement(name="correlation-key")
    @XmlJavaTypeAdapter(value=CorrelationKeyXmlAdapter.class)
    private CorrelationKey correlationKey;
    @XmlJavaTypeAdapter(value=JaxbMapAdapter.class)
    @XmlElement(name="parameter")
    private Map<String, Object> parameters = new HashMap<String, Object>();
    @XmlElementWrapper(name="data")
    private List<Object> data = null;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;

    public StartCorrelatedProcessCommand() {
    }

    public StartCorrelatedProcessCommand(String processId, CorrelationKey correlationKey) {
        this.processId = processId;
        this.correlationKey = correlationKey;
    }

    public StartCorrelatedProcessCommand(String processId, CorrelationKey correlationKey, String outIdentifier) {
        this(processId, correlationKey);
        this.outIdentifier = outIdentifier;
    }

    public StartCorrelatedProcessCommand(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        this(processId, correlationKey);
        this.parameters = parameters;
    }

    public StartCorrelatedProcessCommand(String processId, CorrelationKey correlationKey, Map<String, Object> parameters, String outIdentifier) {
        this(processId, correlationKey, outIdentifier);
        this.parameters = parameters;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void putParameter(String key, Object value) {
        this.getParameters().put(key, value);
    }

    public List<Object> getData() {
        return this.data;
    }

    public void setData(List<Object> data) {
        this.data = data;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    public CorrelationKey getCorrelationKey() {
        return this.correlationKey;
    }

    public void setCorrelationKey(CorrelationKey correlationKey) {
        this.correlationKey = correlationKey;
    }

    @Override
    public ProcessInstance execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        if (this.data != null) {
            for (Object o : this.data) {
                ksession.insert(o);
            }
        }
        ProcessInstance processInstance = ((CorrelationAwareProcessRuntime)((Object)ksession)).startProcess(this.processId, this.correlationKey, this.parameters);
        if (this.outIdentifier != null) {
            ((ExecutionResultImpl)((KnowledgeCommandContext)context).getExecutionResults()).getResults().put(this.outIdentifier, processInstance.getId());
        }
        return processInstance;
    }

    public String toString() {
        String result = "session.startProcess(" + this.processId + ", " + this.correlationKey + ", [";
        if (this.parameters != null) {
            int i = 0;
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                if (i++ > 0) {
                    result = result + ", ";
                }
                result = result + entry.getKey() + "=" + entry.getValue();
            }
        }
        result = result + "]);";
        return result;
    }
}

