/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.conflict.PhreakConflictResolver;
import org.drools.core.conflict.SequentialConflictResolver;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.BinaryHeapQueue;

public class AgendaGroupQueueImpl
implements InternalAgendaGroup,
InternalRuleFlowGroup {
    private static final long serialVersionUID = 510L;
    private String name;
    private BinaryHeapQueue priorityQueue;
    private volatile boolean active;
    private PropagationContext autoFocusActivator;
    private long activatedForRecency;
    private long clearedForRecency;
    private InternalWorkingMemory workingMemory;
    private boolean autoDeactivate = true;
    private Map<Long, String> nodeInstances = new ConcurrentHashMap<Long, String>();
    private volatile boolean hasRuleFlowLister;

    public AgendaGroupQueueImpl() {
    }

    public AgendaGroupQueueImpl(String name, InternalRuleBase ruleBase) {
        this.name = name;
        this.priorityQueue = ruleBase.getConfiguration().isPhreakEnabled() ? new BinaryHeapQueue(new PhreakConflictResolver()) : (ruleBase.getConfiguration().isSequential() ? new BinaryHeapQueue(new SequentialConflictResolver()) : new BinaryHeapQueue(ruleBase.getConfiguration().getConflictResolver()));
        this.clearedForRecency = -1L;
    }

    public BinaryHeapQueue getBinaryHeapQueue() {
        return this.priorityQueue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    @Override
    public InternalWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public void hasRuleFlowListener(boolean hasRuleFlowLister) {
        this.hasRuleFlowLister = hasRuleFlowLister;
    }

    @Override
    public boolean isRuleFlowListener() {
        return this.hasRuleFlowLister;
    }

    @Override
    public void clear() {
        this.priorityQueue.clear();
    }

    @Override
    public Activation[] getAndClear() {
        return this.priorityQueue.getAndClear();
    }

    @Override
    public int size() {
        return this.priorityQueue.size();
    }

    @Override
    public void add(Activation activation) {
        this.priorityQueue.enqueue(activation);
    }

    @Override
    public Activation remove() {
        return this.priorityQueue.dequeue();
    }

    @Override
    public Activation peek() {
        return this.priorityQueue.peek();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void deactivateIfEmpty() {
    }

    @Override
    public boolean isAutoDeactivate() {
        return this.autoDeactivate;
    }

    @Override
    public void setAutoDeactivate(boolean autoDeactivate) {
        this.autoDeactivate = autoDeactivate;
    }

    @Override
    public void addNodeInstance(Long processInstanceId, String nodeInstanceId) {
        this.nodeInstances.put(processInstanceId, nodeInstanceId);
    }

    @Override
    public void removeNodeInstance(Long processInstanceId, String nodeInstanceId) {
        this.nodeInstances.put(processInstanceId, nodeInstanceId);
    }

    @Override
    public void setActive(boolean activate) {
        this.active = activate;
    }

    @Override
    public PropagationContext getAutoFocusActivator() {
        return this.autoFocusActivator;
    }

    @Override
    public void setAutoFocusActivator(PropagationContext autoFocusActivator) {
        this.autoFocusActivator = autoFocusActivator;
    }

    @Override
    public boolean isEmpty() {
        return this.priorityQueue.isEmpty();
    }

    @Override
    public Activation[] getActivations() {
        return (Activation[])this.priorityQueue.toArray(new AgendaItem[this.priorityQueue.size()]);
    }

    @Override
    public Map<Long, String> getNodeInstances() {
        return this.nodeInstances;
    }

    public String toString() {
        return "AgendaGroup '" + this.name + "'";
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AgendaGroupQueueImpl)) {
            return false;
        }
        return ((AgendaGroupQueueImpl)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void setFocus() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Activation activation) {
        this.priorityQueue.dequeue(activation.getQueueIndex());
    }

    @Override
    public long getActivatedForRecency() {
        return this.activatedForRecency;
    }

    @Override
    public void setActivatedForRecency(long recency) {
        this.activatedForRecency = recency;
    }

    @Override
    public long getClearedForRecency() {
        return this.clearedForRecency;
    }

    @Override
    public void setClearedForRecency(long recency) {
        this.clearedForRecency = recency;
    }

    public static class DeactivateCallback
    implements WorkingMemoryAction {
        private static final long serialVersionUID = 510L;
        private InternalRuleFlowGroup ruleFlowGroup;

        public DeactivateCallback(InternalRuleFlowGroup ruleFlowGroup) {
            this.ruleFlowGroup = ruleFlowGroup;
        }

        public DeactivateCallback(MarshallerReaderContext context) throws IOException {
            this.ruleFlowGroup = (InternalRuleFlowGroup)context.wm.getAgenda().getRuleFlowGroup(context.readUTF());
        }

        public DeactivateCallback(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            this.ruleFlowGroup = (InternalRuleFlowGroup)context.wm.getAgenda().getRuleFlowGroup(_action.getDeactivateCallback().getRuleflowGroup());
        }

        @Override
        public void write(MarshallerWriteContext context) throws IOException {
            context.writeShort(2);
            context.writeUTF(this.ruleFlowGroup.getName());
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.DEACTIVATE_CALLBACK).setDeactivateCallback(ProtobufMessages.ActionQueue.DeactivateCallback.newBuilder().setRuleflowGroup(this.ruleFlowGroup.getName()).build()).build();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.ruleFlowGroup = (InternalRuleFlowGroup)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.ruleFlowGroup);
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            if (this.ruleFlowGroup.isEmpty()) {
                this.ruleFlowGroup.setActive(false);
            }
        }

        @Override
        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }
    }
}

