/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.FactException;
import org.drools.core.FactHandle;
import org.drools.core.RuleBase;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.RuntimeDroolsException;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.AbstractWorkingMemory;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.SingleThreadedObjectStore;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.TruthMaintenanceSystemHelper;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.Rule;
import org.drools.core.spi.Activation;
import org.drools.core.spi.FactHandleFactory;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashSet;
import org.kie.api.runtime.ObjectFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedEntryPoint
implements InternalWorkingMemoryEntryPoint,
WorkingMemoryEntryPoint,
PropertyChangeListener {
    protected static transient Logger log = LoggerFactory.getLogger(NamedEntryPoint.class);
    protected static final Class<?>[] ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES = new Class[]{PropertyChangeListener.class};
    protected final Object[] addRemovePropertyChangeListenerArgs = new Object[]{this};
    private TruthMaintenanceSystem tms;
    protected ObjectStore objectStore;
    protected transient InternalRuleBase ruleBase;
    protected EntryPointId entryPoint;
    protected EntryPointNode entryPointNode;
    private ObjectTypeConfigurationRegistry typeConfReg;
    private final AbstractWorkingMemory wm;
    private FactHandleFactory handleFactory;
    private PropagationContextFactory pctxFactory;
    protected final ReentrantLock lock;
    protected Set<InternalFactHandle> dynamicFacts = null;

    public NamedEntryPoint(EntryPointId entryPoint, EntryPointNode entryPointNode, AbstractWorkingMemory wm) {
        this(entryPoint, entryPointNode, wm, new ReentrantLock());
    }

    public NamedEntryPoint(EntryPointId entryPoint, EntryPointNode entryPointNode, AbstractWorkingMemory wm, ReentrantLock lock) {
        this.entryPoint = entryPoint;
        this.entryPointNode = entryPointNode;
        this.wm = wm;
        this.ruleBase = (InternalRuleBase)this.wm.getRuleBase();
        this.lock = lock;
        this.typeConfReg = new ObjectTypeConfigurationRegistry(this.ruleBase);
        this.handleFactory = this.wm.getFactHandleFactory();
        this.pctxFactory = this.ruleBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        this.objectStore = new SingleThreadedObjectStore(this.ruleBase.getConfiguration(), this.lock);
    }

    @Override
    public void reset() {
        this.objectStore.clear();
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    @Override
    public EntryPointNode getEntryPointNode() {
        return this.entryPointNode;
    }

    @Override
    public FactHandle insert(Object object) throws FactException {
        return this.insert(object, null, false, false, null, null);
    }

    @Override
    public FactHandle insert(Object object, boolean dynamic) throws FactException {
        return this.insert(object, null, dynamic, false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FactHandle insert(Object object, Object tmsValue, boolean dynamic, boolean logical, Rule rule, Activation activation) throws FactException {
        if (object == null) {
            return null;
        }
        try {
            this.wm.startOperation();
            ObjectTypeConf typeConf = this.typeConfReg.getObjectTypeConf(this.entryPoint, object);
            if (logical && !typeConf.isTMSEnabled()) {
                this.enableTMS(object, typeConf);
            }
            InternalFactHandle handle = null;
            PropagationContext propagationContext = this.pctxFactory.createPropagationContext(this.wm.getNextPropagationIdCounter(), 0, rule, activation == null ? null : activation.getTuple(), handle, this.entryPoint);
            if (this.wm.isSequential()) {
                handle = this.createHandle(object, typeConf);
                propagationContext.setFactHandle(handle);
                this.insert(handle, object, rule, activation, typeConf, propagationContext);
                InternalFactHandle internalFactHandle = handle;
                return internalFactHandle;
            }
            try {
                this.lock.lock();
                this.ruleBase.readLock();
                handle = this.objectStore.getHandleForObject(object);
                if (typeConf.isTMSEnabled()) {
                    TruthMaintenanceSystem tms = this.getTruthMaintenanceSystem();
                    if (handle != null) {
                        propagationContext.setFactHandle(handle);
                        this.insertWhenHandleExists(object, tmsValue, logical, rule, activation, typeConf, handle, tms, propagationContext);
                        InternalFactHandle internalFactHandle = handle;
                        return internalFactHandle;
                    }
                    EqualityKey key = tms.get(object);
                    if (logical) {
                        if (key != null && key.getStatus() == 1) {
                            FactHandle factHandle = null;
                            return factHandle;
                        }
                        if (key == null) {
                            handle = this.createHandle(object, typeConf);
                            key = new EqualityKey(handle);
                            handle.setEqualityKey(key);
                            tms.put(key);
                            key.setStatus(2);
                        } else {
                            handle = key.getFactHandle();
                        }
                        tms.addLogicalDependency(handle, object, tmsValue, activation, activation.getPropagationContext(), rule, typeConf);
                        InternalFactHandle internalFactHandle = key.getFactHandle();
                        return internalFactHandle;
                    }
                    if (key == null) {
                        handle = this.createHandle(object, typeConf);
                        key = new EqualityKey(handle);
                        handle.setEqualityKey(key);
                        tms.put(key);
                    } else {
                        if (key.getStatus() == 2) {
                            key.setStatus(1);
                            InternalFactHandle justifiedHandle = key.getFactHandle();
                            propagationContext.setFactHandle(justifiedHandle);
                            TruthMaintenanceSystemHelper.clearLogicalDependencies(justifiedHandle, propagationContext);
                            InternalFactHandle internalFactHandle = this.update(justifiedHandle, true, object, Long.MAX_VALUE, Object.class, activation);
                            return internalFactHandle;
                        }
                        handle = this.createHandle(object, typeConf);
                        handle.setEqualityKey(key);
                        key.addFactHandle(handle);
                    }
                    key.setStatus(1);
                } else {
                    if (handle != null) {
                        InternalFactHandle internalFactHandle = handle;
                        return internalFactHandle;
                    }
                    handle = this.createHandle(object, typeConf);
                }
                propagationContext.setFactHandle(handle);
                if (dynamic || typeConf.isDynamic()) {
                    this.addPropertyChangeListener(handle, dynamic);
                }
                this.insert(handle, object, rule, activation, typeConf, propagationContext);
            }
            finally {
                this.ruleBase.readUnlock();
                this.lock.unlock();
            }
            InternalFactHandle internalFactHandle = handle;
            return internalFactHandle;
        }
        finally {
            this.wm.endOperation();
        }
    }

    private void insertWhenHandleExists(Object object, Object tmsValue, boolean logical, Rule rule, Activation activation, ObjectTypeConf typeConf, InternalFactHandle handle, TruthMaintenanceSystem tms, PropagationContext propagationContext) {
        EqualityKey key = handle.getEqualityKey();
        if (key == null) {
            ObjectTypeConf typeC = this.typeConfReg.getObjectTypeConf(this.entryPoint, handle.getObject());
            this.enableTMS(handle.getObject(), typeC);
            key = handle.getEqualityKey();
        }
        if (key.getStatus() == 1) {
            return;
        }
        if (!logical) {
            key.setStatus(1);
            TruthMaintenanceSystemHelper.removeLogicalDependencies(handle, propagationContext);
        } else {
            tms.addLogicalDependency(handle, object, tmsValue, activation, activation.getPropagationContext(), rule, typeConf);
        }
    }

    public void insert(InternalFactHandle handle, Object object, Rule rule, Activation activation, ObjectTypeConf typeConf, PropagationContext pctx) {
        this.ruleBase.executeQueuedActions();
        this.wm.executeQueuedActions();
        if (activation != null) {
            activation.getPropagationContext().releaseResources();
        }
        PropagationContext propagationContext = pctx;
        if (pctx == null) {
            propagationContext = this.pctxFactory.createPropagationContext(this.wm.getNextPropagationIdCounter(), 0, rule, activation == null ? null : activation.getTuple(), handle, this.entryPoint);
        }
        this.entryPointNode.assertObject(handle, propagationContext, typeConf, this.wm);
        propagationContext.evaluateActionQueue(this.wm);
        this.wm.workingMemoryEventSupport.fireObjectInserted(propagationContext, handle, object, this.wm);
        this.wm.executeQueuedActions();
        if (rule == null) {
            this.wm.getAgenda().unstageActivations();
        }
    }

    @Override
    public void update(org.kie.api.runtime.rule.FactHandle factHandle, Object object) throws FactException {
        InternalFactHandle handle = (InternalFactHandle)factHandle;
        this.update(handle, false, object, Long.MAX_VALUE, Object.class, null);
    }

    @Override
    public void update(org.kie.api.runtime.rule.FactHandle factHandle, Object object, long mask, Class<?> modifiedClass, Activation activation) throws FactException {
        InternalFactHandle handle = (InternalFactHandle)factHandle;
        this.update(handle, false, object, mask, modifiedClass, activation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalFactHandle update(InternalFactHandle handle, boolean updateLogical, Object object, long mask, Class<?> modifiedClass, Activation activation) throws FactException {
        try {
            this.lock.lock();
            this.ruleBase.readLock();
            this.wm.startOperation();
            this.ruleBase.executeQueuedActions();
            if (handle.isDisconnected()) {
                handle = this.objectStore.reconnect(handle);
            }
            Object originalObject = handle.getObject();
            if (handle.getEntryPoint() != this) {
                throw new IllegalArgumentException("Invalid Entry Point. You updated the FactHandle on entry point '" + handle.getEntryPoint().getEntryPointId() + "' instead of '" + this.getEntryPointId() + "'");
            }
            ObjectTypeConf typeConf = this.typeConfReg.getObjectTypeConf(this.entryPoint, object);
            int status = -1;
            if (typeConf.isTMSEnabled()) {
                status = handle.getEqualityKey().getStatus();
            }
            if (handle.getId() == -1 || object == null || handle.isEvent() && ((EventFactHandle)handle).isExpired()) {
                InternalFactHandle internalFactHandle = handle;
                return internalFactHandle;
            }
            if (activation != null) {
                activation.getPropagationContext().releaseResources();
            }
            if (originalObject != object || !RuleBaseConfiguration.AssertBehaviour.IDENTITY.equals(this.ruleBase.getConfiguration().getAssertBehaviour())) {
                this.objectStore.removeHandle(handle);
                handle.setObject(object);
                this.objectStore.addHandle(handle, object);
            }
            this.handleFactory.increaseFactHandleRecency(handle);
            Rule rule = activation == null ? null : activation.getRule();
            PropagationContext propagationContext = this.pctxFactory.createPropagationContext(this.wm.getNextPropagationIdCounter(), 2, rule, activation == null ? null : activation.getTuple(), handle, this.entryPoint, mask, modifiedClass, null);
            if (typeConf.isTMSEnabled()) {
                EqualityKey newKey = this.tms.get(object);
                EqualityKey oldKey = handle.getEqualityKey();
                if (newKey == null) {
                    if (oldKey.getStatus() == 2) {
                        TruthMaintenanceSystemHelper.removeLogicalDependencies(oldKey.getFactHandle(), propagationContext);
                    }
                    oldKey.removeFactHandle(handle);
                    if (oldKey.isEmpty()) {
                        this.getTruthMaintenanceSystem().remove(oldKey);
                    }
                    newKey = new EqualityKey(handle, 1);
                    handle.setEqualityKey(newKey);
                    this.getTruthMaintenanceSystem().put(newKey);
                } else if (newKey != oldKey) {
                    oldKey.removeFactHandle(handle);
                    if (oldKey.isEmpty()) {
                        this.getTruthMaintenanceSystem().remove(oldKey);
                    }
                    if (newKey.getStatus() == 2) {
                        TruthMaintenanceSystemHelper.removeLogicalDependencies(newKey.getFactHandle(), propagationContext);
                        newKey.setStatus(1);
                    }
                    handle = newKey.getFactHandle();
                } else if (!updateLogical && oldKey.getStatus() == 2) {
                    TruthMaintenanceSystemHelper.removeLogicalDependencies(oldKey.getFactHandle(), propagationContext);
                }
            }
            this.entryPointNode.modifyObject(handle, propagationContext, typeConf, (InternalWorkingMemory)this.wm);
            propagationContext.evaluateActionQueue(this.wm);
            this.wm.workingMemoryEventSupport.fireObjectUpdated(propagationContext, handle, originalObject, object, this.wm);
            this.wm.executeQueuedActions();
            if (rule == null) {
                this.wm.getAgenda().unstageActivations();
            }
        }
        finally {
            this.wm.endOperation();
            this.ruleBase.readUnlock();
            this.lock.unlock();
        }
        return handle;
    }

    @Override
    public void retract(org.kie.api.runtime.rule.FactHandle handle) throws FactException {
        this.delete((FactHandle)handle, null, null);
    }

    @Override
    public void delete(org.kie.api.runtime.rule.FactHandle handle) throws FactException {
        this.delete((FactHandle)handle, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(FactHandle factHandle, Rule rule, Activation activation) throws FactException {
        if (factHandle == null) {
            throw new IllegalArgumentException("FactHandle cannot be null ");
        }
        try {
            TraitableBean traitableBean;
            this.lock.lock();
            this.ruleBase.readLock();
            this.wm.startOperation();
            this.ruleBase.executeQueuedActions();
            InternalFactHandle handle = (InternalFactHandle)factHandle;
            if (handle.getId() == -1) {
                return;
            }
            if (handle.isDisconnected()) {
                handle = this.objectStore.reconnect(handle);
            }
            if (handle.isTraitable() && (traitableBean = (TraitableBean)handle.getObject()).hasTraits()) {
                PriorityQueue removedTypes = new PriorityQueue(traitableBean._getTraitMap().values().size());
                removedTypes.addAll(traitableBean._getTraitMap().values());
                while (!removedTypes.isEmpty()) {
                    TraitProxy proxy = (TraitProxy)removedTypes.poll();
                    if (proxy.isVirtual()) continue;
                    this.delete(this.getFactHandle(proxy), rule, activation);
                }
            }
            if (handle.getEntryPoint() != this) {
                throw new IllegalArgumentException("Invalid Entry Point. You updated the FactHandle on entry point '" + handle.getEntryPoint().getEntryPointId() + "' instead of '" + this.getEntryPointId() + "'");
            }
            Object object = handle.getObject();
            ObjectTypeConf typeConf = this.typeConfReg.getObjectTypeConf(this.entryPoint, object);
            if (typeConf.isSupportsPropertyChangeListeners()) {
                this.removePropertyChangeListener(handle, true);
            }
            if (activation != null) {
                activation.getPropagationContext().releaseResources();
            }
            PropagationContext propagationContext = this.pctxFactory.createPropagationContext(this.wm.getNextPropagationIdCounter(), 1, rule, activation == null ? null : activation.getTuple(), handle, this.entryPoint);
            this.entryPointNode.retractObject(handle, propagationContext, typeConf, this.wm);
            if (typeConf.isTMSEnabled()) {
                TruthMaintenanceSystem tms = this.getTruthMaintenanceSystem();
                EqualityKey key = handle.getEqualityKey();
                if (key.getStatus() == 2) {
                    TruthMaintenanceSystemHelper.removeLogicalDependencies(handle, propagationContext);
                }
                key.removeFactHandle(handle);
                handle.setEqualityKey(null);
                if (key.isEmpty()) {
                    tms.remove(key);
                }
            }
            if (handle.isTraiting() && handle.getObject() instanceof TraitProxy) {
                ((TraitProxy)handle.getObject()).getObject().removeTrait(((TraitProxy)handle.getObject()).getTypeCode());
            }
            propagationContext.evaluateActionQueue(this.wm);
            this.wm.workingMemoryEventSupport.fireObjectRetracted(propagationContext, handle, object, this.wm);
            this.wm.executeQueuedActions();
            this.objectStore.removeHandle(handle);
            this.handleFactory.destroyFactHandle(handle);
            if (rule == null) {
                this.wm.getAgenda().unstageActivations();
            }
        }
        finally {
            this.wm.endOperation();
            this.ruleBase.readUnlock();
            this.lock.unlock();
        }
    }

    protected void addPropertyChangeListener(InternalFactHandle handle, boolean dynamicFlag) {
        Object object = handle.getObject();
        try {
            Method method = object.getClass().getMethod("addPropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
            method.invoke(object, this.addRemovePropertyChangeListenerArgs);
            if (dynamicFlag) {
                if (this.dynamicFacts == null) {
                    this.dynamicFacts = new HashSet<InternalFactHandle>();
                }
                this.dynamicFacts.add(handle);
            }
        }
        catch (NoSuchMethodException e) {
            log.error("Warning: Method addPropertyChangeListener not found on the class " + object.getClass() + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalArgumentException e) {
            log.error("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " does not take" + " a simple PropertyChangeListener argument" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalAccessException e) {
            log.error("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " is not public" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (InvocationTargetException e) {
            log.error("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " threw an InvocationTargetException" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            log.error("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a" + " addPropertyChangeListener method" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
    }

    protected void removePropertyChangeListener(FactHandle handle, boolean removeFromSet) {
        Object object = null;
        try {
            object = ((InternalFactHandle)handle).getObject();
            if (this.dynamicFacts != null && removeFromSet) {
                this.dynamicFacts.remove(object);
            }
            if (object != null) {
                Method mehod = object.getClass().getMethod("removePropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
                mehod.invoke(object, this.addRemovePropertyChangeListenerArgs);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeDroolsException("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " does not take a simple PropertyChangeListener argument so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " is not public so Drools will be unable to stop processing JavaBean PropertyChangeEvents on the retracted Object");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeDroolsException("Warning: The removePropertyChangeL istener method on the class " + object.getClass() + " threw an InvocationTargetException so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new RuntimeDroolsException("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a removePropertyChangeListener method so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
    }

    @Override
    public WorkingMemoryEntryPoint getWorkingMemoryEntryPoint(String name) {
        return this.wm.getWorkingMemoryEntryPoint(name);
    }

    @Override
    public ObjectTypeConfigurationRegistry getObjectTypeConfigurationRegistry() {
        return this.typeConfReg;
    }

    @Override
    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    @Override
    public FactHandle getFactHandle(Object object) {
        return this.objectStore.getHandleForObject(object);
    }

    @Override
    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public InternalWorkingMemory getInternalWorkingMemory() {
        return this.wm;
    }

    @Override
    public FactHandle getFactHandleByIdentity(Object object) {
        return this.objectStore.getHandleForObjectIdentity(object);
    }

    @Override
    public Object getObject(org.kie.api.runtime.rule.FactHandle factHandle) {
        return this.objectStore.getObjectForHandle(factHandle);
    }

    @Override
    public <T extends org.kie.api.runtime.rule.FactHandle> Collection<T> getFactHandles() {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, null, 1);
    }

    @Override
    public <T extends org.kie.api.runtime.rule.FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, filter, 1);
    }

    @Override
    public Collection<? extends Object> getObjects() {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, null, 0);
    }

    @Override
    public Collection<? extends Object> getObjects(ObjectFilter filter) {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, filter, 0);
    }

    @Override
    public String getEntryPointId() {
        return this.entryPoint.getEntryPointId();
    }

    @Override
    public long getFactCount() {
        return this.objectStore.size();
    }

    private InternalFactHandle createHandle(Object object, ObjectTypeConf typeConf) {
        InternalFactHandle handle = this.handleFactory.newFactHandle(object, typeConf, this.wm, this);
        this.objectStore.addHandle(handle, object);
        return handle;
    }

    private void enableTMS(Object object, ObjectTypeConf conf) {
        Rete source = this.ruleBase.getRete();
        ClassObjectType cot = new ClassObjectType(object.getClass());
        Map<ObjectType, ObjectTypeNode> map = source.getObjectTypeNodes(EntryPointId.DEFAULT);
        ObjectTypeNode node = map.get(cot);
        ObjectHashSet memory = ((ObjectTypeNode.ObjectTypeNodeMemory)this.wm.getNodeMemory((MemoryFactory)node)).memory;
        Iterator it = memory.iterator();
        Object obj = it.next();
        while (obj != null) {
            ObjectHashSet.ObjectEntry holder = (ObjectHashSet.ObjectEntry)obj;
            InternalFactHandle handle = (InternalFactHandle)holder.getValue();
            if (handle != null && handle.getEqualityKey() == null) {
                EqualityKey key = new EqualityKey(handle);
                handle.setEqualityKey(key);
                key.setStatus(1);
                this.getTruthMaintenanceSystem().put(key);
            }
            obj = it.next();
        }
        conf.enableTMS();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object object = event.getSource();
        try {
            FactHandle handle = this.getFactHandle(object);
            if (handle == null) {
                throw new FactException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
            }
            this.update(handle, object);
        }
        catch (FactException e) {
            throw new RuntimeDroolsException(e.getMessage());
        }
    }

    @Override
    public void dispose() {
        if (this.dynamicFacts != null) {
            for (InternalFactHandle handle : this.dynamicFacts) {
                this.removePropertyChangeListener(handle, false);
            }
            this.dynamicFacts = null;
        }
        for (ObjectTypeConf conf : this.typeConfReg.values()) {
            if (!conf.isDynamic() || !conf.isSupportsPropertyChangeListeners()) continue;
            ObjectTypeNode otn = conf.getConcreteObjectTypeNode();
            ObjectHashSet memory = ((ObjectTypeNode.ObjectTypeNodeMemory)this.getInternalWorkingMemory().getNodeMemory((MemoryFactory)otn)).memory;
            Iterator it = memory.iterator();
            ObjectHashSet.ObjectEntry entry = (ObjectHashSet.ObjectEntry)it.next();
            while (entry != null) {
                InternalFactHandle handle = (InternalFactHandle)entry.getValue();
                this.removePropertyChangeListener(handle, false);
                entry = (ObjectHashSet.ObjectEntry)it.next();
            }
        }
    }

    public void enQueueWorkingMemoryAction(WorkingMemoryAction action) {
        this.wm.queueWorkingMemoryAction(action);
    }

    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        if (this.tms == null) {
            this.tms = new TruthMaintenanceSystem(this.wm, this);
        }
        return this.tms;
    }
}

