/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.kie.api.definition.type.Annotation;
import org.kie.api.definition.type.FactField;
import org.kie.api.definition.type.FactType;

public class ClassDefinition
implements FactType {
    private String className;
    private String superClass;
    private String[] interfaces;
    private transient Class<?> definedClass;
    private TRAITING_MODE traitable;
    private boolean abstrakt = false;
    private Map<String, Object> metaData;
    private LinkedHashMap<String, FieldDefinition> fields = new LinkedHashMap();
    private List<AnnotationDefinition> annotations;
    private Map<String, List<String>> modifiedPropsByMethod;

    public ClassDefinition() {
        this(null, null, null);
    }

    public ClassDefinition(String className) {
        this(className, null, null);
    }

    public ClassDefinition(String className, String superClass) {
        this(className, superClass, null);
    }

    public ClassDefinition(String className, String superClass, String[] interfaces) {
        this.setClassName(className);
        this.setSuperClass(superClass);
        this.setInterfaces(interfaces);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
        this.superClass = (String)in.readObject();
        this.interfaces = (String[])in.readObject();
        this.fields = (LinkedHashMap)in.readObject();
        this.annotations = (List)in.readObject();
        this.modifiedPropsByMethod = (Map)in.readObject();
        this.traitable = (TRAITING_MODE)((Object)in.readObject());
        this.abstrakt = in.readBoolean();
        this.metaData = (HashMap)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.superClass);
        out.writeObject(this.interfaces);
        out.writeObject(this.fields);
        out.writeObject(this.annotations);
        out.writeObject(this.modifiedPropsByMethod);
        out.writeObject((Object)this.traitable);
        out.writeBoolean(this.abstrakt);
        out.writeObject(this.metaData);
    }

    public final String getClassName() {
        return this.className;
    }

    public final void setClassName(String className) {
        this.className = className;
    }

    public final Class<?> getDefinedClass() {
        return this.definedClass;
    }

    public void setDefinedClass(Class<?> definedClass) {
        this.definedClass = definedClass;
    }

    public final void addField(FieldDefinition attr) {
        this.fields.put(attr.getName(), attr);
    }

    public final Collection<FieldDefinition> getFieldsDefinitions() {
        return Collections.unmodifiableCollection(this.fields.values());
    }

    @Override
    public final FieldDefinition getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public FieldDefinition getFieldByAlias(String alias) {
        for (FactField factField : this.getFields()) {
            FieldDefinition def = (FieldDefinition)factField;
            if (!def.resolveAlias().equals(alias)) continue;
            return def;
        }
        return null;
    }

    public FieldDefinition getField(int index) {
        if (index >= this.fields.size() || index < 0) {
            throw new IndexOutOfBoundsException("Error trying to access field at position " + index);
        }
        Iterator<FieldDefinition> iter = this.fields.values().iterator();
        for (int j = 0; j < index; ++j) {
            iter.next();
        }
        return iter.next();
    }

    public final String[] getInterfaces() {
        return this.interfaces;
    }

    public final void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces != null ? interfaces : new String[]{};
    }

    @Override
    public final String getSuperClass() {
        return this.superClass;
    }

    public final void setSuperClass(String superClass) {
        this.superClass = superClass != null ? superClass : "java.lang.Object";
    }

    @Override
    public String getName() {
        return this.getClassName();
    }

    @Override
    public String getSimpleName() {
        return this.getClassName().substring(this.getClassName().lastIndexOf(46) + 1);
    }

    @Override
    public String getPackageName() {
        return this.getClassName().substring(0, this.getClassName().lastIndexOf(46));
    }

    @Override
    public Object newInstance() throws InstantiationException, IllegalAccessException {
        return this.definedClass.newInstance();
    }

    @Override
    public Class<?> getFactClass() {
        return this.getDefinedClass();
    }

    @Override
    public List<FactField> getFields() {
        return new ArrayList<FactField>(this.fields.values());
    }

    @Override
    public Object get(Object bean, String field) {
        return this.getField(field).getFieldAccessor().getValue(bean);
    }

    @Override
    public void set(Object bean, String field, Object value) {
        this.getField(field).getFieldAccessor().setValue(bean, value);
    }

    @Override
    public Map<String, Object> getAsMap(Object bean) {
        HashMap<String, Object> m = new HashMap<String, Object>(this.fields.size());
        for (Map.Entry<String, FieldDefinition> ent : this.fields.entrySet()) {
            Object val = ent.getValue().getFieldAccessor().getValue(bean);
            m.put(ent.getKey(), val);
        }
        return m;
    }

    @Override
    public void setFromMap(Object bean, Map<String, Object> data) {
        for (Map.Entry<String, Object> ent : data.entrySet()) {
            this.set(bean, ent.getKey(), ent.getValue());
        }
    }

    public void addAnnotation(AnnotationDefinition annotationDefinition) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<AnnotationDefinition>();
        }
        this.annotations.add(annotationDefinition);
    }

    public List<AnnotationDefinition> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<Annotation> getClassAnnotations() {
        return Collections.unmodifiableList(new ArrayList<AnnotationDefinition>(this.annotations));
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public void addMetaData(String key, Object value) {
        if (this.metaData == null) {
            this.metaData = new HashMap<String, Object>();
        }
        this.metaData.put(key, value);
    }

    public void addModifiedPropsByMethod(Method method, List<String> props) {
        if (this.modifiedPropsByMethod == null) {
            this.modifiedPropsByMethod = new HashMap<String, List<String>>();
        }
        String methodName = method.getName() + "_" + method.getParameterTypes().length;
        this.modifiedPropsByMethod.put(methodName, props);
    }

    public List<String> getModifiedPropsByMethod(Method method) {
        String methodName = method.getName() + "_" + method.getParameterTypes().length;
        return this.getModifiedPropsByMethod(methodName);
    }

    public List<String> getModifiedPropsByMethod(String methodName) {
        return this.modifiedPropsByMethod == null ? null : this.modifiedPropsByMethod.get(methodName);
    }

    public boolean isTraitable() {
        return this.traitable != null && this.traitable != TRAITING_MODE.NONE;
    }

    public void setTraitable(boolean traitable) {
        this.setTraitable(traitable, false);
    }

    public void setTraitable(boolean traitable, boolean enableLogical) {
        this.traitable = !traitable ? TRAITING_MODE.NONE : (enableLogical ? TRAITING_MODE.LOGICAL : TRAITING_MODE.BASIC);
    }

    public boolean isFullTraiting() {
        return this.traitable == TRAITING_MODE.LOGICAL;
    }

    public boolean isAbstrakt() {
        return this.abstrakt;
    }

    public void setAbstrakt(boolean abstrakt) {
        this.abstrakt = abstrakt;
    }

    public String toString() {
        return "ClassDefinition{className='" + this.className + '\'' + ", superClass='" + this.superClass + '\'' + ", interfaces=" + (this.interfaces == null ? null : Arrays.asList(this.interfaces)) + ", definedClass=" + this.definedClass + ", traitable=" + (Object)((Object)this.traitable) + ", abstract=" + this.abstrakt + ", fields=" + this.fields + ", annotations=" + this.annotations + '}';
    }

    public static enum TRAITING_MODE {
        NONE,
        BASIC,
        LOGICAL;

    }
}

