/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel.traits;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.core.factmodel.BuildUtils;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.traits.TraitFactory;
import org.drools.core.factmodel.traits.TraitFieldTMS;
import org.drools.core.factmodel.traits.TraitPropertyWrapperClassBuilder;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.factmodel.traits.TraitRegistry;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.factmodel.traits.TripleBasedStruct;
import org.drools.core.util.Triple;
import org.drools.core.util.TripleFactory;
import org.drools.core.util.TripleStore;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Type;

public class TraitTriplePropertyWrapperClassBuilderImpl
implements TraitPropertyWrapperClassBuilder,
Serializable {
    private transient ClassDefinition trait;
    private transient TraitRegistry traitRegistry;

    protected ClassDefinition getTrait() {
        return this.trait;
    }

    @Override
    public void init(ClassDefinition trait, TraitRegistry traitRegistry) {
        this.trait = trait;
        this.traitRegistry = traitRegistry;
    }

    @Override
    public byte[] buildClass(ClassDefinition core) throws IOException, IntrospectionException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        ClassWriter cw = new ClassWriter(1);
        BitSet mask = this.traitRegistry.getFieldMask(this.trait.getName(), core.getDefinedClass().getName());
        String name = TraitFactory.getPropertyWrapperName(this.trait, core);
        String masterName = TraitFactory.getProxyName(this.trait, core);
        String internalWrapper = BuildUtils.getInternalType(name);
        String descrCore = Type.getDescriptor(core.getDefinedClass());
        String internalCore = Type.getInternalName(core.getDefinedClass());
        cw.visit(50, 33, internalWrapper, null, Type.getInternalName(TripleBasedStruct.class), new String[]{Type.getInternalName(Serializable.class)});
        cw.visitInnerClass(Type.getInternalName(Map.Entry.class), Type.getInternalName(Map.class), "Entry", 1545);
        FieldVisitor fv = cw.visitField(0, "object", descrCore, null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedStruct.class), "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "<init>", "(" + descrCore + Type.getDescriptor(TripleStore.class) + Type.getDescriptor(TripleFactory.class) + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedStruct.class), "<init>", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, internalWrapper, "object", descrCore);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, internalWrapper, "store", Type.getDescriptor(TripleStore.class));
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, Type.getInternalName(TripleBasedStruct.class), "setTripleFactory", "(" + Type.getDescriptor(TripleFactory.class) + ")V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, Type.getInternalName(TripleStore.class), "getId", "()" + Type.getDescriptor(String.class));
        mv.visitFieldInsn(181, internalWrapper, "storeId", Type.getDescriptor(String.class));
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, internalWrapper, "initSoftFields", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        this.buildInitSoftFields(cw, internalWrapper, this.trait, core, mask);
        this.buildClearSoftFields(cw, internalWrapper, this.trait, mask);
        this.buildSize(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildIsEmpty(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildGet(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildPut(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildClear(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildRemove(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildContainsKey(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildContainsValue(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildKeyset(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildValues(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildEntryset(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildCommonMethods(cw, name);
        this.buildSpecificMethods(cw, name, core);
        this.buildExtensionMethods(cw, name, core);
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected void invokeRemove(MethodVisitor mv, String wrapperName, ClassDefinition core, String fieldName, FieldDefinition field) {
        mv.visitLdcInsn(fieldName);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(String.class), "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        TraitFactory.invokeExtractor(mv, wrapperName, this.trait, core, field);
        if (BuildUtils.isPrimitive(field.getTypeName())) {
            TraitFactory.valueOf(mv, field.getTypeName());
        }
        mv.visitVarInsn(58, 2);
        TraitFactory.invokeInjector(mv, wrapperName, this.trait, core, field, true, 1);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        mv.visitLabel(l1);
    }

    protected void buildRemove(ClassWriter cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, BitSet mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        MethodVisitor mv = cw.visitMethod(1, "remove", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class), null, null);
        mv.visitCode();
        int stack = 0;
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            stack = Math.max(stack, BuildUtils.sizeOf(field.getTypeName()));
            this.invokeRemove(mv, wrapperName, core, field.getName(), field);
        }
        int j = 0;
        for (FieldDefinition field : trait.getFieldsDefinitions()) {
            boolean isSoftField = TraitRegistry.isSoftField(field, j++, mask);
            if (!isSoftField) continue;
            stack = Math.max(stack, BuildUtils.sizeOf(field.getTypeName()));
            mv.visitLdcInsn(field.getName());
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, Type.getInternalName(String.class), "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
            Label l2 = new Label();
            mv.visitJumpInsn(153, l2);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, internalWrapper, "store", Type.getDescriptor(TripleStore.class));
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(field.getName());
            mv.visitMethodInsn(182, internalWrapper, "propertyKey", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Triple.class));
            mv.visitMethodInsn(182, Type.getInternalName(TripleStore.class), "get", "(" + Type.getDescriptor(Triple.class) + ")" + Type.getDescriptor(Triple.class));
            mv.visitVarInsn(58, 2);
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(field.getName());
            mv.visitInsn(BuildUtils.zero(field.getTypeName()));
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                TraitFactory.valueOf(mv, field.getTypeName());
            }
            mv.visitMethodInsn(183, Type.getInternalName(TripleBasedStruct.class), "put", "(" + Type.getDescriptor(String.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
            mv.visitInsn(87);
            mv.visitVarInsn(25, 2);
            mv.visitInsn(176);
            mv.visitLabel(l2);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedStruct.class), "remove", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected boolean mustSkip(FieldDefinition field) {
        return false;
    }

    protected void buildInitSoftFields(ClassWriter cw, String wrapperName, ClassDefinition trait, ClassDefinition core, BitSet mask) {
        MethodVisitor mv = cw.visitMethod(2, "initSoftFields", "()V", null, null);
        mv.visitCode();
        int stackSize = this.initSoftFields(mv, wrapperName, trait, core, mask);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected int initSoftFields(MethodVisitor mv, String wrapperName, ClassDefinition trait, ClassDefinition core, BitSet mask) {
        int j = 0;
        int stackSize = 0;
        for (FieldDefinition field : trait.getFieldsDefinitions()) {
            boolean isSoftField;
            if (this.mustSkip(field) || !(isSoftField = TraitRegistry.isSoftField(field, j++, mask))) continue;
            int size = this.initSoftField(mv, wrapperName, field, core, wrapperName);
            stackSize = Math.max(stackSize, size);
        }
        return stackSize;
    }

    protected int initSoftField(MethodVisitor mv, String wrapperName, FieldDefinition field, ClassDefinition core, String internalWrapper) {
        int size = 0;
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, wrapperName, "store", Type.getDescriptor(TripleStore.class));
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(field.resolveAlias());
        mv.visitMethodInsn(182, wrapperName, "propertyKey", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Triple.class));
        mv.visitMethodInsn(182, Type.getInternalName(TripleStore.class), "contains", "(" + Type.getDescriptor(Triple.class) + ")Z");
        Label l0 = new Label();
        mv.visitJumpInsn(154, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, wrapperName, "store", Type.getDescriptor(TripleStore.class));
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(field.resolveAlias());
        mv.visitInsn(BuildUtils.zero(field.getTypeName()));
        if (BuildUtils.isPrimitive(field.getTypeName())) {
            TraitFactory.valueOf(mv, field.getTypeName());
            size = BuildUtils.sizeOf(field.getTypeName());
        } else {
            size = 2;
        }
        mv.visitMethodInsn(182, wrapperName, "property", "(" + Type.getDescriptor(String.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Triple.class));
        mv.visitInsn(4);
        mv.visitMethodInsn(182, Type.getInternalName(TripleStore.class), "put", "(" + Type.getDescriptor(Triple.class) + "Z)Z");
        if (core.isFullTraiting()) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, internalWrapper, "object", Type.getDescriptor(core.getDefinedClass()));
            mv.visitTypeInsn(192, Type.getInternalName(TraitableBean.class));
            mv.visitMethodInsn(185, Type.getInternalName(TraitableBean.class), "_getFieldTMS", Type.getMethodDescriptor(Type.getType(TraitFieldTMS.class), new Type[0]));
            mv.visitVarInsn(58, 1);
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn(field.resolveAlias());
            mv.visitMethodInsn(185, Type.getInternalName(TraitFieldTMS.class), "isManagingField", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[]{Type.getType(String.class)}));
            Label l1 = new Label();
            mv.visitJumpInsn(154, l1);
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn(Type.getType(BuildUtils.getTypeDescriptor(core.getClassName())));
            mv.visitLdcInsn(field.resolveAlias());
            mv.visitMethodInsn(185, Type.getInternalName(TraitFieldTMS.class), "registerField", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(Class.class), Type.getType(String.class)}));
            mv.visitLabel(l1);
        }
        mv.visitInsn(87);
        mv.visitLabel(l0);
        return size;
    }

    protected void buildClear(ClassWriter cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, BitSet mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        boolean hasPrimitiveFields = false;
        boolean hasObjectFields = false;
        MethodVisitor mv = cw.visitMethod(1, "clear", "()V", null, null);
        mv.visitCode();
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            if (field.isKey()) continue;
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                hasPrimitiveFields = true;
            } else {
                hasObjectFields = true;
            }
            TraitFactory.invokeInjector(mv, wrapperName, trait, core, field, true, 1);
        }
        int stack = 2;
        if (hasPrimitiveFields) {
            ++stack;
        }
        if (hasObjectFields) {
            ++stack;
        }
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedStruct.class), "clear", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, internalWrapper, "clearSoftFields", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildClearSoftFields(ClassWriter cw, String wrapperName, ClassDefinition trait, BitSet mask) {
        MethodVisitor mv = cw.visitMethod(2, "clearSoftFields", "()V", null, null);
        mv.visitCode();
        int j = 0;
        int stackSize = 0;
        for (FieldDefinition field : trait.getFieldsDefinitions()) {
            boolean isSoftField = TraitRegistry.isSoftField(field, j++, mask);
            if (!isSoftField) continue;
            int size = this.clearSoftField(mv, wrapperName, field);
            stackSize = Math.max(stackSize, size);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected int clearSoftField(MethodVisitor mv, String wrapperName, FieldDefinition field) {
        int size = 0;
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, wrapperName, "store", Type.getDescriptor(TripleStore.class));
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(field.getName());
        mv.visitInsn(BuildUtils.zero(field.getTypeName()));
        if (BuildUtils.isPrimitive(field.getTypeName())) {
            TraitFactory.valueOf(mv, field.getTypeName());
            size = BuildUtils.sizeOf(field.getTypeName());
        } else {
            size = 2;
        }
        mv.visitMethodInsn(182, wrapperName, "property", "(" + Type.getDescriptor(String.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Triple.class));
        mv.visitInsn(4);
        mv.visitMethodInsn(182, Type.getInternalName(TripleStore.class), "put", "(" + Type.getDescriptor(Triple.class) + "Z)Z");
        mv.visitInsn(87);
        return size;
    }

    protected void buildContainsValue(ClassWriter cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, BitSet mask) {
        MethodVisitor mv = cw.visitMethod(1, "containsValue", "(" + Type.getDescriptor(Object.class) + ")Z", null, null);
        mv.visitCode();
        boolean hasNillable = false;
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            if (BuildUtils.isPrimitive(field.getTypeName())) continue;
            hasNillable = true;
        }
        Label l99 = null;
        if (hasNillable) {
            mv.visitVarInsn(25, 1);
            l99 = new Label();
            mv.visitJumpInsn(199, l99);
        }
        int j = 0;
        int N = core.getFieldsDefinitions().size();
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            ++j;
            if (BuildUtils.isPrimitive(field.getTypeName())) continue;
            TraitFactory.invokeExtractor(mv, wrapperName, trait, core, field);
            if (j != N) {
                Label l1 = new Label();
                mv.visitJumpInsn(199, l1);
                mv.visitInsn(4);
                mv.visitInsn(172);
                mv.visitLabel(l1);
                continue;
            }
            mv.visitJumpInsn(199, l99);
            mv.visitInsn(4);
            mv.visitInsn(172);
            mv.visitLabel(l99);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedStruct.class), "containsValue", "(" + Type.getDescriptor(Object.class) + ")Z");
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void invokeContainsKey(MethodVisitor mv, String fieldName) {
        mv.visitLdcInsn(fieldName);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(String.class), "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
        Label l0 = new Label();
        mv.visitJumpInsn(153, l0);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l0);
    }

    protected void buildContainsKey(ClassWriter cw, String name, String className, ClassDefinition trait, ClassDefinition core, BitSet mask) {
        MethodVisitor mv = cw.visitMethod(1, "containsKey", "(" + Type.getDescriptor(Object.class) + ")Z", null, null);
        mv.visitCode();
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            this.invokeContainsKey(mv, field.getName());
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedStruct.class), "containsKey", "(" + Type.getDescriptor(Object.class) + ")Z");
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildSize(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, BitSet mask) {
        MethodVisitor mv = cw.visitMethod(1, "size", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedStruct.class), "size", "()I");
        int n = core.getFieldsDefinitions().size();
        for (int j = 0; j < n; ++j) {
            mv.visitInsn(4);
            mv.visitInsn(96);
        }
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildIsEmpty(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, BitSet mask) {
        boolean hasHardFields = core.getFieldsDefinitions().size() > 0;
        MethodVisitor mv = cw.visitMethod(1, "isEmpty", "()Z", null, null);
        mv.visitCode();
        if (!hasHardFields) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, Type.getInternalName(TripleBasedStruct.class), "isEmpty", "()Z");
        } else {
            mv.visitInsn(3);
        }
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void invokeGet(MethodVisitor mv, String wrapperName, ClassDefinition core, String fieldName, FieldDefinition field) {
        mv.visitLdcInsn(fieldName);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "java/lang/String", "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
        Label l0 = new Label();
        mv.visitJumpInsn(153, l0);
        TraitFactory.invokeExtractor(mv, wrapperName, this.trait, core, field);
        if (BuildUtils.isPrimitive(field.getTypeName())) {
            TraitFactory.valueOf(mv, field.getTypeName());
        }
        mv.visitInsn(176);
        mv.visitLabel(l0);
    }

    protected void buildGet(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, BitSet mask) {
        MethodVisitor mv = cw.visitMethod(1, "get", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class), null, null);
        mv.visitCode();
        if (core.getFieldsDefinitions().size() > 0) {
            for (FieldDefinition field : core.getFieldsDefinitions()) {
                this.invokeGet(mv, wrapperName, core, field.getName(), field);
            }
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedStruct.class), "get", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void invokePut(MethodVisitor mv, String wrapperName, ClassDefinition core, String fieldName, FieldDefinition field) {
        mv.visitLdcInsn(fieldName);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(String.class), "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        mv.visitVarInsn(25, 2);
        if (BuildUtils.isPrimitive(field.getTypeName())) {
            TraitFactory.primitiveValue(mv, field.getTypeName());
            mv.visitVarInsn(BuildUtils.storeType(field.getTypeName()), 3);
            TraitFactory.invokeInjector(mv, wrapperName, this.trait, core, field, false, 3);
        } else {
            TraitFactory.invokeInjector(mv, wrapperName, this.trait, core, field, false, 2);
        }
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        mv.visitLabel(l1);
    }

    protected void buildPut(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, BitSet mask) {
        MethodVisitor mv = cw.visitMethod(1, "put", "(" + Type.getDescriptor(String.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class), null, null);
        mv.visitCode();
        if (core.getFieldsDefinitions().size() > 0) {
            boolean j = false;
            for (FieldDefinition field : core.getFieldsDefinitions()) {
                this.invokePut(mv, wrapperName, core, field.getName(), field);
            }
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedStruct.class), "put", "(" + Type.getDescriptor(String.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildEntryset(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, BitSet mask) {
        MethodVisitor mv = cw.visitMethod(1, "entrySet", "()" + Type.getDescriptor(Set.class), "()Ljava/util/Set<Ljava/util/Map$Entry<Ljava/lang/String;Ljava/lang/Object;>;>;", null);
        mv.visitCode();
        mv.visitTypeInsn(187, Type.getInternalName(HashSet.class));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName(HashSet.class), "<init>", "()V");
        mv.visitVarInsn(58, 1);
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn(field.getName());
            TraitFactory.invokeExtractor(mv, wrapperName, trait, core, field);
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                TraitFactory.valueOf(mv, field.getTypeName());
            }
            mv.visitMethodInsn(184, Type.getInternalName(TraitProxy.class), "buildEntry", "(" + Type.getDescriptor(String.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Map.Entry.class));
            mv.visitMethodInsn(185, Type.getInternalName(Set.class), "add", "(" + Type.getDescriptor(Object.class) + ")Z");
            mv.visitInsn(87);
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedStruct.class), "entrySet", "()" + Type.getDescriptor(Set.class));
        mv.visitMethodInsn(185, Type.getInternalName(Set.class), "addAll", "(" + Type.getDescriptor(Collection.class) + ")Z");
        mv.visitInsn(87);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildKeyset(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, BitSet mask) {
        MethodVisitor mv = cw.visitMethod(1, "keySet", "()" + Type.getDescriptor(Set.class), "()Ljava/util/Set<Ljava/lang/String;>;", null);
        mv.visitCode();
        mv.visitTypeInsn(187, Type.getInternalName(HashSet.class));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName(HashSet.class), "<init>", "()V");
        mv.visitVarInsn(58, 1);
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn(field.getName());
            mv.visitMethodInsn(185, Type.getInternalName(Set.class), "add", "(" + Type.getDescriptor(Object.class) + ")Z");
            mv.visitInsn(87);
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedStruct.class), "keySet", "()" + Type.getDescriptor(Set.class));
        mv.visitMethodInsn(185, Type.getInternalName(Set.class), "addAll", "(" + Type.getDescriptor(Collection.class) + ")Z");
        mv.visitInsn(87);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildValues(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, BitSet mask) {
        MethodVisitor mv = cw.visitMethod(1, "values", "()" + Type.getDescriptor(Collection.class), "()Ljava/util/Collection<Ljava/lang/Object;>;", null);
        mv.visitCode();
        mv.visitTypeInsn(187, Type.getInternalName(ArrayList.class));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName(ArrayList.class), "<init>", "()V");
        mv.visitVarInsn(58, 1);
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 1);
            TraitFactory.invokeExtractor(mv, wrapperName, trait, core, field);
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                TraitFactory.valueOf(mv, field.getTypeName());
            }
            mv.visitMethodInsn(185, Type.getInternalName(Collection.class), "add", "(" + Type.getDescriptor(Object.class) + ")Z");
            mv.visitInsn(87);
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedStruct.class), "values", "()" + Type.getDescriptor(Collection.class));
        mv.visitMethodInsn(185, Type.getInternalName(Collection.class), "addAll", "(" + Type.getDescriptor(Collection.class) + ")Z");
        mv.visitInsn(87);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public void buildCommonMethods(ClassVisitor cw, String wrapper) {
        MethodVisitor mv = cw.visitMethod(1, "toString", "()" + Type.getDescriptor(String.class), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, Type.getInternalName(StringBuilder.class));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName(StringBuilder.class), "<init>", "()V");
        mv.visitLdcInsn("[[");
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(" + Type.getDescriptor(String.class) + ")" + Type.getDescriptor(StringBuilder.class));
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(wrapper), "entrySet", "()" + Type.getDescriptor(Set.class));
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(StringBuilder.class));
        mv.visitLdcInsn("]]");
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(" + Type.getDescriptor(String.class) + ")" + Type.getDescriptor(StringBuilder.class));
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "toString", "()" + Type.getDescriptor(String.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "put", "(" + Type.getDescriptor(Object.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(String.class));
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(wrapper), "put", "(" + Type.getDescriptor(String.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildSpecificMethods(ClassWriter cw, String wrapper, ClassDefinition core) {
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(wrapper), "object", BuildUtils.getTypeDescriptor(core.getName()));
        mv.visitMethodInsn(182, BuildUtils.getInternalType(wrapper), "getTriplesForSubject", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Collection.class));
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "hashCode", "()I");
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(4, "getObject", "()" + Type.getDescriptor(Object.class), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(wrapper), "object", BuildUtils.getTypeDescriptor(core.getName()));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "setObject", "(" + Type.getDescriptor(Object.class) + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, BuildUtils.getInternalType(core.getName()));
        mv.visitFieldInsn(181, BuildUtils.getInternalType(wrapper), "object", BuildUtils.getTypeDescriptor(core.getName()));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildExtensionMethods(ClassWriter cw, String name, ClassDefinition core) {
    }
}

