/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.marshalling.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;

public class IdentityPlaceholderResolverStrategy
implements ObjectMarshallingStrategy {
    private Map<Integer, Object> ids;
    private Map<Object, Integer> objects;
    private ObjectMarshallingStrategyAcceptor acceptor;

    public IdentityPlaceholderResolverStrategy(ObjectMarshallingStrategyAcceptor acceptor) {
        this.acceptor = acceptor;
        this.ids = new HashMap<Integer, Object>();
        this.objects = new IdentityHashMap<Object, Integer>();
    }

    @Override
    public Object read(ObjectInputStream os) throws IOException, ClassNotFoundException {
        int id = os.readInt();
        return this.ids.get(id);
    }

    @Override
    public void write(ObjectOutputStream os, Object object) throws IOException {
        Integer id = this.objects.get(object);
        if (id == null) {
            id = this.ids.size();
            this.ids.put(id, object);
            this.objects.put(object, id);
        }
        os.writeInt(id);
    }

    @Override
    public boolean accept(Object object) {
        return this.acceptor.accept(object);
    }

    @Override
    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream os, Object object) {
        Integer id = this.objects.get(object);
        if (id == null) {
            id = this.ids.size();
            this.ids.put(id, object);
            this.objects.put(object, id);
        }
        return this.intToByteArray(id);
    }

    @Override
    public Object unmarshal(ObjectMarshallingStrategy.Context context, ObjectInputStream is, byte[] object, ClassLoader classloader) {
        return this.ids.get(this.byteArrayToInt(object));
    }

    private final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    private final int byteArrayToInt(byte[] b) {
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }

    @Override
    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }
}

