/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.marshalling.impl;

import java.io.IOException;
import java.util.Date;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.QueryElementFactHandle;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.rule.EntryPointId;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.CronTrigger;
import org.drools.core.time.impl.IntervalTrigger;
import org.drools.core.time.impl.PointInTimeTrigger;
import org.drools.core.util.StringUtils;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.rule.EntryPoint;

public class InputMarshaller {
    public static InternalFactHandle readFactHandle(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        String entryPointId;
        String strategyClassName;
        int type = context.stream.readInt();
        int id = context.stream.readInt();
        long recency = context.stream.readLong();
        long startTimeStamp = 0L;
        long duration = 0L;
        boolean expired = false;
        long activationsCount = 0L;
        if (type == 2) {
            startTimeStamp = context.stream.readLong();
            duration = context.stream.readLong();
            expired = context.stream.readBoolean();
            activationsCount = context.stream.readLong();
        }
        int strategyIndex = context.stream.readInt();
        Object object = null;
        ObjectMarshallingStrategy strategy = null;
        if (strategyIndex >= 0) {
            strategy = context.resolverStrategyFactory.getStrategy(strategyIndex);
        } else if (strategyIndex == -2 && !StringUtils.isEmpty(strategyClassName = context.stream.readUTF()) && (strategy = context.resolverStrategyFactory.getStrategyObject(strategyClassName)) == null) {
            throw new IllegalStateException("No strategy of type " + strategyClassName + " available.");
        }
        if (strategy != null) {
            object = strategy.read(context.stream);
        }
        EntryPoint entryPoint = null;
        if (context.readBoolean() && (entryPointId = context.readUTF()) != null && !entryPointId.equals("")) {
            entryPoint = context.wm.getEntryPoints().get(entryPointId);
        }
        EntryPointId confEP = entryPoint != null ? ((NamedEntryPoint)entryPoint).getEntryPoint() : context.wm.getEntryPoint();
        ObjectTypeConf typeConf = context.wm.getObjectTypeConfigurationRegistry().getObjectTypeConf(confEP, object);
        InternalFactHandle handle = null;
        switch (type) {
            case 0: {
                handle = new DefaultFactHandle(id, object, recency, entryPoint, typeConf != null && typeConf.isTrait());
                break;
            }
            case 1: {
                handle = new QueryElementFactHandle(object, id, recency);
                break;
            }
            case 2: {
                handle = new EventFactHandle(id, object, recency, startTimeStamp, duration, entryPoint, typeConf != null && typeConf.isTrait());
                ((EventFactHandle)handle).setExpired(expired);
                ((EventFactHandle)handle).setActivationsCount(activationsCount);
                break;
            }
            default: {
                throw new IllegalStateException("Unable to marshal FactHandle, as type does not exist:" + type);
            }
        }
        return handle;
    }

    public static WorkItem readWorkItem(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setId(stream.readLong());
        workItem.setProcessInstanceId(stream.readLong());
        workItem.setName(stream.readUTF());
        workItem.setState(stream.readInt());
        int nbVariables = stream.readInt();
        if (nbVariables > 0) {
            for (int i = 0; i < nbVariables; ++i) {
                String name = stream.readUTF();
                try {
                    int index = stream.readInt();
                    ObjectMarshallingStrategy strategy = null;
                    if (index >= 0) {
                        strategy = context.resolverStrategyFactory.getStrategy(index);
                        if (strategy == null) {
                            throw new IllegalStateException("No strategy of with index " + index + " available.");
                        }
                    } else if (index == -2) {
                        String strategyClassName = stream.readUTF();
                        if ("org.drools.marshalling.impl.SerializablePlaceholderResolverStrategy".equals(strategyClassName)) {
                            strategyClassName = "org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy";
                        }
                        if ((strategy = context.resolverStrategyFactory.getStrategyObject(strategyClassName)) == null) {
                            throw new IllegalStateException("No strategy of type " + strategyClassName + " available.");
                        }
                    }
                    Object value = strategy.read(stream);
                    workItem.setParameter(name, value);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Could not reload variable " + name);
                }
            }
        }
        return workItem;
    }

    public static Trigger readTrigger(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
        short triggerInt = inCtx.readShort();
        switch (triggerInt) {
            case 70: {
                long startTime = inCtx.readLong();
                CronTrigger trigger = new CronTrigger();
                trigger.setStartTime(new Date(startTime));
                if (inCtx.readBoolean()) {
                    long endTime = inCtx.readLong();
                    trigger.setEndTime(new Date(endTime));
                }
                int repeatLimit = inCtx.readInt();
                trigger.setRepeatLimit(repeatLimit);
                int repeatCount = inCtx.readInt();
                trigger.setRepeatCount(repeatCount);
                String expr = inCtx.readUTF();
                trigger.setCronExpression(expr);
                if (inCtx.readBoolean()) {
                    long nextFireTime = inCtx.readLong();
                    trigger.setNextFireTime(new Date(nextFireTime));
                }
                String[] calendarNames = (String[])inCtx.readObject();
                trigger.setCalendarNames(calendarNames);
                return trigger;
            }
            case 71: {
                IntervalTrigger trigger = new IntervalTrigger();
                long startTime = inCtx.readLong();
                trigger.setStartTime(new Date(startTime));
                if (inCtx.readBoolean()) {
                    long endTime = inCtx.readLong();
                    trigger.setEndTime(new Date(endTime));
                }
                int repeatLimit = inCtx.readInt();
                trigger.setRepeatLimit(repeatLimit);
                int repeatCount = inCtx.readInt();
                trigger.setRepeatCount(repeatCount);
                if (inCtx.readBoolean()) {
                    long nextFireTime = inCtx.readLong();
                    trigger.setNextFireTime(new Date(nextFireTime));
                }
                long period = inCtx.readLong();
                trigger.setPeriod(period);
                String[] calendarNames = (String[])inCtx.readObject();
                trigger.setCalendarNames(calendarNames);
                return trigger;
            }
            case 72: {
                long startTime = inCtx.readLong();
                PointInTimeTrigger trigger = new PointInTimeTrigger(startTime, null, null);
                return trigger;
            }
        }
        throw new RuntimeException("Unable to persist Trigger for type: " + triggerInt);
    }
}

