/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class ConsequenceMetaData
implements Externalizable {
    private List<Statement> statements;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.statements);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.statements = (List)in.readObject();
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void addStatement(Statement statement) {
        if (this.statements == null) {
            this.statements = new ArrayList<Statement>();
        }
        this.statements.add(statement);
    }

    public String toString() {
        return this.statements.toString();
    }

    public static class Field
    implements Externalizable {
        private String name;
        private String value;

        public Field() {
        }

        public Field(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.name);
            out.writeObject(this.value);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = (String)in.readObject();
            this.value = (String)in.readObject();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isLiteral() {
            return this.value != null && this.value.length() > 0 && (Character.isDigit(this.value.charAt(0)) || this.value.charAt(0) == '\"' || "true".equals(this.value) || "false".equals(this.value));
        }

        public String toString() {
            return this.name + " = " + this.value;
        }
    }

    public static class Statement
    implements Externalizable {
        private Type type;
        private String factClassName;
        private List<Field> fields;

        public Statement() {
        }

        public Statement(Type type, Class<?> factClass) {
            this.type = type;
            this.factClassName = factClass.getName();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject((Object)this.type);
            out.writeObject(this.factClassName);
            out.writeObject(this.fields);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = (Type)((Object)in.readObject());
            this.factClassName = (String)in.readObject();
            this.fields = (List)in.readObject();
        }

        public Type getType() {
            return this.type;
        }

        public String getFactClassName() {
            return this.factClassName;
        }

        public List<Field> getFields() {
            return this.fields;
        }

        public void addField(Field field) {
            if (this.fields == null) {
                this.fields = new ArrayList<Field>();
            }
            this.fields.add(field);
        }

        public void addField(String name, String value) {
            this.addField(new Field(name, value));
        }

        public String toString() {
            return "Modifications to " + this.factClassName + ": " + this.fields;
        }

        public static enum Type {
            INSERT,
            RETRACT,
            MODIFY;

        }
    }
}

