/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractXStreamConverter
implements Converter {
    private final Class type;

    protected AbstractXStreamConverter(Class type) {
        this.type = type;
    }

    @Override
    public boolean canConvert(Class clazz) {
        return this.type.isAssignableFrom(clazz);
    }

    protected void writeAttribute(HierarchicalStreamWriter writer, String name, String value) {
        if (value != null) {
            writer.addAttribute(name, value);
        }
    }

    protected void writeString(HierarchicalStreamWriter writer, String name, String value) {
        if (value != null) {
            writer.startNode(name);
            writer.setValue(value);
            writer.endNode();
        }
    }

    protected void writeObject(HierarchicalStreamWriter writer, MarshallingContext context, String name, Object value) {
        if (value != null) {
            writer.startNode(name);
            context.convertAnother(value);
            writer.endNode();
        }
    }

    protected void writeList(HierarchicalStreamWriter writer, String listName, String itemName, Iterable<String> list) {
        Iterator<String> i;
        if (list != null && (i = list.iterator()).hasNext()) {
            writer.startNode(listName);
            while (i.hasNext()) {
                writer.startNode(itemName);
                writer.setValue(i.next());
                writer.endNode();
            }
            writer.endNode();
        }
    }

    protected void writeObjectList(HierarchicalStreamWriter writer, MarshallingContext context, String listName, String itemName, Iterable<? extends Object> list) {
        Iterator<? extends Object> i;
        if (list != null && (i = list.iterator()).hasNext()) {
            writer.startNode(listName);
            while (i.hasNext()) {
                this.writeObject(writer, context, itemName, i.next());
            }
            writer.endNode();
        }
    }

    protected void readNodes(HierarchicalStreamReader reader, NodeReader nodeReader) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            nodeReader.onNode(reader, reader.getNodeName(), reader.getValue());
            reader.moveUp();
        }
    }

    protected List<String> readList(HierarchicalStreamReader reader) {
        ArrayList<String> list = new ArrayList<String>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            list.add(reader.getValue());
            reader.moveUp();
        }
        return list;
    }

    protected <T> T readObject(HierarchicalStreamReader reader, UnmarshallingContext context, Class<? extends T> clazz) {
        return (T)context.convertAnother(reader.getValue(), clazz);
    }

    protected <T> List<T> readObjectList(HierarchicalStreamReader reader, UnmarshallingContext context, Class<? extends T> clazz) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            list.add(context.convertAnother(reader.getValue(), clazz));
            reader.moveUp();
        }
        return list;
    }

    public static interface NodeReader {
        public void onNode(HierarchicalStreamReader var1, String var2, String var3);
    }
}

