/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.constraint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;

public abstract class ConstraintMatchTotal
implements Serializable,
Comparable<ConstraintMatchTotal> {
    protected final String constraintPackage;
    protected final String constraintName;
    protected final int scoreLevel;

    protected ConstraintMatchTotal(String constraintPackage, String constraintName, int scoreLevel) {
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.scoreLevel = scoreLevel;
    }

    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public int getScoreLevel() {
        return this.scoreLevel;
    }

    public abstract Set<? extends ConstraintMatch> getConstraintMatchSet();

    public abstract Number getWeightTotalAsNumber();

    protected List<Object> extractJustificationList(RuleContext kcontext) {
        List<Object> droolsMatchObjects = kcontext.getMatch().getObjects();
        ArrayList<Object> justificationList = new ArrayList<Object>(droolsMatchObjects);
        Collections.reverse(justificationList);
        return justificationList;
    }

    public String getIdentificationString() {
        return this.constraintPackage + "/" + this.constraintName + "/level" + this.scoreLevel;
    }

    @Override
    public int compareTo(ConstraintMatchTotal other) {
        return new CompareToBuilder().append((Object)this.getConstraintPackage(), (Object)other.getConstraintPackage()).append((Object)this.getConstraintName(), (Object)other.getConstraintName()).append(this.getScoreLevel(), other.getScoreLevel()).append((Object)this.getWeightTotalAsNumber(), (Object)other.getWeightTotalAsNumber()).toComparison();
    }

    public String toString() {
        return this.getIdentificationString() + "=" + this.getWeightTotalAsNumber();
    }
}

