/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.holder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.AgendaItem;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.RuleContext;
import org.kie.api.runtime.rule.RuleRuntime;
import org.kie.internal.event.rule.ActivationUnMatchListener;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.bigdecimal.BigDecimalConstraintMatch;
import org.optaplanner.core.api.score.constraint.bigdecimal.BigDecimalConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.primdouble.DoubleConstraintMatch;
import org.optaplanner.core.api.score.constraint.primdouble.DoubleConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.primint.IntConstraintMatch;
import org.optaplanner.core.api.score.constraint.primint.IntConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.primlong.LongConstraintMatch;
import org.optaplanner.core.api.score.constraint.primlong.LongConstraintMatchTotal;
import org.optaplanner.core.api.score.holder.ScoreHolder;

public abstract class AbstractScoreHolder
implements ScoreHolder,
Serializable {
    protected final boolean constraintMatchEnabled;
    protected final Map<List<Object>, ConstraintMatchTotal> constraintMatchTotalMap;

    protected AbstractScoreHolder(boolean constraintMatchEnabled) {
        this.constraintMatchEnabled = constraintMatchEnabled;
        this.constraintMatchTotalMap = constraintMatchEnabled ? new LinkedHashMap() : null;
    }

    @Override
    public boolean isConstraintMatchEnabled() {
        return this.constraintMatchEnabled;
    }

    @Override
    public Collection<ConstraintMatchTotal> getConstraintMatchTotals() {
        return this.constraintMatchTotalMap.values();
    }

    protected void registerIntConstraintMatch(RuleContext kcontext, int scoreLevel, int weight, final Runnable undoListener) {
        AgendaItem agendaItem = this.prepareAgendaItemForUnMatchListener(kcontext);
        if (!this.constraintMatchEnabled) {
            agendaItem.setActivationUnMatchListener(new ActivationUnMatchListener(){

                @Override
                public void unMatch(RuleRuntime wm, Match activation) {
                    undoListener.run();
                }
            });
        } else {
            final IntConstraintMatchTotal constraintMatchTotal = this.findIntConstraintMatchTotal(kcontext, scoreLevel);
            final IntConstraintMatch constraintMatch = constraintMatchTotal.addConstraintMatch(kcontext, weight);
            agendaItem.setActivationUnMatchListener(new ActivationUnMatchListener(){

                @Override
                public void unMatch(RuleRuntime wm, Match activation) {
                    undoListener.run();
                    constraintMatchTotal.removeConstraintMatch(constraintMatch);
                }
            });
        }
    }

    private IntConstraintMatchTotal findIntConstraintMatchTotal(RuleContext kcontext, int scoreLevel) {
        Rule rule = kcontext.getRule();
        String constraintPackage = rule.getPackageName();
        String constraintName = rule.getName();
        List<Object> key = Arrays.asList(constraintPackage, constraintName, scoreLevel);
        IntConstraintMatchTotal matchTotal = (IntConstraintMatchTotal)this.constraintMatchTotalMap.get(key);
        if (matchTotal == null) {
            matchTotal = new IntConstraintMatchTotal(constraintPackage, constraintName, scoreLevel);
            this.constraintMatchTotalMap.put(key, matchTotal);
        }
        return matchTotal;
    }

    protected void registerLongConstraintMatch(RuleContext kcontext, int scoreLevel, long weight, final Runnable undoListener) {
        AgendaItem agendaItem = this.prepareAgendaItemForUnMatchListener(kcontext);
        if (!this.constraintMatchEnabled) {
            agendaItem.setActivationUnMatchListener(new ActivationUnMatchListener(){

                @Override
                public void unMatch(RuleRuntime wm, Match activation) {
                    undoListener.run();
                }
            });
        } else {
            final LongConstraintMatchTotal constraintMatchTotal = this.findLongConstraintMatchTotal(kcontext, scoreLevel);
            final LongConstraintMatch constraintMatch = constraintMatchTotal.addConstraintMatch(kcontext, weight);
            agendaItem.setActivationUnMatchListener(new ActivationUnMatchListener(){

                @Override
                public void unMatch(RuleRuntime wm, Match activation) {
                    undoListener.run();
                    constraintMatchTotal.removeConstraintMatch(constraintMatch);
                }
            });
        }
    }

    private LongConstraintMatchTotal findLongConstraintMatchTotal(RuleContext kcontext, int scoreLevel) {
        Rule rule = kcontext.getRule();
        String constraintPackage = rule.getPackageName();
        String constraintName = rule.getName();
        List<Object> key = Arrays.asList(constraintPackage, constraintName, scoreLevel);
        LongConstraintMatchTotal matchTotal = (LongConstraintMatchTotal)this.constraintMatchTotalMap.get(key);
        if (matchTotal == null) {
            matchTotal = new LongConstraintMatchTotal(constraintPackage, constraintName, scoreLevel);
            this.constraintMatchTotalMap.put(key, matchTotal);
        }
        return matchTotal;
    }

    protected void registerDoubleConstraintMatch(RuleContext kcontext, int scoreLevel, double weight, final Runnable undoListener) {
        AgendaItem agendaItem = this.prepareAgendaItemForUnMatchListener(kcontext);
        if (!this.constraintMatchEnabled) {
            agendaItem.setActivationUnMatchListener(new ActivationUnMatchListener(){

                @Override
                public void unMatch(RuleRuntime wm, Match activation) {
                    undoListener.run();
                }
            });
        } else {
            final DoubleConstraintMatchTotal constraintMatchTotal = this.findDoubleConstraintMatchTotal(kcontext, scoreLevel);
            final DoubleConstraintMatch constraintMatch = constraintMatchTotal.addConstraintMatch(kcontext, weight);
            agendaItem.setActivationUnMatchListener(new ActivationUnMatchListener(){

                @Override
                public void unMatch(RuleRuntime wm, Match activation) {
                    undoListener.run();
                    constraintMatchTotal.removeConstraintMatch(constraintMatch);
                }
            });
        }
    }

    private DoubleConstraintMatchTotal findDoubleConstraintMatchTotal(RuleContext kcontext, int scoreLevel) {
        Rule rule = kcontext.getRule();
        String constraintPackage = rule.getPackageName();
        String constraintName = rule.getName();
        List<Object> key = Arrays.asList(constraintPackage, constraintName, scoreLevel);
        DoubleConstraintMatchTotal matchTotal = (DoubleConstraintMatchTotal)this.constraintMatchTotalMap.get(key);
        if (matchTotal == null) {
            matchTotal = new DoubleConstraintMatchTotal(constraintPackage, constraintName, scoreLevel);
            this.constraintMatchTotalMap.put(key, matchTotal);
        }
        return matchTotal;
    }

    protected void registerBigDecimalConstraintMatch(RuleContext kcontext, int scoreLevel, BigDecimal weight, final Runnable undoListener) {
        AgendaItem agendaItem = this.prepareAgendaItemForUnMatchListener(kcontext);
        if (!this.constraintMatchEnabled) {
            agendaItem.setActivationUnMatchListener(new ActivationUnMatchListener(){

                @Override
                public void unMatch(RuleRuntime wm, Match activation) {
                    undoListener.run();
                }
            });
        } else {
            final BigDecimalConstraintMatchTotal constraintMatchTotal = this.findBigDecimalConstraintMatchTotal(kcontext, scoreLevel);
            final BigDecimalConstraintMatch constraintMatch = constraintMatchTotal.addConstraintMatch(kcontext, weight);
            agendaItem.setActivationUnMatchListener(new ActivationUnMatchListener(){

                @Override
                public void unMatch(RuleRuntime wm, Match activation) {
                    undoListener.run();
                    constraintMatchTotal.removeConstraintMatch(constraintMatch);
                }
            });
        }
    }

    private BigDecimalConstraintMatchTotal findBigDecimalConstraintMatchTotal(RuleContext kcontext, int scoreLevel) {
        Rule rule = kcontext.getRule();
        String constraintPackage = rule.getPackageName();
        String constraintName = rule.getName();
        List<Object> key = Arrays.asList(constraintPackage, constraintName, scoreLevel);
        BigDecimalConstraintMatchTotal matchTotal = (BigDecimalConstraintMatchTotal)this.constraintMatchTotalMap.get(key);
        if (matchTotal == null) {
            matchTotal = new BigDecimalConstraintMatchTotal(constraintPackage, constraintName, scoreLevel);
            this.constraintMatchTotalMap.put(key, matchTotal);
        }
        return matchTotal;
    }

    private AgendaItem prepareAgendaItemForUnMatchListener(RuleContext kcontext) {
        AgendaItem agendaItem = (AgendaItem)kcontext.getMatch();
        if (agendaItem.getActivationUnMatchListener() != null) {
            agendaItem.getActivationUnMatchListener().unMatch(null, null);
        }
        return agendaItem;
    }
}

