/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.optaplanner.core.impl.domain.value.FromEntityPropertyPlanningValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.CachedListRandomIterator;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;

public class FromEntityPropertyValueSelector
extends AbstractValueSelector {
    protected final PlanningVariableDescriptor variableDescriptor;
    protected final FromEntityPropertyPlanningValueRangeDescriptor valueRangeDescriptor;
    protected final boolean randomSelection;

    public FromEntityPropertyValueSelector(FromEntityPropertyPlanningValueRangeDescriptor valueRangeDescriptor, SelectionCacheType cacheType, boolean randomSelection) {
        this.variableDescriptor = valueRangeDescriptor.getVariableDescriptor();
        this.valueRangeDescriptor = valueRangeDescriptor;
        this.randomSelection = randomSelection;
        if (cacheType.compareTo(SelectionCacheType.STEP) > 0) {
            throw new IllegalArgumentException("The selector (" + this + ") does not support the cacheType (" + (Object)((Object)cacheType) + ").");
        }
    }

    @Override
    public PlanningVariableDescriptor getVariableDescriptor() {
        return this.variableDescriptor;
    }

    @Override
    public boolean isContinuous() {
        return this.variableDescriptor.isContinuous();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.isContinuous();
    }

    @Override
    public long getSize(Object entity) {
        Collection<?> values = this.valueRangeDescriptor.extractValuesFromEntity(entity);
        long size = values.size();
        if (this.variableDescriptor.isNullable()) {
            ++size;
        }
        return size;
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        Collection<?> values = this.valueRangeDescriptor.extractValuesFromEntity(entity);
        ArrayList valueList = new ArrayList(values.size() + 1);
        valueList.addAll(values);
        if (this.variableDescriptor.isNullable()) {
            valueList.add(null);
        }
        if (!this.randomSelection) {
            return valueList.iterator();
        }
        return new CachedListRandomIterator<Object>(valueList, this.workingRandom);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getVariableName() + ")";
    }
}

