/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.variable;

import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.variable.PlanningValueSelectionOrder;
import org.optaplanner.core.impl.heuristic.selector.variable.PlanningValueSelectionPromotion;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.score.director.ScoreDirector;

@Deprecated
public class PlanningValueSelector
extends SolverPhaseLifecycleListenerAdapter {
    private PlanningVariableDescriptor variableDescriptor;
    private PlanningValueSelectionOrder selectionOrder = PlanningValueSelectionOrder.ORIGINAL;
    private PlanningValueSelectionPromotion selectionPromotion = PlanningValueSelectionPromotion.NONE;
    private boolean roundRobinSelection = false;
    private ScoreDirector scoreDirector;
    private Random workingRandom;
    private Collection<?> cachedPlanningValues = null;

    public PlanningValueSelector(PlanningVariableDescriptor variableDescriptor) {
        this.variableDescriptor = variableDescriptor;
    }

    public void setSelectionOrder(PlanningValueSelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public void setSelectionPromotion(PlanningValueSelectionPromotion selectionPromotion) {
        this.selectionPromotion = selectionPromotion;
    }

    public void setRoundRobinSelection(boolean roundRobinSelection) {
        this.roundRobinSelection = roundRobinSelection;
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope phaseScope) {
        this.scoreDirector = phaseScope.getScoreDirector();
        this.workingRandom = phaseScope.getWorkingRandom();
        this.initSelectedPlanningValueList(phaseScope);
    }

    private void initSelectedPlanningValueList(AbstractSolverPhaseScope phaseScope) {
        if (this.variableDescriptor.isPlanningValuesCacheable()) {
            Collection<?> planningValues = this.variableDescriptor.extractPlanningValues(phaseScope.getWorkingSolution(), null);
            this.cachedPlanningValues = this.applySelectionOrder(planningValues);
        } else {
            this.cachedPlanningValues = null;
        }
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope phaseScope) {
        this.cachedPlanningValues = null;
    }

    public Iterator<?> iterator(Object planningEntity) {
        if (this.cachedPlanningValues != null) {
            return this.cachedPlanningValues.iterator();
        }
        Collection<?> planningValues = this.variableDescriptor.extractPlanningValues(this.scoreDirector.getWorkingSolution(), planningEntity);
        planningValues = this.applySelectionOrder(planningValues);
        return planningValues.iterator();
    }

    private Collection<?> applySelectionOrder(Collection<?> workingPlanningValues) {
        switch (this.selectionOrder) {
            case ORIGINAL: {
                return workingPlanningValues;
            }
        }
        throw new IllegalStateException("The selectionOrder (" + (Object)((Object)this.selectionOrder) + ") is not implemented.");
    }
}

