/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.phase.custom;

import java.util.Iterator;
import java.util.List;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.phase.AbstractSolverPhase;
import org.optaplanner.core.impl.phase.custom.CustomSolverPhase;
import org.optaplanner.core.impl.phase.custom.CustomSolverPhaseCommand;
import org.optaplanner.core.impl.phase.custom.scope.CustomSolverPhaseScope;
import org.optaplanner.core.impl.phase.custom.scope.CustomStepScope;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class DefaultCustomSolverPhase
extends AbstractSolverPhase
implements CustomSolverPhase {
    protected List<CustomSolverPhaseCommand> customSolverPhaseCommandList;
    protected boolean forceUpdateBestSolution;

    public void setCustomSolverPhaseCommandList(List<CustomSolverPhaseCommand> customSolverPhaseCommandList) {
        this.customSolverPhaseCommandList = customSolverPhaseCommandList;
    }

    public void setForceUpdateBestSolution(boolean forceUpdateBestSolution) {
        this.forceUpdateBestSolution = forceUpdateBestSolution;
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        CustomSolverPhaseScope phaseScope = new CustomSolverPhaseScope(solverScope);
        this.phaseStarted(phaseScope);
        CustomStepScope stepScope = new CustomStepScope(phaseScope);
        Iterator<CustomSolverPhaseCommand> commandIterator = this.customSolverPhaseCommandList.iterator();
        while (!this.termination.isPhaseTerminated(phaseScope) && commandIterator.hasNext()) {
            CustomSolverPhaseCommand customSolverPhaseCommand = commandIterator.next();
            this.stepStarted(stepScope);
            customSolverPhaseCommand.changeWorkingSolution(solverScope.getScoreDirector());
            int uninitializedVariableCount = solverScope.getSolutionDescriptor().countUninitializedVariables(stepScope.getWorkingSolution());
            stepScope.setUninitializedVariableCount(uninitializedVariableCount);
            Score score = phaseScope.calculateScore();
            stepScope.setScore(score);
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
            stepScope = new CustomStepScope(phaseScope);
        }
        this.phaseEnded(phaseScope);
    }

    public void phaseStarted(CustomSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
    }

    public void stepStarted(CustomStepScope stepScope) {
        super.stepStarted(stepScope);
    }

    public void stepEnded(CustomStepScope stepScope) {
        super.stepEnded(stepScope);
        boolean bestScoreImproved = stepScope.getBestScoreImproved();
        if (this.forceUpdateBestSolution && !bestScoreImproved) {
            DefaultSolverScope solverScope = stepScope.getPhaseScope().getSolverScope();
            Solution newBestSolution = solverScope.getScoreDirector().cloneWorkingSolution();
            this.bestSolutionRecaller.updateBestSolution(solverScope, newBestSolution, stepScope.getUninitializedVariableCount());
        }
        CustomSolverPhaseScope phaseScope = stepScope.getPhaseScope();
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpend = phaseScope.calculateSolverTimeMillisSpend();
            this.logger.debug("    Step index ({}), time spend ({}), score ({}), {} best score ({}).", new Object[]{stepScope.getStepIndex(), timeMillisSpend, stepScope.getScore(), bestScoreImproved ? "new" : (this.forceUpdateBestSolution ? "forced" : "   "), phaseScope.getBestScore()});
        }
    }

    public void phaseEnded(CustomSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.logger.info("Phase ({}) custom ended: step total ({}), time spend ({}), best score ({}).", new Object[]{this.phaseIndex, phaseScope.getLastCompletedStepScope().getStepIndex() + 1, phaseScope.calculateSolverTimeMillisSpend(), phaseScope.getBestScore()});
    }
}

