/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.simplebigdecimal;

import java.math.BigDecimal;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScoreHolder;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.score.definition.AbstractScoreDefinition;

public class SimpleBigDecimalScoreDefinition
extends AbstractScoreDefinition<SimpleBigDecimalScore> {
    private SimpleBigDecimalScore perfectMaximumScore = SimpleBigDecimalScore.valueOf(BigDecimal.ZERO);
    private SimpleBigDecimalScore perfectMinimumScore = null;

    @Override
    public SimpleBigDecimalScore getPerfectMaximumScore() {
        return this.perfectMaximumScore;
    }

    public void setPerfectMaximumScore(SimpleBigDecimalScore perfectMaximumScore) {
        this.perfectMaximumScore = perfectMaximumScore;
    }

    @Override
    public SimpleBigDecimalScore getPerfectMinimumScore() {
        return this.perfectMinimumScore;
    }

    public void setPerfectMinimumScore(SimpleBigDecimalScore perfectMinimumScore) {
        this.perfectMinimumScore = perfectMinimumScore;
    }

    @Override
    public Class<SimpleBigDecimalScore> getScoreClass() {
        return SimpleBigDecimalScore.class;
    }

    @Override
    public Score parseScore(String scoreString) {
        return SimpleBigDecimalScore.parseScore(scoreString);
    }

    @Override
    public double calculateTimeGradient(SimpleBigDecimalScore startScore, SimpleBigDecimalScore endScore, SimpleBigDecimalScore score) {
        if (score.getScore().compareTo(endScore.getScore()) >= 0) {
            return 1.0;
        }
        if (startScore.getScore().compareTo(score.getScore()) >= 0) {
            return 0.0;
        }
        BigDecimal scoreTotal = endScore.getScore().subtract(startScore.getScore());
        BigDecimal scoreDelta = score.getScore().subtract(startScore.getScore());
        return scoreDelta.divide(scoreTotal).doubleValue();
    }

    @Override
    public ScoreHolder buildScoreHolder(boolean constraintMatchEnabled) {
        return new SimpleBigDecimalScoreHolder(constraintMatchEnabled);
    }
}

