/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.builder.impl.ClassDefinitionFactory;
import org.drools.compiler.builder.impl.ClassHierarchyManager;
import org.drools.compiler.builder.impl.DeclaredClassBuilder;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDeclarationCache;
import org.drools.compiler.builder.impl.TypeDeclarationConfigurator;
import org.drools.compiler.builder.impl.TypeDeclarationFactory;
import org.drools.compiler.builder.impl.TypeDeclarationNameResolver;
import org.drools.compiler.builder.impl.TypeDefinition;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.compiler.lang.descr.AbstractClassTypeDeclarationDescr;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.EnumDeclarationDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.QualifiedName;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Trait;
import org.drools.core.factmodel.traits.Traitable;
import org.drools.core.rule.TypeDeclaration;
import org.kie.api.io.Resource;

public class TypeDeclarationBuilder {
    protected final KnowledgeBuilderImpl kbuilder;
    protected final Set<String> generatedTypes = new HashSet<String>();
    protected TypeDeclarationCache classDeclarationExtractor;
    protected TypeDeclarationNameResolver typeDeclarationNameResolver;
    protected TypeDeclarationFactory typeDeclarationFactory;
    protected ClassDefinitionFactory classDefinitionFactory;
    protected TypeDeclarationConfigurator typeDeclarationConfigurator;
    protected DeclaredClassBuilder declaredClassBuilder;

    TypeDeclarationBuilder(KnowledgeBuilderImpl kbuilder) {
        this.kbuilder = kbuilder;
        this.classDeclarationExtractor = new TypeDeclarationCache(kbuilder);
        this.typeDeclarationNameResolver = new TypeDeclarationNameResolver(kbuilder);
        this.typeDeclarationFactory = new TypeDeclarationFactory(kbuilder);
        this.classDefinitionFactory = new ClassDefinitionFactory(kbuilder);
        this.typeDeclarationConfigurator = new TypeDeclarationConfigurator(kbuilder);
        this.declaredClassBuilder = new DeclaredClassBuilder(kbuilder);
    }

    public TypeDeclaration getAndRegisterTypeDeclaration(Class<?> cls, String packageName) {
        return this.classDeclarationExtractor.getAndRegisterTypeDeclaration(cls, packageName);
    }

    public TypeDeclaration getTypeDeclaration(Class<?> cls) {
        return this.classDeclarationExtractor.getTypeDeclaration(cls);
    }

    public void removeTypesGeneratedFromResource(Resource resource) {
        this.classDeclarationExtractor.removeTypesGeneratedFromResource(resource);
    }

    void registerGeneratedType(AbstractClassTypeDeclarationDescr typeDescr) {
        String fullName = typeDescr.getType().getFullName();
        this.generatedTypes.add(fullName);
    }

    public void processTypeDeclarations(Collection<? extends PackageDescr> packageDescrs, Collection<AbstractClassTypeDeclarationDescr> unsortedDescrs, List<TypeDefinition> unresolvedTypes, Map<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs) {
        PackageRegistry pkgRegistry;
        for (PackageDescr packageDescr : packageDescrs) {
            if (this.kbuilder.getPackageRegistry(packageDescr.getName()) != null) continue;
            this.kbuilder.createPackageRegistry(packageDescr);
        }
        this.setResourcesInDescriptors(packageDescrs);
        this.typeDeclarationNameResolver.resolveTypes(packageDescrs, unsortedDescrs, unresolvedTypes, unprocesseableDescrs);
        for (PackageDescr packageDescr : packageDescrs) {
            this.normalizeForeignPackages(packageDescr);
        }
        unsortedDescrs = this.compactDefinitionsAndDeclarations(unsortedDescrs, unprocesseableDescrs);
        ClassHierarchyManager classHierarchyManager = new ClassHierarchyManager(unsortedDescrs, this.kbuilder);
        for (AbstractClassTypeDeclarationDescr typeDescr : classHierarchyManager.getSortedDescriptors()) {
            pkgRegistry = this.kbuilder.getPackageRegistry(typeDescr.getNamespace());
            this.createBean(typeDescr, pkgRegistry, classHierarchyManager, unresolvedTypes, unprocesseableDescrs);
        }
        for (AbstractClassTypeDeclarationDescr typeDescr : classHierarchyManager.getSortedDescriptors()) {
            if (unprocesseableDescrs.containsKey(typeDescr.getType().getFullName())) continue;
            pkgRegistry = this.kbuilder.getPackageRegistry(typeDescr.getNamespace());
            this.typeDeclarationConfigurator.wireFieldAccessors(pkgRegistry, typeDescr, pkgRegistry.getPackage().getTypeDeclaration(typeDescr.getType().getName()));
        }
    }

    private Collection<AbstractClassTypeDeclarationDescr> compactDefinitionsAndDeclarations(Collection<AbstractClassTypeDeclarationDescr> unsortedDescrs, Map<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs) {
        HashMap<String, AbstractClassTypeDeclarationDescr> compactedUnsorted = new HashMap<String, AbstractClassTypeDeclarationDescr>(unsortedDescrs.size());
        for (AbstractClassTypeDeclarationDescr descr : unsortedDescrs) {
            if (compactedUnsorted.containsKey(descr.getType().getFullName())) {
                AbstractClassTypeDeclarationDescr prev = (AbstractClassTypeDeclarationDescr)compactedUnsorted.get(descr.getType().getFullName());
                boolean res = this.mergeTypeDescriptors(prev, descr);
                if (res) continue;
                unprocesseableDescrs.put(prev.getType().getFullName(), prev);
                this.kbuilder.addBuilderResult(new TypeDeclarationError(prev, "Found duplicate declaration for type " + prev.getType().getFullName() + ", unable to reconcile "));
                continue;
            }
            compactedUnsorted.put(descr.getType().getFullName(), descr);
        }
        return compactedUnsorted.values();
    }

    private boolean mergeTypeDescriptors(AbstractClassTypeDeclarationDescr prev, AbstractClassTypeDeclarationDescr descr) {
        boolean isDef1 = this.isDefinition(prev);
        boolean isDef2 = this.isDefinition(descr);
        if (isDef1 && isDef2) {
            return false;
        }
        if (!prev.getSuperTypes().isEmpty() && !descr.getSuperTypes().isEmpty() && prev.getSuperTypes().size() != descr.getSuperTypes().size()) {
            return false;
        }
        if (prev.getSuperTypes().isEmpty()) {
            for (QualifiedName qn : descr.getSuperTypes()) {
                ((TypeDeclarationDescr)prev).addSuperType(qn);
            }
        }
        if (prev.getFields().isEmpty()) {
            for (String fieldName : descr.getFields().keySet()) {
                prev.addField(descr.getFields().get(fieldName));
            }
        }
        for (AnnotationDescr ad : descr.getAnnotations()) {
            prev.addQualifiedAnnotation(ad);
        }
        for (AnnotationDescr ad : prev.getAnnotations()) {
            if (descr.getAnnotations().contains(ad)) continue;
            descr.addQualifiedAnnotation(ad);
        }
        return true;
    }

    private boolean isDefinition(AbstractClassTypeDeclarationDescr prev) {
        return !prev.getFields().isEmpty();
    }

    protected void setResourcesInDescriptors(Collection<? extends PackageDescr> packageDescrs) {
        for (PackageDescr packageDescr : packageDescrs) {
            for (AbstractClassTypeDeclarationDescr typeDescr : packageDescr.getClassAndEnumDeclarationDescrs()) {
                if (typeDescr.getResource() != null) continue;
                typeDescr.setResource(this.kbuilder.getCurrentResource());
            }
        }
    }

    protected void createBean(AbstractClassTypeDeclarationDescr typeDescr, PackageRegistry pkgRegistry, ClassHierarchyManager hierarchyManager, List<TypeDefinition> unresolvedTypes, Map<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs) {
        if (typeDescr instanceof TypeDeclarationDescr) {
            hierarchyManager.inheritFields(pkgRegistry, typeDescr, hierarchyManager.getSortedDescriptors(), unresolvedTypes, unprocesseableDescrs);
        }
        TypeDeclaration type = this.typeDeclarationFactory.processTypeDeclaration(pkgRegistry, typeDescr, unresolvedTypes, unprocesseableDescrs);
        boolean success = !this.kbuilder.hasErrors();
        try {
            ClassDefinition def = null;
            if (success) {
                def = this.classDefinitionFactory.generateDeclaredBean(typeDescr, type, pkgRegistry, unresolvedTypes, unprocesseableDescrs);
                if (!type.isNovel()) {
                    this.typeDeclarationFactory.checkRedeclaration(typeDescr, type, pkgRegistry);
                }
            }
            boolean bl = success = def != null && !this.kbuilder.hasErrors();
            if (success) {
                this.updateTraitInformation(typeDescr, type, def, pkgRegistry);
            }
            boolean bl2 = success = !this.kbuilder.hasErrors();
            if (success) {
                this.declaredClassBuilder.generateBeanFromDefinition(typeDescr, type, pkgRegistry, def);
            }
            boolean bl3 = success = !this.kbuilder.hasErrors();
            if (success) {
                Class<?> clazz = pkgRegistry.getTypeResolver().resolveType(typeDescr.getType().getFullName());
                type.setTypeClass(clazz);
                type.setValid(true);
            } else {
                unprocesseableDescrs.put(typeDescr.getType().getFullName(), typeDescr);
                type.setValid(false);
            }
            this.typeDeclarationConfigurator.finalize(type, typeDescr, pkgRegistry, this.kbuilder.getPackageRegistry(), hierarchyManager);
        }
        catch (ClassNotFoundException e) {
            unprocesseableDescrs.put(typeDescr.getType().getFullName(), typeDescr);
            this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Class '" + type.getTypeClassName() + "' not found for type declaration of '" + type.getTypeName() + "'"));
        }
        if (!success) {
            unresolvedTypes.add(new TypeDefinition(type, typeDescr));
        } else {
            this.registerGeneratedType(typeDescr);
        }
    }

    protected void normalizeForeignPackages(PackageDescr packageDescr) {
        HashMap<String, PackageDescr> foreignPackages = null;
        for (AbstractClassTypeDeclarationDescr typeDescr : packageDescr.getClassAndEnumDeclarationDescrs()) {
            PackageDescr altDescr;
            if (!this.kbuilder.filterAccepts(typeDescr.getNamespace(), typeDescr.getTypeName()) || typeDescr.getNamespace().equals(packageDescr.getNamespace())) continue;
            if (foreignPackages == null) {
                foreignPackages = new HashMap<String, PackageDescr>();
            }
            if (foreignPackages.containsKey(typeDescr.getNamespace())) {
                altDescr = (PackageDescr)foreignPackages.get(typeDescr.getNamespace());
            } else {
                altDescr = new PackageDescr(typeDescr.getNamespace());
                foreignPackages.put(typeDescr.getNamespace(), altDescr);
            }
            if (typeDescr instanceof TypeDeclarationDescr) {
                altDescr.addTypeDeclaration((TypeDeclarationDescr)typeDescr);
            } else if (typeDescr instanceof EnumDeclarationDescr) {
                altDescr.addEnumDeclaration((EnumDeclarationDescr)typeDescr);
            }
            for (ImportDescr imp : packageDescr.getImports()) {
                altDescr.addImport(imp);
            }
            if (this.kbuilder.getPackageRegistry().containsKey(altDescr.getNamespace())) continue;
            this.kbuilder.createPackageRegistry(altDescr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTraitInformation(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, ClassDefinition def, PackageRegistry pkgRegistry) {
        block19: {
            if (typeDescr.hasAnnotation(Traitable.class) || !type.getKind().equals((Object)TypeDeclaration.Kind.TRAIT) && this.kbuilder.getPackageRegistry().containsKey(def.getSuperClass()) && this.kbuilder.getPackageRegistry(def.getSuperClass()).getTraitRegistry().getTraitables().containsKey(def.getSuperClass())) {
                if (type.isNovel()) {
                    try {
                        PackageRegistry reg = this.kbuilder.getPackageRegistry(typeDescr.getNamespace());
                        String availableName = typeDescr.getType().getFullName();
                        Class<?> resolvedType = reg.getTypeResolver().resolveType(availableName);
                        this.updateTraitDefinition(type, resolvedType, false);
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                }
                pkgRegistry.getTraitRegistry().addTraitable(def);
            } else if (type.getKind().equals((Object)TypeDeclaration.Kind.TRAIT) || typeDescr.hasAnnotation(Trait.class)) {
                if (!type.isNovel()) {
                    try {
                        PackageRegistry reg = this.kbuilder.getPackageRegistry(typeDescr.getNamespace());
                        String availableName = typeDescr.getType().getFullName();
                        Class<?> resolvedType = reg.getTypeResolver().resolveType(availableName);
                        if (!Thing.class.isAssignableFrom(resolvedType)) {
                            this.updateTraitDefinition(type, resolvedType, false);
                            String target = typeDescr.getTypeName() + "_Trait__Extension";
                            TypeDeclarationDescr tempDescr = new TypeDeclarationDescr();
                            tempDescr.setNamespace(typeDescr.getNamespace());
                            tempDescr.setFields(typeDescr.getFields());
                            tempDescr.setType(target, typeDescr.getNamespace());
                            tempDescr.addSuperType(typeDescr.getType());
                            TypeDeclaration tempDeclr = new TypeDeclaration(target);
                            tempDeclr.setKind(TypeDeclaration.Kind.TRAIT);
                            tempDeclr.setTypesafe(type.isTypesafe());
                            tempDeclr.setNovel(true);
                            tempDeclr.setTypeClassName(tempDescr.getType().getFullName());
                            tempDeclr.setResource(type.getResource());
                            ClassDefinition tempDef = new ClassDefinition(target);
                            tempDef.setClassName(tempDescr.getType().getFullName());
                            tempDef.setTraitable(false);
                            for (FieldDefinition fld : def.getFieldsDefinitions()) {
                                tempDef.addField(fld);
                            }
                            tempDef.setInterfaces(def.getInterfaces());
                            tempDef.setSuperClass(def.getClassName());
                            tempDef.setDefinedClass(resolvedType);
                            tempDef.setAbstrakt(true);
                            tempDeclr.setTypeClassDef(tempDef);
                            type.setKind(TypeDeclaration.Kind.CLASS);
                            this.declaredClassBuilder.generateBeanFromDefinition(tempDescr, tempDeclr, pkgRegistry, tempDef);
                            try {
                                Class<?> clazz = pkgRegistry.getTypeResolver().resolveType(tempDescr.getType().getFullName());
                                tempDeclr.setTypeClass(clazz);
                                pkgRegistry.getTraitRegistry().addTrait(tempDef.getClassName().replace("_Trait__Extension", ""), tempDef);
                                break block19;
                            }
                            catch (ClassNotFoundException cnfe) {
                                this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Internal Trait extension Class '" + target + "' could not be generated correctly'"));
                                break block19;
                            }
                            finally {
                                pkgRegistry.getPackage().addTypeDeclaration(tempDeclr);
                            }
                        }
                        this.updateTraitDefinition(type, resolvedType, true);
                        pkgRegistry.getTraitRegistry().addTrait(def);
                    }
                    catch (ClassNotFoundException cnfe) {}
                } else if (def.getClassName().endsWith("_Trait__Extension")) {
                    pkgRegistry.getTraitRegistry().addTrait(def.getClassName().replace("_Trait__Extension", ""), def);
                } else {
                    pkgRegistry.getTraitRegistry().addTrait(def);
                }
            }
        }
    }

    protected void updateTraitDefinition(TypeDeclaration type, Class concrete, boolean asTrait) {
        ClassDefinitionFactory.populateDefinitionFromClass(type.getTypeClassDef(), concrete, asTrait);
    }
}

