/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.EclipseJavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerFactory;
import org.drools.compiler.commons.jci.problems.CompilationProblem;
import org.drools.compiler.commons.jci.readers.DiskResourceReader;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.FormatConversionResult;
import org.drools.compiler.kie.builder.impl.FormatConverter;
import org.drools.compiler.kie.builder.impl.FormatsManager;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderSetImpl;
import org.drools.compiler.kie.builder.impl.KieFileSystemImpl;
import org.drools.compiler.kie.builder.impl.KieMetaInfoBuilder;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.compiler.kproject.xml.PomModel;
import org.drools.compiler.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.core.builder.conf.impl.ResourceConfigurationImpl;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.internal.builder.KieBuilderSet;
import org.kie.internal.io.ResourceTypeImpl;

public class KieBuilderImpl
implements InternalKieBuilder {
    static final String RESOURCES_ROOT = "src/main/resources/";
    static final String JAVA_ROOT = "src/main/java/";
    static final String JAVA_TEST_ROOT = "src/test/java/";
    private static final String RESOURCES_ROOT_DOT_SEPARATOR = "src/main/resources/".replace('/', '.');
    private ResultsImpl results;
    private final ResourceReader srcMfs;
    private MemoryFileSystem trgMfs;
    private MemoryKieModule kModule;
    private PomModel pomModel;
    private byte[] pomXml;
    private ReleaseId releaseId;
    private byte[] kModuleModelXml;
    private KieModuleModel kModuleModel;
    private Collection<KieModule> kieDependencies;
    private Collection<ReleaseId> jarDependencies;
    private KieBuilderSetImpl kieBuilderSet;

    public KieBuilderImpl(File file) {
        this.srcMfs = new DiskResourceReader(file);
    }

    public KieBuilderImpl(KieFileSystem kieFileSystem) {
        this.srcMfs = ((KieFileSystemImpl)kieFileSystem).asMemoryFileSystem();
    }

    @Override
    public KieBuilder setDependencies(KieModule ... dependencies) {
        this.kieDependencies = Arrays.asList(dependencies);
        return this;
    }

    @Override
    public KieBuilder setDependencies(Resource ... resources) {
        KieRepositoryImpl kr = (KieRepositoryImpl)KieServices.Factory.get().getRepository();
        ArrayList<KieModule> list = new ArrayList<KieModule>();
        for (Resource res : resources) {
            InternalKieModule depKieMod = (InternalKieModule)kr.getKieModule(res);
            list.add(depKieMod);
        }
        this.kieDependencies = list;
        return this;
    }

    private void init() {
        KieServices ks = KieServices.Factory.get();
        this.results = new ResultsImpl();
        this.buildPomModel();
        this.buildKieModuleModel();
        if (this.pomModel != null) {
            this.releaseId = this.pomModel.getReleaseId();
            KieRepositoryImpl repository = (KieRepositoryImpl)ks.getRepository();
            for (ReleaseId dep : this.pomModel.getDependencies()) {
                KieModule depModule = repository.getKieModule(dep, this.pomXml);
                if (depModule != null) {
                    this.addKieDependency(depModule);
                    continue;
                }
                this.addJarDependency(dep);
            }
        } else {
            this.releaseId = KieServices.Factory.get().getRepository().getDefaultReleaseId();
        }
    }

    private void addKieDependency(KieModule depModule) {
        if (this.kieDependencies == null) {
            this.kieDependencies = new ArrayList<KieModule>();
        }
        this.kieDependencies.add(depModule);
    }

    private void addJarDependency(ReleaseId releaseId) {
        if (this.jarDependencies == null) {
            this.jarDependencies = new ArrayList<ReleaseId>();
        }
        this.jarDependencies.add(releaseId);
    }

    @Override
    public KieBuilder buildAll() {
        this.init();
        if (!this.isBuilt() && this.kModuleModel != null) {
            this.trgMfs = new MemoryFileSystem();
            this.writePomAndKModule();
            this.addKBasesFilesToTrg();
            this.markSource();
            this.kModule = new MemoryKieModule(this.releaseId, this.kModuleModel, this.trgMfs);
            if (this.kieDependencies != null && !this.kieDependencies.isEmpty()) {
                for (KieModule kieModule : this.kieDependencies) {
                    this.kModule.addKieDependency((InternalKieModule)kieModule);
                }
            }
            if (this.pomModel != null) {
                this.kModule.setPomModel(this.pomModel);
            }
            KieModuleKieProject kProject = new KieModuleKieProject(this.kModule);
            for (ReleaseId unresolvedDep : this.kModule.getUnresolvedDependencies()) {
                this.results.addMessage(Message.Level.ERROR, "pom.xml", "Unresolved dependency " + unresolvedDep);
            }
            this.compileJavaClasses(kProject.getClassLoader());
            KieBuilderImpl.buildKieProject(this.kModule, this.results, kProject, this.trgMfs);
        }
        return this;
    }

    void markSource() {
        this.srcMfs.mark();
    }

    Collection<String> getModifiedResourcesSinceLastMark() {
        return this.srcMfs.getModifiedResourcesSinceLastMark();
    }

    void updateKieModuleMetaInfo() {
        new KieMetaInfoBuilder(this.trgMfs, this.kModule).writeKieModuleMetaInfo();
    }

    public static String getCompilationCachePath(ReleaseId releaseId, String kbaseName) {
        return ((ReleaseIdImpl)releaseId).getCompilationCachePathPrefix() + kbaseName.replace('.', '/') + "/kbase.cache";
    }

    public static void buildKieModule(InternalKieModule kModule, ResultsImpl messages) {
        KieBuilderImpl.buildKieProject(kModule, messages, new KieModuleKieProject(kModule), null);
    }

    private static void buildKieProject(InternalKieModule kModule, ResultsImpl messages, KieModuleKieProject kProject, MemoryFileSystem trgMfs) {
        kProject.init();
        kProject.verify(messages);
        if (messages.filterMessages(Message.Level.ERROR).isEmpty()) {
            if (trgMfs != null) {
                new KieMetaInfoBuilder(trgMfs, kModule).writeKieModuleMetaInfo();
            }
            KieRepository kieRepository = KieServices.Factory.get().getRepository();
            kieRepository.addKieModule(kModule);
            for (InternalKieModule kDep : kModule.getKieDependencies().values()) {
                kieRepository.addKieModule(kDep);
            }
        }
    }

    private void addKBasesFilesToTrg() {
        for (KieBaseModel kieBaseModel : this.kModuleModel.getKieBaseModels().values()) {
            this.addKBaseFilesToTrg(kieBaseModel);
        }
    }

    private KieBaseConfiguration getKnowledgeBaseConfiguration(KieBaseModel kieBase, Properties properties, ClassLoader ... classLoaders) {
        KieBaseConfiguration kbConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(properties, classLoaders);
        kbConf.setOption(kieBase.getEqualsBehavior());
        kbConf.setOption(kieBase.getEventProcessingMode());
        kbConf.setOption(kieBase.getDeclarativeAgenda());
        return kbConf;
    }

    private void addKBaseFilesToTrg(KieBaseModel kieBase) {
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!(fileName = fileName.replace(File.separatorChar, '/')).startsWith(RESOURCES_ROOT) || !KieBuilderImpl.isFileInKieBase(kieBase, fileName)) continue;
            this.copySourceToTarget(fileName);
        }
    }

    String copySourceToTarget(String fileName) {
        if (!fileName.startsWith(RESOURCES_ROOT)) {
            return null;
        }
        byte[] bytes = this.srcMfs.getBytes(fileName);
        String trgFileName = fileName.substring(RESOURCES_ROOT.length());
        if (bytes != null) {
            FormatConverter formatConverter = FormatsManager.get().getConverterFor(trgFileName);
            if (formatConverter != null) {
                FormatConversionResult result = formatConverter.convert(trgFileName, bytes);
                trgFileName = result.getConvertedName();
                this.trgMfs.write(trgFileName, result.getContent(), true);
            } else if (this.getResourceType(fileName) != null) {
                this.trgMfs.write(trgFileName, bytes, true);
            }
        } else {
            this.trgMfs.remove(trgFileName);
        }
        return trgFileName;
    }

    private ResourceType getResourceType(String fileName) {
        if (this.srcMfs.isAvailable(fileName + ".properties")) {
            Properties prop = new Properties();
            try {
                prop.load(new ByteArrayInputStream(this.srcMfs.getBytes(fileName + ".properties")));
                return KieBuilderImpl.getResourceType(ResourceTypeImpl.fromProperties(prop));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    void cloneKieModuleForIncrementalCompilation() {
        this.trgMfs = this.trgMfs.clone();
        this.init();
        this.kModule = this.kModule.cloneForIncrementalCompilation(this.releaseId, this.kModuleModel, this.trgMfs);
    }

    private void addMetaInfBuilder() {
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.startsWith(RESOURCES_ROOT) || FormatsManager.isKieExtension(fileName)) continue;
            byte[] bytes = this.srcMfs.getBytes(fileName);
            this.trgMfs.write(fileName.substring(RESOURCES_ROOT.length() - 1), bytes, true);
        }
    }

    private static ResourceType getResourceType(InternalKieModule kieModule, String fileName) {
        return KieBuilderImpl.getResourceType(kieModule.getResourceConfiguration(fileName));
    }

    private static ResourceType getResourceType(ResourceConfiguration conf) {
        return conf instanceof ResourceConfigurationImpl ? ((ResourceConfigurationImpl)conf).getResourceType() : null;
    }

    public static boolean filterFileInKBase(InternalKieModule kieModule, KieBaseModel kieBase, String fileName) {
        return KieBuilderImpl.isFileInKieBase(kieBase, fileName) && (FormatsManager.isKieExtension(fileName) || KieBuilderImpl.getResourceType(kieModule, fileName) != null);
    }

    private static boolean isFileInKieBase(KieBaseModel kieBase, String fileName) {
        int lastSep = Math.max(0, fileName.lastIndexOf("/"));
        if (lastSep + 1 < fileName.length() && fileName.charAt(lastSep + 1) == '.') {
            return false;
        }
        if (kieBase.getPackages().isEmpty()) {
            return true;
        }
        String pkgNameForFile = lastSep > 0 ? fileName.substring(0, lastSep) : fileName;
        pkgNameForFile = pkgNameForFile.replace('/', '.');
        for (String pkgName : kieBase.getPackages()) {
            String pkgNameNoWildcard;
            boolean isNegative = pkgName.startsWith("!");
            if (isNegative) {
                pkgName = pkgName.substring(1);
            }
            if (pkgName.equals("*") || pkgNameForFile.endsWith(pkgName)) {
                return !isNegative;
            }
            if (!pkgName.endsWith(".*")) continue;
            String relativePkgNameForFile = pkgNameForFile.startsWith(RESOURCES_ROOT_DOT_SEPARATOR) ? pkgNameForFile.substring(RESOURCES_ROOT_DOT_SEPARATOR.length()) : pkgNameForFile;
            if (relativePkgNameForFile.equals(pkgNameNoWildcard = pkgName.substring(0, pkgName.length() - 2)) || relativePkgNameForFile.startsWith(pkgNameNoWildcard + ".")) {
                return !isNegative;
            }
            if (!relativePkgNameForFile.startsWith(kieBase.getName() + ".") || !(relativePkgNameForFile = relativePkgNameForFile.substring(kieBase.getName().length() + 1)).equals(pkgNameNoWildcard) && !relativePkgNameForFile.startsWith(pkgNameNoWildcard + ".")) continue;
            return !isNegative;
        }
        return false;
    }

    @Override
    public Results getResults() {
        if (!this.isBuilt()) {
            this.buildAll();
        }
        return this.results;
    }

    @Override
    public KieModule getKieModule() {
        return this.getKieModule(false);
    }

    @Override
    public KieModule getKieModuleIgnoringErrors() {
        return this.getKieModule(true);
    }

    private KieModule getKieModule(boolean ignoreErrors) {
        if (!this.isBuilt()) {
            this.buildAll();
        }
        if (!ignoreErrors && (this.getResults().hasMessages(Message.Level.ERROR) || this.kModule == null)) {
            throw new RuntimeException("Unable to get KieModule, Errors Existed");
        }
        return this.kModule;
    }

    private boolean isBuilt() {
        return this.kModule != null;
    }

    private void buildKieModuleModel() {
        if (this.srcMfs.isAvailable("src/main/resources/META-INF/kmodule.xml")) {
            this.kModuleModelXml = this.srcMfs.getBytes("src/main/resources/META-INF/kmodule.xml");
            try {
                this.kModuleModel = KieModuleModelImpl.fromXML(new ByteArrayInputStream(this.kModuleModelXml));
            }
            catch (Exception e) {
                this.results.addMessage(Message.Level.ERROR, "kmodule.xml", "kmodule.xml found, but unable to read\n" + e.getMessage());
            }
        } else {
            this.kModuleModel = KieServices.Factory.get().newKieModuleModel();
        }
        if (KieBuilderImpl.setDefaultsforEmptyKieModule(this.kModuleModel)) {
            this.kModuleModelXml = this.kModuleModel.toXML().getBytes(IoUtils.UTF8_CHARSET);
        }
    }

    public static boolean setDefaultsforEmptyKieModule(KieModuleModel kModuleModel) {
        if (kModuleModel != null && kModuleModel.getKieBaseModels().isEmpty()) {
            KieBaseModel kieBaseModel = kModuleModel.newKieBaseModel("defaultKieBase").addPackage("*").setDefault(true);
            kieBaseModel.newKieSessionModel("defaultKieSession").setDefault(true);
            kieBaseModel.newKieSessionModel("defaultStatelessKieSession").setType(KieSessionModel.KieSessionType.STATELESS).setDefault(true);
            return true;
        }
        return false;
    }

    private void buildPomModel() {
        this.pomXml = KieBuilderImpl.getOrGeneratePomXml(this.srcMfs);
        if (this.pomXml == null) {
            return;
        }
        try {
            PomModel tempPomModel = PomModel.Parser.parse("pom.xml", new ByteArrayInputStream(this.pomXml));
            KieBuilderImpl.validatePomModel(tempPomModel);
            this.pomModel = tempPomModel;
        }
        catch (Exception e) {
            this.results.addMessage(Message.Level.ERROR, "pom.xml", "maven pom.xml found, but unable to read\n" + e.getMessage());
        }
    }

    public static void validatePomModel(PomModel pomModel) {
        ReleaseId pomReleaseId = pomModel.getReleaseId();
        if (StringUtils.isEmpty(pomReleaseId.getGroupId()) || StringUtils.isEmpty(pomReleaseId.getArtifactId()) || StringUtils.isEmpty(pomReleaseId.getVersion())) {
            throw new RuntimeException("Maven pom.properties exists but ReleaseId content is malformed");
        }
    }

    public static byte[] getOrGeneratePomXml(ResourceReader mfs) {
        if (mfs.isAvailable("pom.xml")) {
            return mfs.getBytes("pom.xml");
        }
        return KieBuilderImpl.generatePomXml(KieServices.Factory.get().getRepository().getDefaultReleaseId()).getBytes(IoUtils.UTF8_CHARSET);
    }

    public void writePomAndKModule() {
        this.addMetaInfBuilder();
        if (this.pomXml != null) {
            ReleaseIdImpl g = (ReleaseIdImpl)this.releaseId;
            this.trgMfs.write(g.getPomXmlPath(), this.pomXml, true);
            this.trgMfs.write(g.getPomPropertiesPath(), KieBuilderImpl.generatePomProperties(this.releaseId).getBytes(IoUtils.UTF8_CHARSET), true);
        }
        if (this.kModuleModelXml != null) {
            this.trgMfs.write("META-INF/kmodule.xml", this.kModuleModel.toXML().getBytes(IoUtils.UTF8_CHARSET), true);
        }
    }

    public static String generatePomXml(ReleaseId releaseId) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n");
        sBuilder.append("         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"> \n");
        sBuilder.append("    <modelVersion>4.0.0</modelVersion> \n");
        sBuilder.append("    <groupId>");
        sBuilder.append(releaseId.getGroupId());
        sBuilder.append("</groupId> \n");
        sBuilder.append("    <artifactId>");
        sBuilder.append(releaseId.getArtifactId());
        sBuilder.append("</artifactId> \n");
        sBuilder.append("    <version>");
        sBuilder.append(releaseId.getVersion());
        sBuilder.append("</version> \n");
        sBuilder.append("    <packaging>jar</packaging> \n");
        sBuilder.append("    <name>Default</name> \n");
        sBuilder.append("</project>  \n");
        return sBuilder.toString();
    }

    public static String generatePomProperties(ReleaseId releaseId) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("groupId=");
        sBuilder.append(releaseId.getGroupId());
        sBuilder.append("\n");
        sBuilder.append("artifactId=");
        sBuilder.append(releaseId.getArtifactId());
        sBuilder.append("\n");
        sBuilder.append("version=");
        sBuilder.append(releaseId.getVersion());
        sBuilder.append("\n");
        return sBuilder.toString();
    }

    private void compileJavaClasses(ClassLoader classLoader) {
        ArrayList<String> classFiles = new ArrayList<String>();
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.endsWith(".class")) continue;
            this.trgMfs.write(fileName, this.srcMfs.getBytes(fileName), true);
            classFiles.add(fileName.substring(0, fileName.length() - ".class".length()));
        }
        ArrayList<String> javaFiles = new ArrayList<String>();
        ArrayList<String> javaTestFiles = new ArrayList<String>();
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.endsWith(".java") || classFiles.contains(fileName.substring(0, fileName.length() - ".java".length()))) continue;
            if (!(fileName = fileName.replace(File.separatorChar, '/')).startsWith(JAVA_ROOT) && !fileName.startsWith(JAVA_TEST_ROOT)) {
                this.results.addMessage(Message.Level.WARNING, fileName, "Found Java file out of the Java source folder: \"" + fileName + "\"");
                continue;
            }
            if (fileName.substring(JAVA_ROOT.length()).indexOf(47) < 0) {
                this.results.addMessage(Message.Level.ERROR, fileName, "A Java class must have a package: " + fileName.substring(JAVA_ROOT.length()) + " is not allowed");
                continue;
            }
            if (fileName.startsWith(JAVA_ROOT)) {
                javaFiles.add(fileName);
                continue;
            }
            javaTestFiles.add(fileName);
        }
        if (!javaFiles.isEmpty() || !javaTestFiles.isEmpty()) {
            KnowledgeBuilderConfigurationImpl kconf = new KnowledgeBuilderConfigurationImpl(classLoader);
            JavaDialectConfiguration javaConf = (JavaDialectConfiguration)kconf.getDialectConfiguration("java");
            this.compileJavaClasses(javaConf, classLoader, javaFiles, JAVA_ROOT);
            this.compileJavaClasses(javaConf, classLoader, javaTestFiles, JAVA_TEST_ROOT);
        }
    }

    private void compileJavaClasses(JavaDialectConfiguration javaConf, ClassLoader classLoader, List<String> javaFiles, String rootFolder) {
        if (!javaFiles.isEmpty()) {
            String[] sourceFiles = javaFiles.toArray(new String[javaFiles.size()]);
            JavaCompiler javaCompiler = this.createCompiler(javaConf, rootFolder);
            CompilationResult res = javaCompiler.compile(sourceFiles, this.srcMfs, this.trgMfs, classLoader);
            for (CompilationProblem problem : res.getErrors()) {
                this.results.addMessage(problem);
            }
            for (CompilationProblem problem : res.getWarnings()) {
                this.results.addMessage(problem);
            }
        }
    }

    private JavaCompiler createCompiler(JavaDialectConfiguration javaConf, String prefix) {
        JavaCompiler javaCompiler = JavaCompilerFactory.getInstance().loadCompiler(javaConf);
        if (javaCompiler instanceof EclipseJavaCompiler) {
            ((EclipseJavaCompiler)javaCompiler).setPrefix(prefix);
        }
        return javaCompiler;
    }

    public static String findPomProperties(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String fileName = zipEntry.getName();
            if (!fileName.endsWith("pom.properties") || !fileName.startsWith("META-INF/maven/")) continue;
            return fileName;
        }
        return null;
    }

    public static File findPomProperties(File root) {
        File mavenRoot = new File(root, "META-INF/maven");
        return KieBuilderImpl.recurseToPomProperties(mavenRoot);
    }

    public static File recurseToPomProperties(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                if (child.isDirectory()) {
                    File returnedFile = KieBuilderImpl.recurseToPomProperties(child);
                    if (returnedFile == null) continue;
                    return returnedFile;
                }
                if (!child.getName().endsWith("pom.properties")) continue;
                return child;
            }
        }
        return null;
    }

    @Override
    public KieBuilderSet createFileSet(String ... files) {
        if (this.kieBuilderSet == null) {
            this.kieBuilderSet = new KieBuilderSetImpl(this);
        }
        return this.kieBuilderSet.setFiles(files);
    }

    @Override
    public IncrementalResults incrementalBuild() {
        return new KieBuilderSetImpl(this).build();
    }
}

