/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Properties;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.ClasspathKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.drools.compiler.kie.builder.impl.InternalKieServices;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieFileSystemImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kie.builder.impl.event.KieServicesEventListerner;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.audit.KnowledgeRuntimeLoggerProviderImpl;
import org.drools.core.command.impl.CommandFactoryServiceImpl;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.concurrent.ExecutorProviderImpl;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.io.impl.ResourceFactoryServiceImpl;
import org.drools.core.marshalling.impl.MarshallerProviderImpl;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.KieScannerFactoryService;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.command.KieCommands;
import org.kie.api.concurrent.KieExecutors;
import org.kie.api.io.KieResources;
import org.kie.api.logger.KieLoggers;
import org.kie.api.marshalling.KieMarshallers;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.utils.ServiceRegistryImpl;

public class KieServicesImpl
implements InternalKieServices {
    private volatile KieContainer classpathKContainer;
    private volatile ClassLoader classpathClassLoader;
    private final Object lock = new Object();
    private WeakReference<KieServicesEventListerner> listener;

    @Override
    public KieRepository getRepository() {
        return KieRepositoryImpl.INSTANCE;
    }

    @Override
    public KieContainer getKieClasspathContainer() {
        return this.getKieClasspathContainer(ProjectClassLoader.findParentClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KieContainer getKieClasspathContainer(ClassLoader classLoader) {
        if (this.classpathKContainer == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.classpathKContainer == null) {
                    this.classpathClassLoader = classLoader;
                    this.classpathKContainer = this.newKieClasspathContainer(classLoader);
                } else if (classLoader != this.classpathClassLoader) {
                    throw new IllegalStateException("There's already another KieContainer created from a different ClassLoader");
                }
            }
        } else if (classLoader != this.classpathClassLoader) {
            throw new IllegalStateException("There's already another KieContainer created from a different ClassLoader");
        }
        return this.classpathKContainer;
    }

    @Override
    public KieContainer newKieClasspathContainer() {
        return this.newKieClasspathContainer(ProjectClassLoader.findParentClassLoader());
    }

    @Override
    public KieContainer newKieClasspathContainer(ClassLoader classLoader) {
        return new KieContainerImpl(new ClasspathKieProject(classLoader, this.listener), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nullKieClasspathContainer() {
        Object object = this.lock;
        synchronized (object) {
            this.classpathKContainer = null;
            this.classpathClassLoader = null;
        }
    }

    @Override
    public KieContainer newKieContainer(ReleaseId releaseId) {
        InternalKieModule kieModule = (InternalKieModule)this.getRepository().getKieModule(releaseId);
        if (kieModule == null) {
            throw new RuntimeException("Cannot find KieModule: " + releaseId);
        }
        KieModuleKieProject kProject = new KieModuleKieProject(kieModule);
        return new KieContainerImpl(kProject, this.getRepository(), releaseId);
    }

    @Override
    public KieBuilder newKieBuilder(File file) {
        return file.isDirectory() ? new KieBuilderImpl(file) : this.newKieBuilder(new KieFileSystemImpl(MemoryFileSystem.readFromJar(file)));
    }

    @Override
    public KieBuilder newKieBuilder(KieFileSystem kieFileSystem) {
        return new KieBuilderImpl(kieFileSystem);
    }

    @Override
    public KieScanner newKieScanner(KieContainer kieContainer) {
        KieScannerFactoryService scannerFactoryService = ServiceRegistryImpl.getInstance().get(KieScannerFactoryService.class);
        InternalKieScanner scanner = (InternalKieScanner)scannerFactoryService.newKieScanner();
        scanner.setKieContainer(kieContainer);
        return scanner;
    }

    @Override
    public KieResources getResources() {
        return new ResourceFactoryServiceImpl();
    }

    @Override
    public KieCommands getCommands() {
        return new CommandFactoryServiceImpl();
    }

    @Override
    public KieMarshallers getMarshallers() {
        return new MarshallerProviderImpl();
    }

    @Override
    public KieLoggers getLoggers() {
        return new KnowledgeRuntimeLoggerProviderImpl();
    }

    public KieExecutors getExecutors() {
        return new ExecutorProviderImpl();
    }

    @Override
    public KieStoreServices getStoreServices() {
        return ServiceRegistryImpl.getInstance().get(KieStoreServices.class);
    }

    @Override
    public ReleaseId newReleaseId(String groupId, String artifactId, String version) {
        return new ReleaseIdImpl(groupId, artifactId, version);
    }

    @Override
    public KieModuleModel newKieModuleModel() {
        return new KieModuleModelImpl();
    }

    @Override
    public KieFileSystem newKieFileSystem() {
        return new KieFileSystemImpl();
    }

    @Override
    public KieBaseConfiguration newKieBaseConfiguration() {
        return new RuleBaseConfiguration();
    }

    @Override
    public KieBaseConfiguration newKieBaseConfiguration(Properties properties) {
        return new RuleBaseConfiguration(properties, null);
    }

    @Override
    public KieBaseConfiguration newKieBaseConfiguration(Properties properties, ClassLoader classLoader) {
        return new RuleBaseConfiguration(properties, classLoader);
    }

    @Override
    public KieSessionConfiguration newKieSessionConfiguration() {
        return new SessionConfiguration();
    }

    @Override
    public KieSessionConfiguration newKieSessionConfiguration(Properties properties) {
        return new SessionConfiguration(properties);
    }

    @Override
    public KieSessionConfiguration newKieSessionConfiguration(Properties properties, ClassLoader classLoader) {
        return new SessionConfiguration(properties, classLoader);
    }

    @Override
    public Environment newEnvironment() {
        return EnvironmentFactory.newEnvironment();
    }

    @Override
    public void registerListener(KieServicesEventListerner listener) {
        this.listener = new WeakReference<KieServicesEventListerner>(listener);
    }
}

