/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.util.ArrayList;
import java.util.List;
import org.drools.compiler.commons.jci.problems.CompilationProblem;
import org.kie.api.builder.Message;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageImpl
implements Message {
    protected static final transient Logger logger = LoggerFactory.getLogger(MessageImpl.class);
    private final long id;
    private final Message.Level level;
    private final String path;
    private final int line;
    private final int column;
    private final String text;

    public MessageImpl(long id, Message.Level level, String path, String text) {
        this.id = id;
        this.level = level;
        this.path = path;
        this.text = text;
        this.line = 0;
        this.column = 0;
    }

    public MessageImpl(long id, CompilationProblem problem) {
        this.id = id;
        this.level = problem.isError() ? Message.Level.ERROR : Message.Level.WARNING;
        this.path = problem.getFileName();
        this.line = problem.getStartLine();
        this.column = problem.getStartColumn();
        this.text = problem.getMessage();
    }

    public MessageImpl(long id, KnowledgeBuilderResult result) {
        this.id = id;
        switch (result.getSeverity()) {
            case ERROR: {
                this.level = Message.Level.ERROR;
                break;
            }
            case WARNING: {
                this.level = Message.Level.WARNING;
                break;
            }
            default: {
                this.level = Message.Level.INFO;
            }
        }
        Resource resource = result.getResource();
        if (resource == null) {
            logger.debug("resource is null: " + result.toString());
            this.path = null;
        } else {
            this.path = resource.getSourcePath();
        }
        this.line = result.getLines().length > 0 ? result.getLines()[0] : -1;
        this.column = 0;
        this.text = result.getMessage();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Message.Level getLevel() {
        return this.level;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public static List<Message> filterMessages(List<Message> messages, Message.Level ... levels) {
        ArrayList<Message> filteredMsgs = new ArrayList<Message>();
        if (levels != null && levels.length > 0) {
            for (Message.Level level : levels) {
                for (Message msg : messages) {
                    if (msg.getLevel() != level) continue;
                    filteredMsgs.add(msg);
                }
            }
        }
        return filteredMsgs;
    }

    public String toString() {
        return "Message [id=" + this.id + ", level=" + (Object)((Object)this.level) + ", path=" + this.path + ", line=" + this.line + ", column=" + this.column + "\n   text=" + this.text + "]";
    }
}

