/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kproject;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import java.util.Properties;
import org.drools.core.util.StringUtils;
import org.kie.api.builder.ReleaseId;

public class ReleaseIdImpl
implements ReleaseId,
Externalizable {
    private String groupId;
    private String artifactId;
    private String version;
    private String snapshotVersion;

    public ReleaseIdImpl() {
    }

    public ReleaseIdImpl(String releaseId) {
        String[] split = releaseId.split(":");
        this.groupId = split[0];
        this.artifactId = split[1];
        this.version = split[2];
    }

    public ReleaseIdImpl(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    @Override
    public String toExternalForm() {
        return this.toString();
    }

    public String getPomXmlPath() {
        return "META-INF/maven/" + this.groupId + "/" + this.artifactId + "/pom.xml";
    }

    public String getPomPropertiesPath() {
        return "META-INF/maven/" + this.groupId + "/" + this.artifactId + "/pom.properties";
    }

    public String getCompilationCachePathPrefix() {
        return "META-INF/";
    }

    @Override
    public boolean isSnapshot() {
        return this.version.endsWith("-SNAPSHOT");
    }

    public static ReleaseId fromPropertiesString(String string) {
        Properties props = new Properties();
        ReleaseIdImpl releaseId = null;
        try {
            props.load(new StringReader(string));
            String groupId = props.getProperty("groupId");
            String artifactId = props.getProperty("artifactId");
            String version = props.getProperty("version");
            if (StringUtils.isEmpty(groupId) || StringUtils.isEmpty(artifactId) || StringUtils.isEmpty(version)) {
                throw new RuntimeException("pom.properties exists but ReleaseId content is malformed\n" + string);
            }
            releaseId = new ReleaseIdImpl(groupId, artifactId, version);
        }
        catch (IOException e) {
            throw new RuntimeException("pom.properties was malformed\n" + string, e);
        }
        return releaseId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReleaseIdImpl that = (ReleaseIdImpl)o;
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String getSnapshotVersion() {
        return this.snapshotVersion;
    }

    public void setSnapshotVersion(String snapshotVersion) {
        this.snapshotVersion = snapshotVersion;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.groupId);
        out.writeObject(this.artifactId);
        out.writeObject(this.version);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.groupId = (String)in.readObject();
        this.artifactId = (String)in.readObject();
        this.version = (String)in.readObject();
    }
}

