/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.dsl;

import java.util.Map;
import java.util.regex.Pattern;
import org.drools.compiler.lang.dsl.AbstractDSLMappingEntry;
import org.drools.compiler.lang.dsl.DSLMappingEntry;
import org.mvel2.util.ParseTools;

public class AntlrDSLMappingEntry
extends AbstractDSLMappingEntry {
    public AntlrDSLMappingEntry() {
        this(ANY, EMPTY_METADATA, null, null, null, null);
    }

    public AntlrDSLMappingEntry(DSLMappingEntry.Section section, DSLMappingEntry.MetaData metadata, String key, String value, String keyPattern, String valuePattern) {
        this.setSection(section);
        this.setMetaData(metadata);
        this.setMappingKey(key);
        this.setMappingValue(value);
        this.setKeyPattern(keyPattern);
        this.setValuePattern(valuePattern);
    }

    public void setKeyPattern(String keyPat) {
        if (keyPat != null) {
            String trimmed = keyPat.trim();
            String keyPattern = trimmed.replaceAll("\\$", "\\\\\\$");
            if (!(keyPattern = keyPattern.replaceAll("\\\\#", "#")).startsWith("^")) {
                keyPattern = "(?:(?<=^)|(?<=\\W))" + keyPattern;
            }
            keyPattern = keyPattern.endsWith("(.*?)") ? keyPattern + "$" : keyPattern + "(?=\\W|$)";
            this.fixVariableOffsets();
            if (trimmed.startsWith("-") && !trimmed.startsWith("-\\s*")) {
                int index = keyPattern.indexOf(45) + 1;
                keyPattern = keyPattern.substring(0, index) + "\\s*" + keyPattern.substring(index).trim();
            }
            keyPattern = keyPattern.replaceAll("\\s+", "\\\\s+");
            keyPattern = keyPattern.replaceAll("(\\\\s\\+)+", "\\\\s+");
            this.setKeyPattern(Pattern.compile(keyPattern, 40));
        } else {
            this.setKeyPattern((Pattern)null);
        }
    }

    private void fixVariableOffsets() {
        char[] input = this.getMappingKey().toCharArray();
        int counter = 1;
        boolean insideCurly = false;
        block6: for (int i = 0; i < input.length; ++i) {
            switch (input[i]) {
                case '\\': {
                    ++i;
                    continue block6;
                }
                case '(': {
                    if (insideCurly || i != input.length - 1 && input[i + 1] == '?') continue block6;
                    ++counter;
                    continue block6;
                }
                case '{': {
                    if (insideCurly) {
                        i = ParseTools.balancedCapture(input, i, '{');
                        continue block6;
                    }
                    insideCurly = true;
                    this.updateVariableIndex(i, counter);
                    ++counter;
                    continue block6;
                }
                case '}': {
                    if (!insideCurly) continue block6;
                    insideCurly = false;
                }
            }
        }
    }

    private void updateVariableIndex(int offset, int counter) {
        String subs = this.getMappingKey().substring(offset);
        for (Map.Entry<String, Integer> entry : this.getVariables().entrySet()) {
            if (!subs.startsWith("{" + entry.getKey()) || subs.charAt(entry.getKey().length() + 1) != '}' && subs.charAt(entry.getKey().length() + 1) != ':') continue;
            entry.setValue(counter);
            break;
        }
    }

    @Override
    public void setValuePattern(String value) {
        if (value != null) {
            StringBuilder valuePatternBuffer = new StringBuilder();
            valuePatternBuffer.append(value);
            if (value.endsWith(" ")) {
                valuePatternBuffer.deleteCharAt(valuePatternBuffer.length() - 1);
            }
            String pat = valuePatternBuffer.toString().replaceAll("\\\\(#|\\{|\\})", "$1").replaceAll("\\\\n", "\n").replaceAll("\\\\\\$", "\\$");
            super.setValuePattern(pat);
        }
    }
}

