/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.reteoo.compiled;

import java.util.Collection;
import java.util.Iterator;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.rule.builder.dialect.java.JavaDialect;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.ValueType;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.compiled.AssertHandler;
import org.drools.core.reteoo.compiled.CompiledNetwork;
import org.drools.core.reteoo.compiled.DeclarationsHandler;
import org.drools.core.reteoo.compiled.HashedAlphasDeclaration;
import org.drools.core.reteoo.compiled.ObjectTypeNodeParser;
import org.drools.core.reteoo.compiled.SetNodeReferenceHandler;
import org.drools.core.util.IoUtils;

public class ObjectTypeNodeCompiler {
    private static final String NEWLINE = "\n";
    private static final String PACKAGE_NAME = "org.drools.core.reteoo.compiled";
    private static final String BINARY_PACKAGE_NAME = "org.drools.core.reteoo.compiled".replace('.', '/');
    private String className;
    private String generatedClassSimpleName;
    private ObjectTypeNode objectTypeNode;
    private StringBuilder builder = new StringBuilder();

    private ObjectTypeNodeCompiler(ObjectTypeNode objectTypeNode) {
        this.objectTypeNode = objectTypeNode;
        ClassObjectType classObjectType = (ClassObjectType)objectTypeNode.getObjectType();
        this.className = classObjectType.getClassName();
        this.generatedClassSimpleName = "Compiled" + classObjectType.getClassName().replace('.', '_') + "Network";
    }

    private String generateSource() {
        this.createClassDeclaration();
        ObjectTypeNodeParser parser = new ObjectTypeNodeParser(this.objectTypeNode);
        DeclarationsHandler declarations = new DeclarationsHandler(this.builder);
        parser.accept(declarations);
        Collection<HashedAlphasDeclaration> hashedAlphaDeclarations = declarations.getHashedAlphaDeclarations();
        this.createConstructor(hashedAlphaDeclarations);
        SetNodeReferenceHandler setNode = new SetNodeReferenceHandler(this.builder);
        parser.accept(setNode);
        AssertHandler assertHandler = new AssertHandler(this.builder, this.className, hashedAlphaDeclarations.size() > 0);
        parser.accept(assertHandler);
        this.builder.append("}").append(NEWLINE);
        return this.builder.toString();
    }

    private void createClassDeclaration() {
        this.builder.append("package ").append(PACKAGE_NAME).append(";").append(NEWLINE);
        this.builder.append("public class ").append(this.generatedClassSimpleName).append(" extends ").append(CompiledNetwork.class.getName()).append("{ ").append(NEWLINE);
    }

    private void createConstructor(Collection<HashedAlphasDeclaration> hashedAlphaDeclarations) {
        this.builder.append("public ").append(this.generatedClassSimpleName).append("() {").append(NEWLINE);
        for (HashedAlphasDeclaration declaration : hashedAlphaDeclarations) {
            String mapVariableName = declaration.getVariableName();
            Iterator<Object> i$ = declaration.getHashedValues().iterator();
            while (i$.hasNext()) {
                Object hashedValue;
                Object value = hashedValue = i$.next();
                if (declaration.getValueType() == ValueType.STRING_TYPE) {
                    value = "\"" + value + "\"";
                }
                String nodeId = declaration.getNodeId(hashedValue);
                this.builder.append(mapVariableName).append(".put(").append(value).append(", ").append(nodeId).append(");");
                this.builder.append(NEWLINE);
            }
        }
        this.builder.append("}").append(NEWLINE);
    }

    private String getName() {
        return this.getPackageName() + "." + this.generatedClassSimpleName;
    }

    private String getBinaryName() {
        return BINARY_PACKAGE_NAME + "." + this.generatedClassSimpleName + ".class";
    }

    private String getPackageName() {
        return PACKAGE_NAME;
    }

    public static CompiledNetwork compile(KnowledgeBuilderImpl kBuilder, ObjectTypeNode objectTypeNode) {
        CompiledNetwork network;
        if (objectTypeNode == null) {
            throw new IllegalArgumentException("ObjectTypeNode cannot be null!");
        }
        if (kBuilder == null) {
            throw new IllegalArgumentException("PackageBuilder cannot be null!");
        }
        ObjectTypeNodeCompiler compiler = new ObjectTypeNodeCompiler(objectTypeNode);
        String packageName = compiler.getPackageName();
        PackageRegistry pkgReg = kBuilder.getPackageRegistry(packageName);
        if (pkgReg == null) {
            kBuilder.addPackage(new PackageDescr(packageName));
            pkgReg = kBuilder.getPackageRegistry(packageName);
        }
        String source = compiler.generateSource();
        String generatedSourceName = compiler.getName();
        JavaDialect dialect = (JavaDialect)pkgReg.getDialectCompiletimeRegistry().getDialect("java");
        dialect.addSrc(compiler.getBinaryName(), source.getBytes(IoUtils.UTF8_CHARSET));
        kBuilder.compileAll();
        kBuilder.updateResults();
        try {
            network = (CompiledNetwork)Class.forName(generatedSourceName, true, kBuilder.getRootClassLoader()).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("This is a bug. Please contact the development team", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("This is a bug. Please contact the development team", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("This is a bug. Please contact the development team", e);
        }
        return network;
    }
}

