/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.testframework;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.kie.api.definition.rule.Rule;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.Match;

public class TestingEventListener
implements AgendaEventListener {
    final Map<String, Integer> firingCounts = new HashMap<String, Integer>(100);
    long totalFires;

    public AgendaFilter getAgendaFilter(final HashSet<String> ruleNames, final boolean inclusive) {
        return new AgendaFilter(){

            @Override
            public boolean accept(Match match) {
                if (ruleNames.size() == 0) {
                    return true;
                }
                String ruleName = match.getRule().getName();
                if (inclusive) {
                    return ruleNames.contains(ruleName);
                }
                return !ruleNames.contains(ruleName);
            }
        };
    }

    @Override
    public void matchCancelled(MatchCancelledEvent event) {
    }

    @Override
    public void matchCreated(MatchCreatedEvent event) {
    }

    @Override
    public void afterMatchFired(AfterMatchFiredEvent event) {
        this.recordFiring(event.getMatch().getRule());
    }

    private void recordFiring(Rule rule) {
        this.record(rule, this.firingCounts);
    }

    @Override
    public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
    }

    @Override
    public void agendaGroupPushed(AgendaGroupPushedEvent event) {
    }

    @Override
    public void beforeMatchFired(BeforeMatchFiredEvent event) {
    }

    private void record(Rule rule, Map<String, Integer> counts) {
        ++this.totalFires;
        String name = rule.getName();
        if (!counts.containsKey(name)) {
            counts.put(name, 1);
        } else {
            counts.put(name, counts.get(name) + 1);
        }
    }

    public Map<String, Integer> getFiringCounts() {
        return this.firingCounts;
    }

    public String[] getRulesFiredSummary() {
        String[] r = new String[this.firingCounts.size()];
        int i = 0;
        for (Map.Entry<String, Integer> e : this.firingCounts.entrySet()) {
            r[i] = e.getKey() + " [" + e.getValue() + "]";
            ++i;
        }
        return r;
    }

    @Override
    public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    @Override
    public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }

    @Override
    public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    @Override
    public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }
}

