/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.ModedAssertion;
import org.drools.core.beliefsystem.simple.SimpleLogicalDependency;
import org.drools.core.beliefsystem.simple.SimpleMode;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemoryActions;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.TruthMaintenanceSystemHelper;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.drools.core.factmodel.traits.LogicalTypeInconsistencyException;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitFactory;
import org.drools.core.factmodel.traits.TraitFieldTMS;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.factmodel.traits.TraitRegistry;
import org.drools.core.factmodel.traits.TraitType;
import org.drools.core.factmodel.traits.TraitTypeMap;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.Activation;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Tuple;
import org.drools.core.util.HierarchyEncoder;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.internal.runtime.KnowledgeRuntime;
import org.kie.internal.runtime.beliefs.Mode;

public class DefaultKnowledgeHelper<T extends ModedAssertion<T>>
implements KnowledgeHelper,
Externalizable {
    private static final long serialVersionUID = 510L;
    private Activation activation;
    private Tuple tuple;
    private InternalWorkingMemoryActions workingMemory;
    private IdentityHashMap<Object, FactHandle> identityMap;
    private LinkedList<LogicalDependency<T>> previousJustified;
    private LinkedList<LogicalDependency<SimpleMode>> previousBlocked;

    public DefaultKnowledgeHelper() {
    }

    public DefaultKnowledgeHelper(WorkingMemory workingMemory) {
        this.workingMemory = (InternalWorkingMemoryActions)workingMemory;
        this.identityMap = null;
    }

    public DefaultKnowledgeHelper(Activation activation, WorkingMemory workingMemory) {
        this.workingMemory = (InternalWorkingMemoryActions)workingMemory;
        this.activation = activation;
        this.identityMap = null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.activation = (Activation)in.readObject();
        this.tuple = (Tuple)in.readObject();
        this.workingMemory = (InternalWorkingMemoryActions)in.readObject();
        this.identityMap = (IdentityHashMap)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.activation);
        out.writeObject(this.tuple);
        out.writeObject(this.workingMemory);
        out.writeObject(this.identityMap);
    }

    @Override
    public void setActivation(Activation agendaItem) {
        this.activation = agendaItem;
        this.previousJustified = agendaItem.getLogicalDependencies();
        this.previousBlocked = agendaItem.getBlocked();
        agendaItem.setLogicalDependencies(null);
        agendaItem.setBlocked(null);
        this.tuple = agendaItem.getTuple();
    }

    @Override
    public void reset() {
        this.activation = null;
        this.tuple = null;
        this.identityMap = null;
        this.previousJustified = null;
        this.previousBlocked = null;
    }

    public LinkedList<LogicalDependency<T>> getpreviousJustified() {
        return this.previousJustified;
    }

    @Override
    public void blockMatch(Match act) {
        AgendaItem targetMatch = (AgendaItem)act;
        LogicalDependency dep = null;
        if (this.previousBlocked != null) {
            for (dep = this.previousBlocked.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (targetMatch != dep.getJustified()) continue;
                this.previousBlocked.remove(dep);
                break;
            }
        }
        if (dep == null) {
            SimpleMode mode = new SimpleMode();
            dep = new SimpleLogicalDependency<SimpleMode>(this.activation, targetMatch, mode);
            mode.setObject(dep);
        }
        this.activation.addBlocked(dep);
        if (targetMatch.getBlockers().size() == 1 && targetMatch.isQueued()) {
            if (targetMatch.getRuleAgendaItem() == null) {
                targetMatch.remove();
            } else {
                targetMatch.getRuleAgendaItem().getRuleExecutor().removeLeftTuple(targetMatch.getTuple());
            }
            if (targetMatch.getActivationGroupNode() != null) {
                targetMatch.getActivationGroupNode().getActivationGroup().removeActivation(targetMatch);
            }
            if (targetMatch.getActivationNode() != null) {
                InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)targetMatch.getActivationNode().getParentContainer();
                ruleFlowGroup.remove(targetMatch);
            }
        }
    }

    @Override
    public void unblockAllMatches(Match act) {
        AgendaItem targetMatch = (AgendaItem)act;
        boolean wasBlocked = targetMatch.getBlockers() != null && !targetMatch.getBlockers().isEmpty();
        LinkedListEntry entry = targetMatch.getBlockers().getFirst();
        while (entry != null) {
            LinkedListEntry tmp = (LinkedListEntry)entry.getNext();
            LogicalDependency dep = (LogicalDependency)entry.getObject();
            ((AgendaItem)dep.getJustifier()).removeBlocked(dep);
            entry = tmp;
        }
        if (wasBlocked) {
            RuleAgendaItem ruleAgendaItem = targetMatch.getRuleAgendaItem();
            InternalAgenda agenda = (InternalAgenda)this.workingMemory.getAgenda();
            agenda.stageLeftTuple(ruleAgendaItem, targetMatch);
        }
    }

    @Override
    public FactHandle insert(Object object) {
        return this.insert(object, false);
    }

    @Override
    public FactHandle insert(Object object, boolean dynamic) {
        FactHandle handle = this.workingMemory.insert(object, null, dynamic, false, this.activation.getRule(), this.activation);
        if (this.identityMap != null) {
            this.getIdentityMap().put(object, handle);
        }
        return handle;
    }

    @Override
    public void insertLogical(Object object, Mode belief) {
        this.insertLogical(object, (Object)belief, false);
    }

    @Override
    public void insertLogical(Object object, Mode ... beliefs) {
        this.insertLogical(object, (Object)beliefs, false);
    }

    @Override
    public void insertLogical(Object object) {
        this.insertLogical(object, false);
    }

    @Override
    public void insertLogical(Object object, boolean dynamic) {
        this.insertLogical(object, null, dynamic);
    }

    @Override
    public void insertLogical(Object object, Object value) {
        this.insertLogical(object, value, false);
    }

    public void insertLogical(Object object, Object value, boolean dynamic) {
        if (!this.activation.isMatched()) {
            return;
        }
        LogicalDependency dep = null;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (!object.equals(((BeliefSet)dep.getJustified()).getFactHandle().getObject())) continue;
                this.previousJustified.remove(dep);
                break;
            }
        }
        if (dep != null) {
            this.activation.addLogicalDependency(dep);
        } else {
            FactHandle handle = this.workingMemory.insert(object, value, dynamic, true, this.activation.getRule(), this.activation);
            if (this.identityMap != null) {
                this.getIdentityMap().put(object, handle);
            }
        }
    }

    @Override
    public void cancelRemainingPreviousLogicalDependencies() {
        LogicalDependency<Object> dep;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                TruthMaintenanceSystemHelper.removeLogicalDependency(dep, this.activation.getPropagationContext());
            }
        }
        if (this.previousBlocked != null) {
            dep = this.previousBlocked.getFirst();
            while (dep != null) {
                LogicalDependency tmp = (LogicalDependency)dep.getNext();
                this.previousBlocked.remove(dep);
                AgendaItem justified = (AgendaItem)dep.getJustified();
                justified.getBlockers().remove((SimpleMode)dep.getMode());
                if (justified.getBlockers().isEmpty()) {
                    RuleAgendaItem ruleAgendaItem = justified.getRuleAgendaItem();
                    ((InternalAgenda)this.workingMemory.getAgenda()).stageLeftTuple(ruleAgendaItem, justified);
                }
                dep = tmp;
            }
        }
    }

    @Override
    public void cancelMatch(Match act) {
        AgendaItem match = (AgendaItem)act;
        ((RuleTerminalNode)match.getTerminalNode()).cancelMatch(match, this.workingMemory);
    }

    public FactHandle lookupFactHandle(Object object) {
        FactHandle handle = null;
        if (this.identityMap != null) {
            handle = this.identityMap.get(object);
        }
        if (handle != null) {
            return handle;
        }
        handle = this.getFactHandleFromWM(object);
        return handle;
    }

    @Override
    public FactHandle getFactHandle(Object object) {
        FactHandle handle = null;
        if (this.identityMap != null) {
            handle = this.identityMap.get(object);
        }
        if (handle != null) {
            return handle;
        }
        handle = this.getFactHandleFromWM(object);
        if (handle == null) {
            if (object instanceof CoreWrapper) {
                handle = this.getFactHandleFromWM(((CoreWrapper)object).getCore());
            }
            if (handle == null) {
                throw new RuntimeException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
            }
        }
        return handle;
    }

    @Override
    public FactHandle getFactHandle(FactHandle handle) {
        Object object = ((InternalFactHandle)handle).getObject();
        if ((handle = this.getFactHandleFromWM(object)) == null) {
            throw new RuntimeException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        return handle;
    }

    @Override
    public void update(FactHandle handle, Object newObject) {
        InternalFactHandle h = (InternalFactHandle)handle;
        ((InternalWorkingMemoryEntryPoint)h.getEntryPoint()).update(h, newObject, PropertySpecificUtil.onlyTraitBitSetMask(), newObject.getClass(), this.activation);
        if (this.getIdentityMap() != null) {
            this.getIdentityMap().put(newObject, handle);
        }
    }

    @Override
    public void update(FactHandle handle) {
        this.update(handle, Long.MAX_VALUE);
    }

    @Override
    public void update(FactHandle handle, BitMask mask, Class<?> modifiedClass) {
        InternalFactHandle h = (InternalFactHandle)handle;
        ((NamedEntryPoint)h.getEntryPoint()).update(h, h.getEqualityKey() != null && h.getEqualityKey().getStatus() == 2, ((InternalFactHandle)handle).getObject(), mask, modifiedClass, this.activation);
        if (h.isTraitOrTraitable()) {
            Thing x;
            if (h.isTraitable()) {
                if (((TraitableBean)h.getObject()).hasTraits()) {
                    this.updateTraits(h.getObject(), mask, null, modifiedClass, null, ((TraitableBean)h.getObject()).getMostSpecificTraits());
                }
            } else if (h.isTraiting() && (x = (Thing)h.getObject()) != x.getCore()) {
                Object core = x.getCore();
                InternalFactHandle coreHandle = (InternalFactHandle)this.getFactHandle(core);
                ((NamedEntryPoint)coreHandle.getEntryPoint()).update(coreHandle, coreHandle.getEqualityKey() != null && coreHandle.getEqualityKey().getStatus() == 2, core, mask, modifiedClass, this.activation);
                BitSet veto = ((TraitProxy)((Object)x)).getTypeCode();
                this.updateTraits(core, mask, x, modifiedClass, veto, ((TraitableBean)core).getMostSpecificTraits());
            }
        }
    }

    private void updateTraits(Object object, BitMask mask, Thing originator, Class<?> modifiedClass, BitSet veto, Collection<Thing> mostSpecificTraits) {
        this.updateManyTraits(object, mask, Arrays.asList(originator), modifiedClass, veto, mostSpecificTraits);
    }

    private void updateManyTraits(Object object, BitMask mask, Collection<Thing> originators, Class<?> modifiedClass, BitSet veto, Collection<Thing> mostSpecificTraits) {
        veto = veto != null ? (BitSet)veto.clone() : null;
        for (Thing t : mostSpecificTraits) {
            if (originators.contains(t)) continue;
            TraitProxy proxy = (TraitProxy)((Object)t);
            proxy.setTypeFilter(veto);
            InternalFactHandle h = (InternalFactHandle)this.lookupFactHandle(t);
            if (h != null) {
                ((NamedEntryPoint)h.getEntryPoint()).update(h, h.getEqualityKey() != null && h.getEqualityKey().getStatus() == 2, t, mask, modifiedClass, this.activation);
            }
            proxy.setTypeFilter(null);
            BitSet tc = proxy.getTypeCode();
            if (veto == null) {
                veto = (BitSet)tc.clone();
                continue;
            }
            veto.or(tc);
        }
    }

    @Override
    public void update(Object object) {
        this.update(object, PropertySpecificUtil.allSetButTraitBitMask(), Object.class);
    }

    @Override
    public void update(Object object, BitMask mask, Class<?> modifiedClass) {
        this.update(this.getFactHandle(object), mask, modifiedClass);
    }

    @Override
    public void retract(Object object) {
        this.delete(this.getFactHandle(object));
    }

    @Override
    public void retract(FactHandle handle) {
        this.delete(handle);
    }

    @Override
    public void delete(Object object) {
        this.delete(this.getFactHandle(object));
    }

    @Override
    public void delete(FactHandle handle) {
        Object o = ((InternalFactHandle)handle).getObject();
        ((InternalWorkingMemoryEntryPoint)((InternalFactHandle)handle).getEntryPoint()).delete(handle, this.activation.getRule(), this.activation);
        if (this.identityMap != null) {
            this.getIdentityMap().remove(o);
        }
    }

    @Override
    public RuleImpl getRule() {
        return this.activation.getRule();
    }

    @Override
    public Tuple getTuple() {
        return this.tuple;
    }

    @Override
    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public KnowledgeRuntime getKnowledgeRuntime() {
        return (StatefulKnowledgeSessionImpl)this.workingMemory;
    }

    @Override
    public Activation getMatch() {
        return this.activation;
    }

    @Override
    public void setFocus(String focus) {
        this.workingMemory.setFocus(focus);
    }

    @Override
    public Object get(Declaration declaration) {
        InternalWorkingMemoryEntryPoint wmTmp = (InternalWorkingMemoryEntryPoint)this.tuple.get(declaration).getEntryPoint();
        if (wmTmp != null) {
            Object object = declaration.getValue(wmTmp.getInternalWorkingMemory(), this.tuple.get(declaration).getObject());
            if (this.identityMap != null) {
                this.getIdentityMap().put(object, wmTmp.getFactHandleByIdentity(object));
            }
            return object;
        }
        return null;
    }

    @Override
    public Declaration getDeclaration(String identifier) {
        return ((AgendaItem)this.activation).getTerminalNode().getSubRule().getOuterDeclarations().get(identifier);
    }

    @Override
    public void halt() {
        this.workingMemory.halt();
    }

    @Override
    public EntryPoint getEntryPoint(String id) {
        return this.workingMemory.getEntryPoint(id);
    }

    @Override
    public Channel getChannel(String id) {
        return this.workingMemory.getChannels().get(id);
    }

    @Override
    public Map<String, Channel> getChannels() {
        return Collections.unmodifiableMap(this.workingMemory.getChannels());
    }

    @Override
    public IdentityHashMap<Object, FactHandle> getIdentityMap() {
        return this.identityMap;
    }

    @Override
    public void setIdentityMap(IdentityHashMap<Object, FactHandle> identityMap) {
        this.identityMap = identityMap;
    }

    private FactHandle getFactHandleFromWM(Object object) {
        FactHandle handle = null;
        for (EntryPoint entryPoint : this.workingMemory.getEntryPoints()) {
            handle = entryPoint.getFactHandle(object);
            if (this.identityMap != null) {
                this.identityMap.put(object, handle);
            }
            if (handle == null) continue;
            break;
        }
        return handle;
    }

    @Override
    public <T> T getContext(Class<T> contextClass) {
        Map<Long, String> nodeInstances;
        String ruleflowGroupName;
        if (ProcessContext.class.equals(contextClass) && (ruleflowGroupName = this.getMatch().getRule().getRuleFlowGroup()) != null && !(nodeInstances = ((InternalRuleFlowGroup)this.workingMemory.getAgenda().getRuleFlowGroup(ruleflowGroupName)).getNodeInstances()).isEmpty()) {
            if (nodeInstances.size() > 1) {
                throw new UnsupportedOperationException("Not supporting multiple node instances for the same ruleflow group");
            }
            Map.Entry<Long, String> entry = nodeInstances.entrySet().iterator().next();
            ProcessInstance processInstance = this.workingMemory.getProcessInstance(entry.getKey());
            org.drools.core.spi.ProcessContext context = new org.drools.core.spi.ProcessContext(this.workingMemory.getKnowledgeRuntime());
            context.setProcessInstance(processInstance);
            String nodeInstance = entry.getValue();
            String[] nodeInstanceIds = nodeInstance.split(":");
            NodeInstanceContainer container = (WorkflowProcessInstance)processInstance;
            block0: for (int i = 0; i < nodeInstanceIds.length; ++i) {
                for (NodeInstance subNodeInstance : container.getNodeInstances()) {
                    if (subNodeInstance.getId() != new Long(nodeInstanceIds[i]).longValue()) continue;
                    if (i == nodeInstanceIds.length - 1) {
                        context.setNodeInstance(subNodeInstance);
                        continue block0;
                    }
                    container = (NodeInstanceContainer)((Object)subNodeInstance);
                }
            }
            return (T)context;
        }
        return null;
    }

    @Override
    public void modify(Object newObject) {
    }

    @Override
    public KieRuntime getKieRuntime() {
        return this.getKnowledgeRuntime();
    }

    protected <K> ClassDefinition lookupClassDefinition(K core) {
        TypeDeclaration decl;
        InternalKnowledgePackage pack = this.getWorkingMemory().getKnowledgeBase().getPackage(core.getClass().getPackage().getName());
        if (pack != null && (decl = pack.getTypeDeclaration(core.getClass())) != null) {
            return decl.getTypeClassDef();
        }
        return null;
    }

    private <K> InternalFactHandle lookupHandleForWrapper(K core) {
        for (EntryPoint entryPoint : this.workingMemory.getEntryPoints()) {
            ObjectStore store = ((InternalWorkingMemoryEntryPoint)entryPoint).getObjectStore();
            Iterator iter = store.iterateFactHandles();
            while (iter.hasNext()) {
                InternalFactHandle handle = (InternalFactHandle)iter.next();
                if (!handle.isTraitable() || !(handle.getObject() instanceof CoreWrapper) || ((CoreWrapper)handle.getObject()).getCore() != core) continue;
                return handle;
            }
        }
        return null;
    }

    protected <T> void configureTrait(T thing, Object value) {
    }

    @Override
    public <T, K> T don(Thing<K> core, Class<T> trait, boolean logical) {
        return this.don((K)core, trait, logical, null);
    }

    @Override
    public <T, K> T don(Thing<K> core, Class<T> trait, Mode ... modes) {
        return this.don((K)core, trait, true, modes);
    }

    public <T, K> T don(Thing<K> core, Class<T> trait, boolean logical, Mode ... modes) {
        return this.don(core.getCore(), trait, logical, modes);
    }

    @Override
    public <T, K> T don(K core, Class<T> trait) {
        return this.don(core, trait, false);
    }

    @Override
    public <T, K> T don(Thing<K> core, Class<T> trait) {
        return this.don(core.getCore(), trait);
    }

    @Override
    public <T, K> T don(K core, Collection<Class<? extends Thing>> traits) {
        return this.don(core, traits, false);
    }

    @Override
    public <T, K> Thing<K> shed(Thing<K> thing, Class<T> trait) {
        return this.shed((TraitableBean)thing.getCore(), trait);
    }

    @Override
    public <T, K> T don(K core, Collection<Class<? extends Thing>> traits, Mode ... modes) {
        return this.don(core, traits, true, modes);
    }

    @Override
    public <T, K> T don(K core, Collection<Class<? extends Thing>> traits, boolean logical) {
        return this.don(core, traits, logical, null);
    }

    public <T, K> T don(K core, Collection<Class<? extends Thing>> traits, boolean logical, Mode ... modes) {
        if (core instanceof Thing && ((Thing)core).getCore() != core) {
            return this.don(((Thing)core).getCore(), traits, logical, modes);
        }
        if (traits.isEmpty()) {
            return (T)this.don(core, Thing.class, logical);
        }
        try {
            T thing = this.applyManyTraits(core, traits, null, logical, modes);
            return thing;
        }
        catch (LogicalTypeInconsistencyException ltie) {
            ltie.printStackTrace();
            return null;
        }
    }

    @Override
    public <T, K> T don(K core, Class<T> trait, boolean logical) {
        return this.don(core, trait, logical, null);
    }

    @Override
    public <T, K> T don(K core, Class<T> trait, Mode ... modes) {
        return this.don(core, trait, true, modes);
    }

    public <T, K> T don(K core, Class<T> trait, boolean logical, Mode ... modes) {
        if (core instanceof Thing && ((Thing)core).getCore() != core) {
            return this.don(((Thing)core).getCore(), trait, logical, modes);
        }
        try {
            T thing = this.applyTrait(core, trait, null, logical, modes);
            return thing;
        }
        catch (LogicalTypeInconsistencyException ltie) {
            ltie.printStackTrace();
            return null;
        }
    }

    protected <T> T doInsertTrait(T thing, Object core, boolean logical, BitSet boundary, Mode ... modes) {
        if (thing == core) {
            return thing;
        }
        ((TraitProxy)thing).setTypeFilter(boundary);
        if (logical) {
            this.insertLogical(thing, modes);
        } else {
            this.insert(thing);
        }
        ((TraitProxy)thing).setTypeFilter(null);
        return thing;
    }

    private <T, K> void refresh(T thing, K core, TraitableBean inner, Class<T> trait, Collection<Thing> mostSpecificTraits, boolean logical) {
        if (mostSpecificTraits != null) {
            this.updateCore(inner, core, trait, logical);
            if (!mostSpecificTraits.isEmpty()) {
                this.updateTraits(inner, PropertySpecificUtil.onlyTraitBitSetMask(), (Thing)thing, trait, null, mostSpecificTraits);
            }
        } else if (Thing.class == trait) {
            this.updateCore(inner, core, trait, logical);
        }
    }

    protected <T, K> T applyManyTraits(K core, Collection<Class<? extends Thing>> traits, Object value, boolean logical, Mode ... modes) throws LogicalTypeInconsistencyException {
        TraitFactory builder = TraitFactory.getTraitBuilderForKnowledgeBase(this.getKnowledgeRuntime().getKieBase());
        TraitableBean inner = this.makeTraitable(core, builder, logical);
        Collection<Thing> mostSpecificTraits = inner.getMostSpecificTraits();
        boolean newTraitsAdded = false;
        Thing firstThing = null;
        HashMap<Thing, BitSet> things = new HashMap<Thing, BitSet>(traits.size());
        this.checkStaticTypeCode(inner);
        for (Class<? extends Thing> trait : traits) {
            boolean needsUpdate;
            boolean needsProxy = trait.isAssignableFrom(inner.getClass());
            boolean hasTrait = inner.hasTrait(trait.getName());
            boolean bl = needsUpdate = needsProxy || core != inner;
            if (hasTrait) continue;
            BitSet boundary = inner.getCurrentTypeCode() != null ? (BitSet)inner.getCurrentTypeCode().clone() : null;
            Thing thing = this.asTrait(core, inner, trait, needsProxy, hasTrait, needsUpdate, builder, logical);
            this.configureTrait(thing, value);
            things.put(thing, boundary);
            if (newTraitsAdded || trait == Thing.class) continue;
            firstThing = thing;
            newTraitsAdded = true;
        }
        for (Thing t : things.keySet()) {
            this.doInsertTrait(t, core, logical, (BitSet)things.get(t), modes);
        }
        if (newTraitsAdded && mostSpecificTraits != null) {
            this.updateCore(inner, core, null, logical);
            if (!mostSpecificTraits.isEmpty()) {
                this.updateManyTraits(inner, PropertySpecificUtil.onlyTraitBitSetMask(), things.keySet(), core.getClass(), null, mostSpecificTraits);
            }
        }
        return (T)firstThing;
    }

    private void checkStaticTypeCode(TraitableBean inner) {
        TraitTypeMap ttm;
        if (!inner.hasTraits() && (ttm = (TraitTypeMap)inner._getTraitMap()) != null && ttm.getStaticTypeCode() == null) {
            TraitRegistry registry = this.workingMemory.getKnowledgeBase().getConfiguration().getComponentFactory().getTraitRegistry();
            BitSet staticCode = registry.getStaticTypeCode(inner.getClass().getName());
            ttm.setStaticTypeCode(staticCode);
            if (staticCode != null) {
                for (String staticTrait : registry.getStaticTypes(inner.getClass().getName())) {
                    ttm.addStaticTrait(staticTrait, registry.getHierarchy().getCode(staticTrait));
                }
            }
        }
    }

    protected <T, K> T applyTrait(K core, Class<T> trait, Object value, boolean logical, Mode ... modes) throws LogicalTypeInconsistencyException {
        if (this.identityMap == null) {
            this.identityMap = new IdentityHashMap();
        }
        TraitFactory builder = TraitFactory.getTraitBuilderForKnowledgeBase(this.getKnowledgeRuntime().getKieBase());
        TraitableBean inner = this.makeTraitable(core, builder, logical);
        boolean needsProxy = trait.isAssignableFrom(inner.getClass());
        boolean hasTrait = inner.hasTrait(trait.getName());
        boolean needsUpdate = needsProxy || core != inner;
        this.checkStaticTypeCode(inner);
        BitSet boundary = inner.getCurrentTypeCode() != null ? (BitSet)inner.getCurrentTypeCode().clone() : null;
        Collection<Thing> mostSpecificTraits = this.getTraitBoundary(inner, needsProxy, hasTrait, trait);
        T thing = this.asTrait(core, inner, trait, needsProxy, hasTrait, needsUpdate, builder, logical);
        this.configureTrait(thing, value);
        thing = this.doInsertTrait(thing, core, logical, boundary, modes);
        this.refresh(thing, core, inner, trait, mostSpecificTraits, logical);
        if (trait != Thing.class && inner._getFieldTMS() != null) {
            inner._getFieldTMS().resetModificationMask();
        }
        return thing;
    }

    private <T> void updateCore(TraitableBean inner, Object core, Class<T> trait, boolean logical) {
        FactHandle handle = this.lookupFactHandle(inner);
        InternalFactHandle h = (InternalFactHandle)handle;
        if (handle != null) {
            TraitFieldTMS fieldTMS = inner._getFieldTMS();
            BitMask mask = fieldTMS == null ? PropertySpecificUtil.onlyTraitBitSetMask() : fieldTMS.getModificationMask();
            ((NamedEntryPoint)h.getEntryPoint()).update(h, h.getEqualityKey() != null && h.getEqualityKey().getStatus() == 2, ((InternalFactHandle)handle).getObject(), mask, core.getClass(), this.activation);
        } else {
            handle = this.workingMemory.insert(inner, null, false, logical, this.activation.getRule(), this.activation);
            if (this.identityMap != null) {
                this.getIdentityMap().put(inner, handle);
            }
        }
    }

    @Override
    public <T, K, X extends TraitableBean> Thing<K> shed(TraitableBean<K, X> core, Class<T> trait) {
        Collection removedTypes;
        if (trait.isAssignableFrom(core.getClass())) {
            Collection removedTraits = core.removeTrait(trait.getName());
            if (!removedTraits.isEmpty()) {
                this.update(core, PropertySpecificUtil.onlyTraitBitSetMask(), core.getClass());
            }
            if (core instanceof Thing) {
                return (Thing)((Object)core);
            }
            return null;
        }
        Thing thing = core.getTrait(Thing.class.getName());
        if (trait == Thing.class) {
            ArrayList removedTypes2 = new ArrayList(core._getTraitMap().values());
            for (Thing thing2 : removedTypes2) {
                if (((TraitType)((Object)thing2)).isVirtual()) continue;
                this.retract(thing2);
            }
            core._getTraitMap().clear();
            core._setTraitMap(null);
            return thing;
        }
        if (core.hasTrait(trait.getName())) {
            removedTypes = core.removeTrait(trait.getName());
        } else {
            HierarchyEncoder<String> hier = this.workingMemory.getKnowledgeBase().getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
            BitSet bitSet = hier.getCode(trait.getName());
            removedTypes = core.removeTrait(bitSet);
        }
        removedTypes = new ArrayList(removedTypes);
        for (Thing thing3 : removedTypes) {
            if (((TraitType)((Object)thing3)).isVirtual()) continue;
            this.retract(thing3);
        }
        if (!core.hasTraits()) {
            this.don(core, Thing.class);
        } else if (!removedTypes.isEmpty()) {
            this.update(core, PropertySpecificUtil.onlyTraitBitSetMask(), core.getClass());
        }
        return thing;
    }

    protected Collection<Thing> getTraitBoundary(TraitableBean inner, boolean needsProxy, boolean hasTrait, Class trait) {
        boolean refresh;
        boolean bl = refresh = !needsProxy && !hasTrait && Thing.class != trait;
        if (refresh) {
            return inner.getMostSpecificTraits();
        }
        return null;
    }

    private <T, K> T asTrait(K core, TraitableBean inner, Class<T> trait, boolean needsProxy, boolean hasTrait, boolean needsUpdate, TraitFactory builder, boolean logical) throws LogicalTypeInconsistencyException {
        Thing<Object> thing;
        if (needsProxy) {
            thing = inner;
            inner.addTrait(trait.getName(), (Thing)core);
        } else {
            thing = hasTrait ? inner.getTrait(trait.getName()) : builder.getProxy(inner, trait, logical);
        }
        if (needsUpdate) {
            InternalFactHandle h = (InternalFactHandle)this.lookupFactHandle(core);
            if (h == null) {
                h = this.lookupHandleForWrapper(core);
            }
            if (h == null) {
                h = (InternalFactHandle)this.workingMemory.insert(core, null, false, logical, this.activation.getRule(), this.activation);
                if (this.identityMap != null) {
                    this.getIdentityMap().put(core, h);
                }
            }
            if (!h.isTraitOrTraitable()) {
                throw new IllegalStateException("A traited working memory element is being used with a default fact handle. Please verify that its class was declared as @Traitable : " + core.getClass().getName());
            }
            this.update(h, inner);
        }
        return (T)thing;
    }

    private <K> TraitableBean makeTraitable(K core, TraitFactory builder, boolean logical) {
        TraitableBean<K, CoreWrapper<K>> inner;
        boolean needsWrapping = !(core instanceof TraitableBean);
        ClassDefinition coreDef = this.lookupClassDefinition(core);
        TraitableBean<K, CoreWrapper<K>> traitableBean = inner = needsWrapping ? builder.asTraitable(core, coreDef) : (TraitableBean<K, CoreWrapper<K>>)core;
        if (needsWrapping) {
            InternalFactHandle h = (InternalFactHandle)this.lookupFactHandle(core);
            InternalWorkingMemoryEntryPoint ep = h != null ? (InternalWorkingMemoryEntryPoint)h.getEntryPoint() : (InternalWorkingMemoryEntryPoint)((StatefulKnowledgeSessionImpl)this.workingMemory).getEntryPoint("DEFAULT");
            ObjectTypeConfigurationRegistry reg = ep.getObjectTypeConfigurationRegistry();
            ObjectTypeConf coreConf = reg.getObjectTypeConf(ep.getEntryPoint(), core);
            ObjectTypeConf innerConf = reg.getObjectTypeConf(ep.getEntryPoint(), inner);
            if (coreConf.isTMSEnabled()) {
                innerConf.enableTMS();
            }
            if (inner._getFieldTMS() != null && inner._getFieldTMS().needsInit()) {
                inner._getFieldTMS().init(this.workingMemory);
            }
        } else {
            TraitFieldTMS ftms = inner._getFieldTMS();
            if (ftms != null) {
                FactHandle handle = this.lookupFactHandle(inner);
                if (handle == null) {
                    handle = this.workingMemory.insert(inner, null, false, logical, this.activation.getRule(), this.activation);
                    if (this.identityMap != null) {
                        this.getIdentityMap().put(inner, handle);
                    }
                }
                if (ftms.needsInit()) {
                    ftms.init(this.workingMemory);
                }
            }
        }
        return inner;
    }
}

