/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.math.BigDecimal;
import org.kie.api.runtime.rule.AccumulateFunction;

public class BigDecimalAverageAccumulateFunction
implements AccumulateFunction {
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public Serializable createContext() {
        return new AverageData();
    }

    @Override
    public void init(Serializable context) throws Exception {
        AverageData data = (AverageData)context;
        data.count = 0;
        data.total = BigDecimal.ZERO;
    }

    @Override
    public void accumulate(Serializable context, Object value) {
        AverageData data = (AverageData)context;
        ++data.count;
        data.total = data.total.add(BigDecimal.valueOf(((Number)value).doubleValue()));
    }

    @Override
    public void reverse(Serializable context, Object value) throws Exception {
        AverageData data = (AverageData)context;
        --data.count;
        data.total = data.total.subtract(BigDecimal.valueOf(((Number)value).doubleValue()));
    }

    @Override
    public Object getResult(Serializable context) throws Exception {
        AverageData data = (AverageData)context;
        return data.count == 0 ? BigDecimal.ZERO : data.total.divide(BigDecimal.valueOf(data.count));
    }

    @Override
    public boolean supportsReverse() {
        return true;
    }

    @Override
    public Class<?> getResultType() {
        return Number.class;
    }

    public static class AverageData
    implements Externalizable {
        public int count = 0;
        public BigDecimal total = BigDecimal.ZERO;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.count = in.readInt();
            this.total = (BigDecimal)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.count);
            out.writeObject(this.total);
        }
    }
}

