/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.math.BigDecimal;
import org.kie.api.runtime.rule.AccumulateFunction;

public class BigDecimalSumAccumulateFunction
implements AccumulateFunction {
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public Serializable createContext() {
        return new SumData();
    }

    @Override
    public void init(Serializable context) throws Exception {
        SumData data = (SumData)context;
        data.total = BigDecimal.ZERO;
    }

    @Override
    public void accumulate(Serializable context, Object value) {
        SumData data = (SumData)context;
        data.total = data.total.add(BigDecimal.valueOf(((Number)value).doubleValue()));
    }

    @Override
    public void reverse(Serializable context, Object value) throws Exception {
        SumData data = (SumData)context;
        data.total = data.total.subtract(BigDecimal.valueOf(((Number)value).doubleValue()));
    }

    @Override
    public Object getResult(Serializable context) throws Exception {
        SumData data = (SumData)context;
        return data.total;
    }

    @Override
    public boolean supportsReverse() {
        return true;
    }

    @Override
    public Class<?> getResultType() {
        return Number.class;
    }

    protected static class SumData
    implements Externalizable {
        public BigDecimal total = BigDecimal.ZERO;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.total = (BigDecimal)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.total);
        }
    }
}

