/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kie.api.runtime.rule.AccumulateFunction;

public class CollectListAccumulateFunction
implements AccumulateFunction {
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public Serializable createContext() {
        return new CollectListData();
    }

    @Override
    public void init(Serializable context) throws Exception {
        CollectListData data = (CollectListData)context;
        data.list.clear();
    }

    @Override
    public void accumulate(Serializable context, Object value) {
        CollectListData data = (CollectListData)context;
        data.list.add(value);
    }

    @Override
    public void reverse(Serializable context, Object value) throws Exception {
        CollectListData data = (CollectListData)context;
        data.list.remove(value);
    }

    @Override
    public Object getResult(Serializable context) throws Exception {
        CollectListData data = (CollectListData)context;
        return Collections.unmodifiableList(data.list);
    }

    @Override
    public boolean supportsReverse() {
        return true;
    }

    @Override
    public Class<?> getResultType() {
        return List.class;
    }

    public static class CollectListData
    implements Externalizable {
        public List<Object> list = new ArrayList<Object>();

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.list = (List)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.list);
        }
    }
}

