/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.spi.MvelAccumulator;
import org.drools.core.spi.Tuple;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;

public class MVELAccumulatorFunctionExecutor
implements MVELCompileable,
Externalizable,
MvelAccumulator {
    private static final long serialVersionUID = 510L;
    private MVELCompilationUnit unit;
    private AccumulateFunction function;
    private Serializable expression;

    public MVELAccumulatorFunctionExecutor() {
    }

    public MVELAccumulatorFunctionExecutor(MVELCompilationUnit unit, AccumulateFunction function) {
        this.unit = unit;
        this.function = function;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.unit = (MVELCompilationUnit)in.readObject();
        this.function = (AccumulateFunction)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.unit);
        out.writeObject(this.function);
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData) {
        this.expression = this.unit.getCompiledExpression(runtimeData);
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData, RuleImpl rule) {
        this.expression = this.unit.getCompiledExpression(runtimeData, rule.toRuleNameAndPathString());
    }

    @Override
    public Serializable createContext() {
        MVELAccumulatorFunctionContext context = new MVELAccumulatorFunctionContext();
        context.context = this.function.createContext();
        if (this.function.supportsReverse()) {
            context.reverseSupport = new HashMap<Integer, Object>();
        }
        return context;
    }

    @Override
    public void init(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
        this.function.init(((MVELAccumulatorFunctionContext)context).context);
    }

    @Override
    public void accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        VariableResolverFactory factory = this.unit.getFactory(null, null, null, handle, (LeftTuple)leftTuple, null, (InternalWorkingMemory)workingMemory, workingMemory.getGlobalResolver());
        Object value = MVEL.executeExpression((Object)this.expression, handle.getObject(), factory);
        if (this.function.supportsReverse()) {
            ((MVELAccumulatorFunctionContext)context).reverseSupport.put(handle.getId(), value);
        }
        this.function.accumulate(((MVELAccumulatorFunctionContext)context).context, value);
    }

    @Override
    public void reverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        Object value = ((MVELAccumulatorFunctionContext)context).reverseSupport.remove(handle.getId());
        this.function.reverse(((MVELAccumulatorFunctionContext)context).context, value);
    }

    @Override
    public Object getResult(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
        return this.function.getResult(((MVELAccumulatorFunctionContext)context).context);
    }

    @Override
    public boolean supportsReverse() {
        return this.function.supportsReverse();
    }

    @Override
    public Object createWorkingMemoryContext() {
        return null;
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.unit.getPreviousDeclarations();
    }

    private static class MVELAccumulatorFunctionContext
    implements Externalizable {
        public Serializable context;
        public Map<Integer, Object> reverseSupport;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.context = (Serializable)in.readObject();
            this.reverseSupport = (Map)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.context);
            out.writeObject(this.reverseSupport);
        }
    }
}

