/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.impl;

import java.util.Collection;
import org.drools.core.command.CommandService;
import org.drools.core.command.runtime.GetFactCountInEntryPointCommand;
import org.drools.core.command.runtime.rule.DeleteFromEntryPointCommand;
import org.drools.core.command.runtime.rule.GetFactHandleInEntryPointCommand;
import org.drools.core.command.runtime.rule.GetFactHandlesInEntryPointCommand;
import org.drools.core.command.runtime.rule.GetObjectInEntryPointCommand;
import org.drools.core.command.runtime.rule.GetObjectsInEntryPointCommand;
import org.drools.core.command.runtime.rule.InsertObjectInEntryPointCommand;
import org.drools.core.command.runtime.rule.UpdateInEntryPointCommand;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;

public class CommandBasedEntryPoint
implements EntryPoint {
    private final CommandService commandService;
    private final String entryPoint;

    public CommandBasedEntryPoint(CommandService commandService, String entryPoint) {
        this.commandService = commandService;
        this.entryPoint = entryPoint;
    }

    @Override
    public String getEntryPointId() {
        return this.entryPoint;
    }

    @Override
    public FactHandle insert(Object object) {
        return this.commandService.execute(new InsertObjectInEntryPointCommand(object, this.entryPoint));
    }

    @Override
    public void retract(FactHandle handle) {
        this.delete(handle);
    }

    @Override
    public void delete(FactHandle handle) {
        this.commandService.execute(new DeleteFromEntryPointCommand(handle, this.entryPoint));
    }

    @Override
    public void update(FactHandle handle, Object object) {
        this.commandService.execute(new UpdateInEntryPointCommand(handle, object, this.entryPoint));
    }

    @Override
    public FactHandle getFactHandle(Object object) {
        return this.commandService.execute(new GetFactHandleInEntryPointCommand(object, this.entryPoint));
    }

    @Override
    public Object getObject(FactHandle factHandle) {
        return this.commandService.execute(new GetObjectInEntryPointCommand(factHandle, this.entryPoint));
    }

    @Override
    public Collection<? extends Object> getObjects() {
        return this.commandService.execute(new GetObjectsInEntryPointCommand(null, this.entryPoint));
    }

    @Override
    public Collection<? extends Object> getObjects(ObjectFilter filter) {
        return this.commandService.execute(new GetObjectsInEntryPointCommand(filter, this.entryPoint));
    }

    @Override
    public <T extends FactHandle> Collection<T> getFactHandles() {
        return this.commandService.execute(new GetFactHandlesInEntryPointCommand(this.entryPoint));
    }

    @Override
    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return this.commandService.execute(new GetFactHandlesInEntryPointCommand(this.entryPoint, filter));
    }

    @Override
    public long getFactCount() {
        return this.commandService.execute(new GetFactCountInEntryPointCommand(this.entryPoint));
    }
}

