/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.drools.core.command.CommandService;
import org.drools.core.command.GetSessionClockCommand;
import org.drools.core.command.Interceptor;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.command.runtime.AddEventListenerCommand;
import org.drools.core.command.runtime.DestroySessionCommand;
import org.drools.core.command.runtime.DisposeCommand;
import org.drools.core.command.runtime.GetCalendarsCommand;
import org.drools.core.command.runtime.GetChannelsCommand;
import org.drools.core.command.runtime.GetEnvironmentCommand;
import org.drools.core.command.runtime.GetFactCountCommand;
import org.drools.core.command.runtime.GetGlobalCommand;
import org.drools.core.command.runtime.GetGlobalsCommand;
import org.drools.core.command.runtime.GetIdCommand;
import org.drools.core.command.runtime.GetKnowledgeBaseCommand;
import org.drools.core.command.runtime.RegisterChannelCommand;
import org.drools.core.command.runtime.RemoveEventListenerCommand;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.UnregisterChannelCommand;
import org.drools.core.command.runtime.process.AbortProcessInstanceCommand;
import org.drools.core.command.runtime.process.AbortWorkItemCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.CreateCorrelatedProcessInstanceCommand;
import org.drools.core.command.runtime.process.CreateProcessInstanceCommand;
import org.drools.core.command.runtime.process.GetProcessEventListenersCommand;
import org.drools.core.command.runtime.process.GetProcessInstanceByCorrelationKeyCommand;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.drools.core.command.runtime.process.GetProcessInstancesCommand;
import org.drools.core.command.runtime.process.GetWorkItemCommand;
import org.drools.core.command.runtime.process.RegisterWorkItemHandlerCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartCorrelatedProcessCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.process.StartProcessInstanceCommand;
import org.drools.core.command.runtime.rule.AgendaGroupSetFocusCommand;
import org.drools.core.command.runtime.rule.ClearActivationGroupCommand;
import org.drools.core.command.runtime.rule.ClearAgendaCommand;
import org.drools.core.command.runtime.rule.ClearAgendaGroupCommand;
import org.drools.core.command.runtime.rule.ClearRuleFlowGroupCommand;
import org.drools.core.command.runtime.rule.DeleteCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.FireUntilHaltCommand;
import org.drools.core.command.runtime.rule.GetAgendaEventListenersCommand;
import org.drools.core.command.runtime.rule.GetEntryPointCommand;
import org.drools.core.command.runtime.rule.GetEntryPointsCommand;
import org.drools.core.command.runtime.rule.GetFactHandleCommand;
import org.drools.core.command.runtime.rule.GetFactHandlesCommand;
import org.drools.core.command.runtime.rule.GetObjectCommand;
import org.drools.core.command.runtime.rule.GetObjectsCommand;
import org.drools.core.command.runtime.rule.GetRuleRuntimeEventListenersCommand;
import org.drools.core.command.runtime.rule.HaltCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.command.runtime.rule.QueryCommand;
import org.drools.core.command.runtime.rule.UpdateCommand;
import org.drools.core.impl.AbstractRuntime;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.WorkItemManager;
import org.drools.core.rule.EntryPointId;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.Calendars;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.rule.ActivationGroup;
import org.kie.api.runtime.rule.Agenda;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.AgendaGroup;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.LiveQuery;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.RuleFlowGroup;
import org.kie.api.runtime.rule.ViewChangedEventListener;
import org.kie.api.time.SessionClock;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class CommandBasedStatefulKnowledgeSession
extends AbstractRuntime
implements StatefulKnowledgeSession,
CorrelationAwareProcessRuntime {
    private CommandService commandService;
    private transient WorkItemManager workItemManager;
    private transient Agenda agenda;

    public CommandBasedStatefulKnowledgeSession(CommandService commandService) {
        this.commandService = commandService;
    }

    @Override
    @Deprecated
    public int getId() {
        return this.commandService.execute(new GetIdCommand()).intValue();
    }

    @Override
    public long getIdentifier() {
        return this.commandService.execute(new GetIdCommand());
    }

    @Override
    public ProcessInstance getProcessInstance(long id) {
        GetProcessInstanceCommand command = new GetProcessInstanceCommand();
        command.setProcessInstanceId(id);
        return this.commandService.execute(command);
    }

    @Override
    public ProcessInstance getProcessInstance(long id, boolean readOnly) {
        GetProcessInstanceCommand command = new GetProcessInstanceCommand();
        command.setProcessInstanceId(id);
        command.setReadOnly(readOnly);
        return this.commandService.execute(command);
    }

    @Override
    public void abortProcessInstance(long id) {
        AbortProcessInstanceCommand command = new AbortProcessInstanceCommand();
        command.setProcessInstanceId(id);
        this.commandService.execute(command);
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    @Override
    public Collection<ProcessInstance> getProcessInstances() {
        return this.commandService.execute(new GetProcessInstancesCommand());
    }

    @Override
    public WorkItemManager getWorkItemManager() {
        if (this.workItemManager == null) {
            this.workItemManager = new WorkItemManager(){

                @Override
                public void completeWorkItem(long id, Map<String, Object> results) {
                    CompleteWorkItemCommand command = new CompleteWorkItemCommand();
                    command.setWorkItemId(id);
                    command.setResults(results);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public void abortWorkItem(long id) {
                    AbortWorkItemCommand command = new AbortWorkItemCommand();
                    command.setWorkItemId(id);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
                    RegisterWorkItemHandlerCommand command = new RegisterWorkItemHandlerCommand();
                    command.setWorkItemName(workItemName);
                    command.setHandler(handler);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public WorkItem getWorkItem(long id) {
                    GetWorkItemCommand command = new GetWorkItemCommand();
                    command.setWorkItemId(id);
                    return CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Set<WorkItem> getWorkItems() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void internalAbortWorkItem(long id) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void internalAddWorkItem(WorkItem workItem) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void internalExecuteWorkItem(WorkItem workItem) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void signalEvent(String type, Object event) {
                    SignalEventCommand command = new SignalEventCommand(type, event);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public void signalEvent(String type, Object event, long processInstanceId) {
                    SignalEventCommand command = new SignalEventCommand(processInstanceId, type, event);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public void dispose() {
                }
            };
        }
        return this.workItemManager;
    }

    @Override
    public void signalEvent(String type, Object event) {
        SignalEventCommand command = new SignalEventCommand(type, event);
        this.commandService.execute(command);
    }

    @Override
    public void signalEvent(String type, Object event, long processInstanceId) {
        SignalEventCommand command = new SignalEventCommand(processInstanceId, type, event);
        this.commandService.execute(command);
    }

    @Override
    public ProcessInstance startProcess(String processId) {
        return this.startProcess(processId, null);
    }

    @Override
    public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        StartProcessCommand command = new StartProcessCommand();
        command.setProcessId(processId);
        command.setParameters(parameters);
        return this.commandService.execute(command);
    }

    @Override
    public ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        CreateProcessInstanceCommand command = new CreateProcessInstanceCommand();
        command.setProcessId(processId);
        command.setParameters(parameters);
        return this.commandService.execute(command);
    }

    @Override
    public ProcessInstance startProcessInstance(long processInstanceId) {
        StartProcessInstanceCommand command = new StartProcessInstanceCommand();
        command.setProcessInstanceId(processInstanceId);
        return this.commandService.execute(command);
    }

    @Override
    public void dispose() {
        this.commandService.execute(new DisposeCommand());
    }

    @Override
    public void destroy() {
        this.commandService.execute(new DestroySessionCommand(this.commandService));
    }

    @Override
    public int fireAllRules() {
        return this.commandService.execute(new FireAllRulesCommand());
    }

    @Override
    public int fireAllRules(int max) {
        return this.commandService.execute(new FireAllRulesCommand(max));
    }

    @Override
    public int fireAllRules(AgendaFilter agendaFilter) {
        return this.commandService.execute(new FireAllRulesCommand(agendaFilter));
    }

    @Override
    public int fireAllRules(AgendaFilter agendaFilter, int max) {
        return this.commandService.execute(new FireAllRulesCommand(agendaFilter, max));
    }

    @Override
    public void fireUntilHalt() {
        this.commandService.execute(new FireUntilHaltCommand());
    }

    @Override
    public void fireUntilHalt(AgendaFilter agendaFilter) {
        this.commandService.execute(new FireUntilHaltCommand(agendaFilter));
    }

    @Override
    public KnowledgeBase getKieBase() {
        return this.commandService.execute(new GetKnowledgeBaseCommand());
    }

    @Override
    public void registerChannel(String name, Channel channel) {
        this.commandService.execute(new RegisterChannelCommand(name, channel));
    }

    @Override
    public void unregisterChannel(String name) {
        this.commandService.execute(new UnregisterChannelCommand(name));
    }

    @Override
    public Map<String, Channel> getChannels() {
        return (Map)this.commandService.execute(new GetChannelsCommand());
    }

    @Override
    public Agenda getAgenda() {
        if (this.agenda == null) {
            this.agenda = new Agenda(){

                @Override
                public void clear() {
                    ClearAgendaCommand command = new ClearAgendaCommand();
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public ActivationGroup getActivationGroup(final String name) {
                    return new ActivationGroup(){

                        @Override
                        public void clear() {
                            ClearActivationGroupCommand command = new ClearActivationGroupCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }

                        @Override
                        public String getName() {
                            return name;
                        }
                    };
                }

                @Override
                public AgendaGroup getAgendaGroup(final String name) {
                    return new AgendaGroup(){

                        @Override
                        public void clear() {
                            ClearAgendaGroupCommand command = new ClearAgendaGroupCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }

                        @Override
                        public String getName() {
                            return name;
                        }

                        @Override
                        public void setFocus() {
                            AgendaGroupSetFocusCommand command = new AgendaGroupSetFocusCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }
                    };
                }

                @Override
                public RuleFlowGroup getRuleFlowGroup(final String name) {
                    return new RuleFlowGroup(){

                        @Override
                        public void clear() {
                            ClearRuleFlowGroupCommand command = new ClearRuleFlowGroupCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }

                        @Override
                        public String getName() {
                            return name;
                        }
                    };
                }
            };
        }
        return this.agenda;
    }

    @Override
    public FactHandle getFactHandle(Object object) {
        return this.commandService.execute(new GetFactHandleCommand(object));
    }

    @Override
    public <T extends FactHandle> Collection<T> getFactHandles() {
        return this.commandService.execute(new GetFactHandlesCommand());
    }

    @Override
    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return this.commandService.execute(new GetFactHandlesCommand(filter));
    }

    @Override
    public Collection<? extends Object> getObjects() {
        return this.getObjects(null);
    }

    @Override
    public Collection<? extends Object> getObjects(ObjectFilter filter) {
        Collection result = this.commandService.execute(new GetObjectsCommand(filter));
        return result;
    }

    @Override
    public <T extends SessionClock> T getSessionClock() {
        return (T)this.commandService.execute(new GetSessionClockCommand());
    }

    @Override
    public EntryPoint getEntryPoint(String name) {
        return this.commandService.execute(new GetEntryPointCommand(name));
    }

    @Override
    public Collection<? extends EntryPoint> getEntryPoints() {
        return this.commandService.execute(new GetEntryPointsCommand());
    }

    @Override
    public void halt() {
        this.commandService.execute(new HaltCommand());
    }

    @Override
    public FactHandle insert(Object object) {
        return this.commandService.execute(new InsertObjectCommand(object));
    }

    @Override
    public void retract(FactHandle handle) {
        this.commandService.execute(new DeleteCommand(handle));
    }

    @Override
    public void delete(FactHandle handle) {
        this.commandService.execute(new DeleteCommand(handle));
    }

    @Override
    public void update(FactHandle handle, Object object) {
        this.commandService.execute(new UpdateCommand(handle, object));
    }

    @Override
    public void addEventListener(RuleRuntimeEventListener listener) {
        this.commandService.execute(new AddEventListenerCommand(listener));
    }

    @Override
    public void addEventListener(AgendaEventListener listener) {
        this.commandService.execute(new AddEventListenerCommand(listener));
    }

    @Override
    public Collection<AgendaEventListener> getAgendaEventListeners() {
        return this.commandService.execute(new GetAgendaEventListenersCommand());
    }

    @Override
    public Collection<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
        return this.commandService.execute(new GetRuleRuntimeEventListenersCommand());
    }

    @Override
    public void removeEventListener(RuleRuntimeEventListener listener) {
        this.commandService.execute(new RemoveEventListenerCommand(listener));
    }

    @Override
    public void removeEventListener(AgendaEventListener listener) {
        this.commandService.execute(new RemoveEventListenerCommand(listener));
    }

    @Override
    public void addEventListener(ProcessEventListener listener) {
        this.commandService.execute(new AddEventListenerCommand(listener));
    }

    @Override
    public Collection<ProcessEventListener> getProcessEventListeners() {
        return this.commandService.execute(new GetProcessEventListenersCommand());
    }

    @Override
    public void removeEventListener(ProcessEventListener listener) {
        this.commandService.execute(new RemoveEventListenerCommand(listener));
    }

    @Override
    public Object getGlobal(String identifier) {
        return this.commandService.execute(new GetGlobalCommand(identifier));
    }

    @Override
    public void setGlobal(String identifier, Object object) {
        this.commandService.execute(new SetGlobalCommand(identifier, object));
    }

    @Override
    public Globals getGlobals() {
        return this.commandService.execute(new GetGlobalsCommand());
    }

    @Override
    public Calendars getCalendars() {
        return this.commandService.execute(new GetCalendarsCommand());
    }

    @Override
    public Object getObject(FactHandle factHandle) {
        return this.commandService.execute(new GetObjectCommand(factHandle));
    }

    @Override
    public Environment getEnvironment() {
        return this.commandService.execute(new GetEnvironmentCommand());
    }

    @Override
    public <T> T execute(Command<T> command) {
        return this.commandService.execute(command);
    }

    @Override
    public QueryResults getQueryResults(String query, Object ... arguments) {
        QueryCommand cmd = new QueryCommand(null, query, arguments);
        return this.commandService.execute(cmd);
    }

    @Override
    public String getEntryPointId() {
        return EntryPointId.DEFAULT.getEntryPointId();
    }

    @Override
    public long getFactCount() {
        return this.commandService.execute(new GetFactCountCommand());
    }

    @Override
    public LiveQuery openLiveQuery(String query, Object[] arguments, ViewChangedEventListener listener) {
        return null;
    }

    @Override
    public KieSessionConfiguration getSessionConfiguration() {
        return ((KnowledgeCommandContext)this.commandService.getContext()).getKieSession().getSessionConfiguration();
    }

    public void addInterceptor(Interceptor interceptor) {
        interceptor.setNext(this.commandService);
        this.commandService = interceptor;
    }

    @Override
    public ProcessInstance startProcess(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        return this.commandService.execute(new StartCorrelatedProcessCommand(processId, correlationKey, parameters));
    }

    @Override
    public ProcessInstance createProcessInstance(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        return this.commandService.execute(new CreateCorrelatedProcessInstanceCommand(processId, correlationKey, parameters));
    }

    @Override
    public ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        return this.commandService.execute(new GetProcessInstanceByCorrelationKeyCommand(correlationKey));
    }
}

